/*
 * Decompiled with CFR 0.152.
 */
package commvault.web.creconn;

import commvault.web.core.util.CVCoreUtil;
import commvault.web.creconn.DataStatementOperation;
import commvault.web.creconn.QueryExecutor;
import commvault.web.creconn.QueryExecutorImpl;
import commvault.web.creconn.db.MetricsDataOpReq;
import commvault.web.creconn.exception.MetricsException;
import commvault.web.creconn.model.RowMap;
import java.io.IOException;
import javax.servlet.ServletException;
import javax.servlet.annotation.WebServlet;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.log4j.Logger;

@WebServlet(value={"/testCRE.do"})
public class TestHandler
extends HttpServlet {
    private static final long serialVersionUID = 1L;
    private static final Logger logger = Logger.getLogger(TestHandler.class);
    private QueryExecutor executor = CVCoreUtil.lookup(QueryExecutorImpl.class);

    public TestHandler() {
        logger.info((Object)"TestCRE handler object created");
    }

    protected void doGet(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ServletException, IOException {
        this.doPost(httpServletRequest, httpServletResponse);
    }

    protected void doPost(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ServletException, IOException {
        MetricsDataOpReq metricsDataOpReq = new MetricsDataOpReq(DataStatementOperation.GATHERLOG_COMMCELLDETAILS);
        metricsDataOpReq.addParam("uniqID", (Object)17925);
        try {
            this.executor.executeOperation(metricsDataOpReq);
            if (this.executor.hasRecords()) {
                RowMap rowMap = this.executor.getFirstRow();
                logger.info((Object)("version:" + rowMap.getString("version")));
                logger.info((Object)("ID:" + rowMap.getString("ID")));
                logger.info((Object)("commcellname:" + rowMap.getString("commcellname")));
                logger.info((Object)("IsChecked:" + rowMap.getString("IsChecked").toLowerCase()));
                logger.info((Object)("IsChargebackChecked:" + rowMap.getString("IsChargebackChecked").toLowerCase()));
                logger.info((Object)("CommCellID:" + rowMap.getString("CommCellID")));
                logger.info((Object)("customername:" + rowMap.getString("customername")));
                logger.info((Object)("enabledservices:" + rowMap.getString("enabledservices")));
                logger.info((Object)("CommServGUID:" + rowMap.getString("CommServGUID")));
            }
        }
        catch (MetricsException metricsException) {
            logger.error((Object)"Error while connection to CRE MEtric DB", (Throwable)metricsException);
        }
        httpServletResponse.getWriter().println("test");
    }
}

