/*
 * Decompiled with CFR 0.152.
 */
package commvault.web.creconn;

import commvault.web.core.filter.RequestContext;
import commvault.web.creconn.OpReq;
import commvault.web.creconn.QueryExecutor;
import commvault.web.creconn.dto.ReportDataResponse;
import commvault.web.creconn.entity.DataType;
import commvault.web.creconn.entity.Field;
import commvault.web.creconn.exception.MetricsException;
import commvault.web.creconn.model.DataFormatDefinition;
import commvault.web.creconn.model.JQGridModel;
import commvault.web.creconn.model.RowMap;
import commvault.web.creconn.service.DBService;
import commvault.web.creconn.service.DBServiceImpl;
import commvault.web.creconn.util.DataTableConverter;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.enterprise.context.RequestScoped;
import javax.inject.Named;
import org.apache.log4j.Logger;

@Named(value="MetricsDB")
@RequestScoped
public class QueryExecutorImpl
implements QueryExecutor {
    private static final Logger logger = Logger.getLogger((String)"commvault.web");
    public static final String H2_AUTO_ID = "h2_auto_id";
    public static final String DATA_SOURCE = "Data Source";
    private ReportDataResponse result;
    private DataFormatDefinition definition;
    private boolean queryRan;
    private String cacheID;
    private DBService service = new DBServiceImpl();

    @Override
    public ReportDataResponse executeOperation(OpReq opReq) throws MetricsException {
        return this.executeOperation(opReq, new DataFormatDefinition());
    }

    @Override
    public ReportDataResponse executeOperation(OpReq opReq, DataFormatDefinition dataFormatDefinition) throws MetricsException {
        logger.debug((Object)("Operation: " + opReq.getOperation().name()));
        this.setDefinition(dataFormatDefinition);
        this.result = this.getService().performOperation(opReq);
        this.cacheID = this.result.getCacheId();
        this.queryRan = true;
        this.processColumns();
        return this.result;
    }

    @Override
    public boolean executeUpdate(OpReq opReq) throws MetricsException {
        logger.debug((Object)("Operation: " + opReq.getOperation().name()));
        try {
            this.result = this.getService().performOperation(opReq);
            if (this.hasRecords() && this.getRecordsCount() == 1) {
                List<Object> list = this.getRows().get(0);
                this.queryRan = !Boolean.parseBoolean(list.get(0).toString());
            }
        }
        catch (MetricsException metricsException) {
            List<String> list = metricsException.getFailures();
            if (list.contains("The statement did not return a result set.") && list.size() == 1) {
                this.queryRan = true;
            }
            throw metricsException;
        }
        return this.queryRan;
    }

    private void processColumns() {
        if (this.result.getColumns() != null) {
            int n = 0;
            List<Field> list = this.result.getColumns();
            if (this.result.getRecords() != null && !this.result.getRecords().isEmpty()) {
                for (n = 0; n < this.result.getRecords().size(); ++n) {
                    List list2 = (List)this.result.getRecords().get(n);
                    for (int i = 0; i < list.size(); ++i) {
                        if (list2.get(i) == null || !(list2.get(i) instanceof Double)) continue;
                        if (list.get(i).getType() == DataType.TimeStamp || list.get(i).getType() == DataType.Time || list.get(i).getType() == DataType.Date) {
                            Date date = new Date();
                            date.setTime(((Double)list2.get(i)).longValue());
                            list2.set(i, date);
                            continue;
                        }
                        if (list.get(i).getType() == DataType.Short) {
                            list2.set(i, ((Double)list2.get(i)).intValue());
                            continue;
                        }
                        if (list.get(i).getType() == DataType.Integer) {
                            list2.set(i, ((Double)list2.get(i)).intValue());
                            continue;
                        }
                        if (list.get(i).getType() != DataType.Long) continue;
                        list2.set(i, ((Double)list2.get(i)).longValue());
                    }
                }
            }
        }
    }

    @Override
    public List<List<JQGridModel.Cell>> getCellRowList() {
        return this.getCellRowList(false);
    }

    @Override
    public List<List<JQGridModel.Cell>> getCellRowList(boolean bl) {
        Object object;
        ArrayList<List<JQGridModel.Cell>> arrayList = new ArrayList<List<JQGridModel.Cell>>();
        List<Field> list = this.result.getColumns();
        if (!this.hasRecords() && bl) {
            ArrayList<JQGridModel.Cell> arrayList2 = new ArrayList<JQGridModel.Cell>();
            for (int i = 0; i < list.size(); ++i) {
                object = list.get(i);
                arrayList2.add(new JQGridModel.Cell(((Field)object).getName(), "<UNDEFINED>", "", ((Field)object).getType().name()));
            }
            arrayList.add(arrayList2);
        }
        for (int i = 0; i < this.result.getRecordsCount(); ++i) {
            List<Object> list2 = this.result.getRecords();
            object = (List)list2.get(i);
            ArrayList<JQGridModel.Cell> arrayList3 = new ArrayList<JQGridModel.Cell>();
            for (int j = 0; j < list.size(); ++j) {
                Field field = list.get(j);
                Object object2 = object.get(j);
                if ((field.getType() == DataType.Integer || field.getType() == DataType.Short) && object2 != null && object2 instanceof Double) {
                    object2 = ((Double)object2).intValue();
                } else if (field.getType() == DataType.Long && object2 != null && object2 instanceof Double) {
                    object2 = ((Double)object2).longValue();
                }
                arrayList3.add(new JQGridModel.Cell(field.getName(), object2, QueryExecutorImpl.getSortType(field.getType().name()), field.getType().name()));
            }
            arrayList.add(arrayList3);
        }
        return arrayList;
    }

    @Override
    public List<String> getColumnNames() {
        ArrayList<String> arrayList = new ArrayList<String>();
        if (this.result.getColumns() != null && !this.result.getColumns().isEmpty()) {
            for (Field field : this.result.getColumns()) {
                arrayList.add(field.getName());
            }
        }
        return arrayList;
    }

    public static String getSortType(String string) {
        String string2 = "text";
        if (string.equalsIgnoreCase("integer") || string.equalsIgnoreCase("int") || string.equalsIgnoreCase("long") || string.equalsIgnoreCase("bigint")) {
            string2 = "int";
        } else if (string.equalsIgnoreCase("double")) {
            string2 = "number";
        } else if (string.equalsIgnoreCase("date")) {
            string2 = "date";
        } else if (string.equalsIgnoreCase("float") || string.equalsIgnoreCase("decimal")) {
            string2 = "numeric";
        }
        return string2;
    }

    @Override
    public List<List<Object>> getRows() {
        ArrayList<List<Object>> arrayList = new ArrayList<List<Object>>();
        List<Field> list = this.result.getColumns();
        if (this.result.getRecords() != null && !this.result.getRecords().isEmpty()) {
            for (Object object : this.result.getRecords()) {
                if (!(object instanceof List)) continue;
                ArrayList arrayList2 = new ArrayList();
                List list2 = (List)object;
                for (int i = 0; i < list.size(); ++i) {
                    Field field = list.get(i);
                    Object object2 = list2.get(i);
                    if ((field.getType() == DataType.Integer || field.getType() == DataType.Short) && object2 != null && object2 instanceof Double) {
                        object2 = ((Double)object2).intValue();
                    } else if (field.getType() == DataType.Long && object2 != null && object2 instanceof Double) {
                        object2 = ((Double)object2).longValue();
                    }
                    arrayList2.add(object2);
                }
                arrayList.add(arrayList2);
            }
        }
        return arrayList;
    }

    @Override
    public List<Map<String, Object>> getMapList() {
        DataTableConverter dataTableConverter = new DataTableConverter(this.result, this.definition);
        return dataTableConverter.getMapList();
    }

    @Override
    public Iterator<RowMap> iterator() {
        return this.getRowMapList().iterator();
    }

    @Override
    public List<RowMap> getRowMapList() {
        DataTableConverter dataTableConverter = new DataTableConverter(this.result, this.definition);
        return dataTableConverter.getRowMapList();
    }

    @Override
    public int getRecordsCount() {
        return this.result.getRecordsCount();
    }

    @Override
    public RowMap getFirstRow() {
        return this.getRowMapList().get(0);
    }

    @Override
    public boolean hasRecords() {
        return this.getRecordsCount() > 0;
    }

    @Override
    public String getCacheID() {
        return this.cacheID;
    }

    @Override
    public void setCacheID(String string) {
        this.cacheID = string;
    }

    @Override
    public ReportDataResponse getResult() {
        return this.result;
    }

    public DataFormatDefinition getDefinition() {
        return this.definition;
    }

    public void setDefinition(DataFormatDefinition dataFormatDefinition) {
        this.definition = dataFormatDefinition;
    }

    public boolean isQueryRan() {
        return this.queryRan;
    }

    public void setQueryRan(boolean bl) {
        this.queryRan = bl;
    }

    public void setResult(ReportDataResponse reportDataResponse) {
        this.result = reportDataResponse;
    }

    @Override
    public DBService getService() {
        if (this.service == null) {
            this.service = new DBServiceImpl();
        }
        return this.service;
    }

    public String getConfigProperty(String string, String string2) {
        Properties properties = (Properties)RequestContext.getRequest().getServletContext().getAttribute(string2);
        return properties != null ? properties.getProperty(string) : null;
    }
}

