/*
 * Decompiled with CFR 0.152.
 */
package commvault.web.creconn;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public class QueryBuilder {
    final String query;
    List<Integer> positionList = new ArrayList<Integer>();
    Map<Integer, Object> values = new HashMap<Integer, Object>();
    private static final Logger logger = Logger.getLogger((String)"commvault.web");

    public QueryBuilder(String string) {
        this.query = string;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) != '?') continue;
            this.positionList.add(i);
        }
    }

    public QueryBuilder set(int n, Object object) {
        if (n <= 0) {
            throw new IllegalArgumentException("Index begins from 1");
        }
        if (object instanceof String) {
            object = "'" + object.toString() + "'";
        }
        if (this.values.containsKey(n)) {
            logger.debug((Object)("Overwriting value " + object + " at index " + n));
        }
        this.values.put(n, object);
        return this;
    }

    public String getQuery() {
        if (this.values.size() != this.positionList.size()) {
            throw new UnsupportedOperationException("Count of placeholders " + this.positionList.size() + " and count of values set " + this.values.size() + " are must be equal");
        }
        StringBuilder stringBuilder = new StringBuilder(this.query);
        for (int i = this.positionList.size() - 1; i >= 0; --i) {
            Integer n = this.positionList.get(i);
            stringBuilder.replace(n, n + 1, this.values.get(i + 1).toString());
        }
        logger.debug((Object)("Resultant query: " + stringBuilder.toString()));
        return stringBuilder.toString();
    }
}

