/*
 * Decompiled with CFR 0.152.
 */
package commvault.web.core.net;

import java.util.Random;

public class ServerException
extends RuntimeException {
    private static final long serialVersionUID = 1L;
    private static int incidentIdCounter = 0;
    private static Random incidentIdRnd = new Random();
    public static final String UNAUTHORIZED_REQUEST = "UNAUTHORIZED_REQUEST";
    public static final String API_NOT_FOUND = "API_NOT_FOUND";
    private String incidentId = ServerException.generateIncidentId();
    private int respCode;
    private int httpStatusCode;
    private String responseMessage;
    private boolean showErrorMessageToUser = true;
    private boolean logStackTrace = true;

    public static String generateIncidentId() {
        StringBuilder stringBuilder = new StringBuilder();
        int n = 35;
        stringBuilder.append(Long.toString(System.currentTimeMillis(), n)).append('z');
        stringBuilder.append(Long.toString(incidentIdCounter++, n)).append('z');
        stringBuilder.append(Long.toString(Math.abs(incidentIdRnd.nextInt()), n));
        return stringBuilder.toString();
    }

    public ServerException(Exception exception) {
        super(exception);
    }

    public ServerException(String string) {
        super(string);
    }

    public ServerException(int n) {
        this.respCode = n;
    }

    public ServerException(int n, String string) {
        this.respCode = n;
        this.responseMessage = string;
    }

    public ServerException(int n, int n2) {
        this.respCode = n;
        this.httpStatusCode = n2;
    }

    public ServerException(int n, int n2, String string) {
        this.respCode = n;
        this.httpStatusCode = n2;
        this.responseMessage = string;
    }

    public ServerException(String string, boolean bl) {
        this(string);
        this.setShowErrorMessageToUser(bl);
    }

    public ServerException(Exception exception, String string, boolean bl) {
        super(string, exception);
        this.setShowErrorMessageToUser(bl);
    }

    public ServerException(int n, String string, boolean bl) {
        this(string);
        this.respCode = n;
        this.setShowErrorMessageToUser(bl);
    }

    public boolean isShowErrorMessageToUser() {
        return this.showErrorMessageToUser;
    }

    public void setShowErrorMessageToUser(boolean bl) {
        this.showErrorMessageToUser = bl;
    }

    public int getResponseCode() {
        return this.respCode;
    }

    public String getResponseMessage() {
        return this.responseMessage;
    }

    @Override
    public String getMessage() {
        switch (this.respCode) {
            case 401: {
                return UNAUTHORIZED_REQUEST;
            }
            case 404: {
                return API_NOT_FOUND;
            }
        }
        return super.getMessage();
    }

    public boolean isLogStackTrace() {
        return this.logStackTrace;
    }

    public void setLogStackTrace(boolean bl) {
        this.logStackTrace = bl;
    }

    public String getIncidentId() {
        return this.incidentId;
    }

    public ServerException setIncidentId(String string) {
        this.incidentId = string;
        return this;
    }

    public int getHttpStatusCode() {
        return this.httpStatusCode;
    }
}

