/*
 * Decompiled with CFR 0.152.
 */
package commvault.web.core.net;

import commvault.web.core.net.HttpHelper;
import commvault.web.core.net.RequestObject;
import commvault.web.core.net.ServerException;
import commvault.web.core.util.CVCoreUtil;
import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import javax.inject.Named;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.log4j.Logger;

@ApplicationScoped
@Named(value="serverBroker")
public class ServerBroker {
    private static final Logger logger = Logger.getLogger(ServerBroker.class);
    @Inject
    private HttpHelper httpHelper;

    public HttpResponse getResponseAndHandleExceptions(RequestObject requestObject) throws Exception {
        HttpResponse httpResponse;
        int n;
        if (this.httpHelper == null) {
            this.httpHelper = CVCoreUtil.lookup(HttpHelper.class);
        }
        if ((n = (httpResponse = this.httpHelper.getResponse(requestObject)).getStatusLine().getStatusCode()) >= 200 && n < 300) {
            return httpResponse;
        }
        logger.warn((Object)("Invalid response returned: " + n));
        String string = null;
        string = this.convertResponseEntityToString(httpResponse.getEntity());
        if (string != null && !string.isEmpty()) {
            throw new ServerException(n, n, string);
        }
        throw new ServerException(n, n);
    }

    public String getStringResponse(RequestObject requestObject) throws Exception {
        if (this.httpHelper == null) {
            this.httpHelper = CVCoreUtil.lookup(HttpHelper.class);
        }
        HttpResponse httpResponse = this.getResponseAndHandleExceptions(requestObject);
        int n = httpResponse.getStatusLine().getStatusCode();
        String string = null;
        string = this.convertResponseEntityToString(httpResponse.getEntity());
        logger.trace((Object)string);
        if (n < 200 || n >= 300) {
            logger.error((Object)("Error response from server call: " + string));
            string = null;
        }
        return string;
    }

    public String convertResponseEntityToString(HttpEntity httpEntity) throws Exception {
        String string;
        InputStream inputStream = httpEntity.getContent();
        InputStreamReader inputStreamReader = new InputStreamReader(inputStream, "UTF-8");
        BufferedReader bufferedReader = new BufferedReader(inputStreamReader);
        StringBuilder stringBuilder = new StringBuilder();
        while ((string = bufferedReader.readLine()) != null) {
            stringBuilder.append(string).append("\n");
        }
        String string2 = stringBuilder.toString();
        return string2;
    }
}

