/*
 * Decompiled with CFR 0.152.
 */
package commvault.web.core.config;

import commvault.cte.registry.CvRegistry;
import commvault.cte.registry.Registry;
import commvault.web.core.config.ConfigProp;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Named;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;

@Named(value="CloudAppConfigs")
@ApplicationScoped
public class ConfigProperties {
    private static Map<String, ConfigProp> properties = new HashMap<String, ConfigProp>();
    private static final Logger logger = Logger.getLogger(ConfigProperties.class);

    public ConfigProperties() {
        properties.put("baseUrl", new ConfigProp("baseUrl"));
        properties.put("smtphost", new ConfigProp("smtphost"));
        properties.put("contactemails", new ConfigProp("contactemails"));
        properties.put("ccmail", new ConfigProp("ccmail"));
        properties.put("bccmail", new ConfigProp("bccmail"));
        properties.put("creEngine", new ConfigProp("creEngine"));
        properties.put("webserverUser", new ConfigProp("webserverUser"));
        properties.put("webserverUserPwdBase64", new ConfigProp("webserverUserPwdBase64"));
        properties.put("download_loc", new ConfigProp("download_loc"));
        properties.put("cspExcludeList", new ConfigProp("cspExcludeList"));
        properties.put("forceHttps", new ConfigProp("forceHttps"));
        logger.trace((Object)"Inside the ConfigProperties constructor...");
    }

    public Map<String, ConfigProp> getProperties() {
        return properties;
    }

    public String getWebServerURL() {
        return properties.get("baseUrl").getPropertyValue();
    }

    public String getSMTPHost() {
        return properties.get("smtphost").getPropertyValue();
    }

    public String getWebServerUser() {
        return properties.get("webserverUser").getPropertyValue();
    }

    public String getWebServerPWDB64() {
        return properties.get("webserverUserPwdBase64").getPropertyValue();
    }

    public String getContactEmails() {
        return properties.get("contactemails").getPropertyValue();
    }

    public String getCCEmails() {
        return properties.get("ccmail").getPropertyValue();
    }

    public String getBCCEmails() {
        return properties.get("bccmail").getPropertyValue();
    }

    public String getCREengineURL() {
        return properties.get("creEngine").getPropertyValue();
    }

    public String getDwonloadLocation() {
        return properties.get("download_loc").getPropertyValue();
    }

    public String getCSPExcludeUrls() {
        return properties.get("cspExcludeList").getPropertyValue();
    }

    public String getIsForceHttps() {
        return properties.get("forceHttps").getPropertyValue();
    }

    public void loadProperites(Properties properties) {
        boolean bl = false;
        if (properties.size() > 0) {
            bl = true;
        }
        for (Map.Entry<String, ConfigProp> entry : ConfigProperties.properties.entrySet()) {
            ConfigProp configProp = entry.getValue();
            String string = "CVCloudServices";
            if (configProp.getRegistryPath() != null && !configProp.getRegistryPath().isEmpty()) {
                string = configProp.getRegistryPath();
            }
            String string2 = bl ? properties.getProperty(configProp.getPropertyName()) : null;
            Registry registry = CvRegistry.getInstance((String)"Instance001");
            if (string2 != null) {
                try {
                    registry.setStringValue(string, configProp.getPropertyName(), string2);
                }
                catch (Exception exception) {
                    logger.error((Object)"Exception while putting value in registry form config file.", (Throwable)exception);
                }
            } else {
                string2 = registry.getStringValue(string, configProp.getPropertyName());
            }
            configProp.setPropertyValue(string2);
        }
        this.loadLoggerProperties();
    }

    private void loadLoggerProperties() {
        Integer n = ConfigProperties.getLoglevelFromRegistry();
        properties.put("CVCLOUDAPPS_DEBUGLEVEL", new ConfigProp("CVCLOUDAPPS_DEBUGLEVEL", n.toString()));
        Logger logger = Logger.getLogger((String)"commvault.web");
        logger.setLevel(ConfigProperties.getDebugLevel(n));
    }

    public static Integer getLoglevelFromRegistry() {
        Registry registry = CvRegistry.getInstance((String)"Instance001");
        Integer n = registry.getIntValue("EventManager", "CVCLOUDAPPS_DEBUGLEVEL");
        if (n == null || n == 0) {
            n = Level.INFO.getSyslogEquivalent();
        }
        return n;
    }

    public static Level getDebugLevel(Integer n) {
        Level level = n == null || n == 0 ? Level.INFO : (n >= Level.ALL.getSyslogEquivalent() + 3 ? Level.ALL : (n >= Level.ALL.getSyslogEquivalent() + 1 ? Level.TRACE : (n >= Level.ALL.getSyslogEquivalent() ? Level.DEBUG : (n >= Level.INFO.getSyslogEquivalent() ? Level.INFO : (n >= Level.WARN.getSyslogEquivalent() ? Level.WARN : Level.INFO)))));
        return level;
    }
}

