/*
 * Decompiled with CFR 0.152.
 */
package commvault.web.common;

import com.google.gson.JsonObject;
import commvault.web.common.CaptchaHandler;
import commvault.web.common.ExecuteWorkflow;
import commvault.web.core.filter.RequestContext;
import commvault.web.core.msg.ClientResp;
import commvault.web.core.util.CVCoreUtil;
import java.io.IOException;
import javax.servlet.ServletException;
import javax.servlet.annotation.WebServlet;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.log4j.Logger;

@WebServlet(urlPatterns={"/runworkflow.do", "/getCaptcha.do", "/checkCaptchaValue.do"})
public class CommonHandler
extends HttpServlet {
    private static final long serialVersionUID = 1L;
    private static final Logger logger = Logger.getLogger(CommonHandler.class);

    protected void doGet(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ServletException, IOException {
        if (httpServletRequest.getRequestURI().substring(httpServletRequest.getContextPath().length()).equalsIgnoreCase("/getCaptcha.do")) {
            this.handleGetCaptcha();
        } else {
            logger.info((Object)"Get is not suppported");
            httpServletResponse.sendRedirect("/MethodNotSupported.jsp");
        }
    }

    protected void doPost(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ServletException, IOException {
        httpServletResponse.setContentType("application/json; charset=UTF-8");
        if (httpServletRequest.getRequestURI().substring(httpServletRequest.getContextPath().length()).equalsIgnoreCase("/runworkflow.do")) {
            this.handleRunworkflow();
        } else if (httpServletRequest.getRequestURI().substring(httpServletRequest.getContextPath().length()).equalsIgnoreCase("/checkCaptchaValue.do")) {
            this.handleCheckCaptchaValue();
        } else {
            httpServletResponse.sendRedirect("/MethodNotSupported.jsp");
        }
    }

    private void handleRunworkflow() throws IOException {
        ClientResp clientResp = new ClientResp();
        HttpServletRequest httpServletRequest = RequestContext.getRequest();
        String string = httpServletRequest.getParameter("name");
        String string2 = httpServletRequest.getParameter("urlencoded");
        boolean bl = false;
        if (string2 != null && string2.equalsIgnoreCase("true")) {
            bl = true;
        }
        ExecuteWorkflow executeWorkflow = new ExecuteWorkflow(string);
        JsonObject jsonObject = null;
        if (!executeWorkflow.doesExists()) {
            clientResp.setErrorResponse("Workflow does not exists/supported.");
        } else {
            String string3 = httpServletRequest.getParameter("inputs");
            if (string3 != null) {
                JsonObject jsonObject2 = (JsonObject)CVCoreUtil.parseJson(string3);
                jsonObject = executeWorkflow.execute(jsonObject2, bl);
                if (jsonObject == null || jsonObject.isJsonNull() || jsonObject.size() == 0) {
                    clientResp.setErrorResponse("Unable to execute workflow, please verify inputs, or contact administrator.");
                } else {
                    clientResp.addData("workflowresponse", jsonObject);
                }
            } else {
                clientResp.setErrorResponse("Unable to get inputs, please check your inputs and try again or contact administrator.");
            }
        }
        if (RequestContext.getRequest().getHeader("Accept").equalsIgnoreCase("application/xml")) {
            if (jsonObject != null && jsonObject.get("xml") != null) {
                CVCoreUtil.write(jsonObject.get("xml").getAsString());
            } else {
                CVCoreUtil.write("");
            }
        } else {
            CVCoreUtil.write(CVCoreUtil.getJsonForObject(clientResp));
        }
    }

    private void handleGetCaptcha() throws IOException {
        CaptchaHandler.handleCheckCaptchaValue();
    }

    private void handleCheckCaptchaValue() {
        String string = RequestContext.getRequest().getParameter("captcha");
        try {
            CVCoreUtil.write(String.valueOf(Integer.parseInt(string.trim()) == (Integer)RequestContext.getRequest().getSession().getAttribute("captcha")));
        }
        catch (Exception exception) {
            CVCoreUtil.write(String.valueOf(false));
        }
    }
}

