/*
 * Decompiled with CFR 0.152.
 */
package org.owasp.validator.css;

import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.net.URI;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.ResourceBundle;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.batik.css.parser.ParseException;
import org.apache.batik.css.parser.Parser;
import org.owasp.validator.css.CssHandler;
import org.owasp.validator.html.CleanResults;
import org.owasp.validator.html.InternalPolicy;
import org.owasp.validator.html.ScanException;
import org.w3c.css.sac.DocumentHandler;
import org.w3c.css.sac.InputSource;

public class CssScanner {
    protected static final int DEFAULT_TIMEOUT = 1000;
    private static final String CDATA = "^\\s*<!\\[CDATA\\[(.*)\\]\\]>\\s*$";
    protected final Parser parser = new Parser();
    protected final InternalPolicy policy;
    protected final ResourceBundle messages;
    private static final Pattern p = Pattern.compile("^\\s*<!\\[CDATA\\[(.*)\\]\\]>\\s*$", 32);

    public CssScanner(InternalPolicy policy, ResourceBundle messages) {
        this.policy = policy;
        this.messages = messages;
    }

    public CleanResults scanStyleSheet(String taintedCss, int sizeLimit) throws ScanException {
        long startOfScan = System.currentTimeMillis();
        ArrayList<String> errorMessages = new ArrayList<String>();
        Matcher m = p.matcher(taintedCss);
        boolean isCdata = m.matches();
        if (isCdata) {
            taintedCss = m.group(1);
        }
        LinkedList<URI> stylesheets = new LinkedList<URI>();
        CssHandler handler = new CssHandler(this.policy, stylesheets, errorMessages, this.messages);
        this.parser.setDocumentHandler((DocumentHandler)handler);
        try {
            this.parser.parseStyleSheet(new InputSource((Reader)new StringReader(taintedCss)));
        }
        catch (IOException ioe) {
            throw new ScanException(ioe);
        }
        catch (ParseException pe) {
            throw new ScanException((Exception)((Object)pe));
        }
        this.parseImportedStylesheets(stylesheets, handler, errorMessages, sizeLimit);
        String cleaned = handler.getCleanStylesheet();
        if (isCdata && !this.policy.isUseXhtml()) {
            cleaned = "<![CDATA[[" + cleaned + "]]>";
        }
        return new CleanResults(startOfScan, cleaned, null, errorMessages);
    }

    public CleanResults scanInlineStyle(String taintedCss, String tagName, int sizeLimit) throws ScanException {
        long startOfScan = System.currentTimeMillis();
        ArrayList<String> errorMessages = new ArrayList<String>();
        LinkedList<URI> stylesheets = new LinkedList<URI>();
        CssHandler handler = new CssHandler(this.policy, stylesheets, errorMessages, tagName, this.messages);
        this.parser.setDocumentHandler((DocumentHandler)handler);
        try {
            this.parser.parseStyleDeclaration(taintedCss);
        }
        catch (IOException ioe) {
            throw new ScanException(ioe);
        }
        this.parseImportedStylesheets(stylesheets, handler, errorMessages, sizeLimit);
        return new CleanResults(startOfScan, handler.getCleanStylesheet(), null, errorMessages);
    }

    protected void parseImportedStylesheets(LinkedList<URI> stylesheets, CssHandler handler, List<String> errorMessages, int sizeLimit) throws ScanException {
    }
}

