/*
 * Decompiled with CFR 0.152.
 */
package workflow.types.data;

import commvault.cte.common.workflow.annotations.XmlField;
import commvault.msgs.CvEntities.CommCellEntity;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import workflow.types.data.DataRow;
import workflow.types.data.MetaData;
import workflow.types.data.ResultSet;

public class DataSet
implements ResultSet,
Iterable<DataRow> {
    private MetaData metaData;
    @XmlField(name="rowCount")
    public Integer rowCount;
    @XmlField(name="columnCount")
    public Integer columnCount;
    @XmlField(name="commCell")
    public List<CommCellEntity> commCell = new ArrayList<CommCellEntity>();
    @XmlField(name="row")
    private List<DataRow> rows = new ArrayList<DataRow>();
    private int rowIndex = -1;

    public DataSet() {
    }

    public DataSet(List<DataRow> list, List<CommCellEntity> list2) {
        this.rows = list;
        this.commCell = list2;
    }

    public DataSet(java.sql.ResultSet resultSet, CommCellEntity commCellEntity) throws SQLException {
        this.commCell.add(commCellEntity);
        this.initResult(resultSet);
    }

    public DataSet(java.sql.ResultSet resultSet, List<CommCellEntity> list) throws SQLException {
        this.commCell = list;
        this.initResult(resultSet);
    }

    private void initResult(java.sql.ResultSet resultSet) throws SQLException {
        this.metaData = new MetaData(resultSet.getMetaData());
        while (resultSet.next()) {
            this.rows.add(new DataRow(this.metaData, resultSet));
        }
    }

    public void add(DataRow dataRow) {
        this.rows.add(dataRow);
    }

    public int getRowCount() {
        return this.rows.size();
    }

    public int getColumnCount() {
        if (this.metaData != null) {
            return this.metaData.getColumnCount();
        }
        if (this.rows.size() > 0) {
            return this.rows.get(0).getColumnCount();
        }
        return 0;
    }

    public List<Object> getColumn(int n) {
        ArrayList<Object> arrayList = new ArrayList<Object>();
        for (DataRow dataRow : this.rows) {
            arrayList.add(dataRow.get(n));
        }
        return arrayList;
    }

    public List<Object> getColumn(String string) {
        ArrayList<Object> arrayList = new ArrayList<Object>();
        for (DataRow dataRow : this.rows) {
            arrayList.add(dataRow.get(string));
        }
        return arrayList;
    }

    public String getColumnName(int n) {
        if (this.metaData != null) {
            return this.metaData.getColumnName(n);
        }
        if (this.rows.size() > 0) {
            return this.rows.get(0).getColumnName(n);
        }
        return "";
    }

    public MetaData getMetaData() {
        return this.metaData;
    }

    public int size() {
        return this.rows.size();
    }

    public CommCellEntity getCommCell() {
        if (this.commCell != null && this.commCell.size() > 0) {
            return this.commCell.get(0);
        }
        return null;
    }

    public List<CommCellEntity> getCommCells() {
        return this.commCell;
    }

    public void moveFirst() {
        this.rowIndex = -1;
    }

    public DataRow getFirst() {
        if (this.rows.size() > 0) {
            return this.rows.get(0);
        }
        return null;
    }

    public List<DataRow> getRows() {
        return this.rows;
    }

    @Override
    public boolean hasNext() {
        if (this.rowIndex + 1 < this.rows.size()) {
            ++this.rowIndex;
            return true;
        }
        return false;
    }

    @Override
    public Object get(String string) {
        return this.rows.get(this.rowIndex).get(string);
    }

    @Override
    public Object get(int n) {
        return this.rows.get(this.rowIndex).get(n);
    }

    @Override
    public Iterator<DataRow> iterator() {
        return this.rows.iterator();
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < this.rows.size(); ++i) {
            if (i > 0) {
                stringBuffer.append(System.getProperty("line.separator"));
            }
            stringBuffer.append(String.valueOf(this.rows.get(i)));
        }
        return stringBuffer.toString();
    }
}

