/*
 * Decompiled with CFR 0.152.
 */
package workflow.types;

import commvault.cte.util.Base64;
import commvault.qnet.sys.CVPassword;
import java.io.Serializable;

public final class EncryptedString
implements Serializable,
Comparable<EncryptedString> {
    private static final String BASE64_REGEX = "^([A-Za-z0-9+/]{4})*([A-Za-z0-9+/]{3}=|[A-Za-z0-9+/]{2}==)?$";
    private String encryptedString;

    public EncryptedString(String string) {
        if (string != null && string.length() > 0) {
            if (string.matches(BASE64_REGEX)) {
                String string2 = Base64.decode(string);
                CVPassword cVPassword = new CVPassword();
                this.encryptedString = cVPassword.encrypt(string2);
            } else {
                this.encryptedString = string;
            }
        } else {
            this.encryptedString = string;
        }
    }

    public String getEncryptedText() {
        return this.encryptedString;
    }

    public String getPlainText() {
        if (this.encryptedString != null && this.encryptedString.length() > 0) {
            CVPassword cVPassword = new CVPassword();
            return cVPassword.decrypt(this.encryptedString);
        }
        return null;
    }

    public String toString() {
        return this.encryptedString;
    }

    public boolean equals(Object object) {
        if (object instanceof EncryptedString) {
            return this.getPlainText().equals(((EncryptedString)object).getPlainText());
        }
        return false;
    }

    @Override
    public int compareTo(EncryptedString encryptedString) {
        return this.getPlainText().compareTo(encryptedString.getPlainText());
    }
}

