/*
 * Decompiled with CFR 0.152.
 */
package commvault.tools.generator;

import commvault.tools.generator.AnnotationDefValues;
import commvault.tools.generator.ClassDef;
import commvault.tools.generator.GenUtil;
import commvault.tools.generator.Generator;
import commvault.tools.generator.NameSpace;
import commvault.tools.generator.ParseException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class FieldDef {
    public static final int TM_OPTION_TYPE_UNKNOWN = 0;
    public static final int TM_OPTION_TYPE_STRING = 1;
    public static final int TM_OPTION_TYPE_BOOLEAN = 2;
    public static final int TM_OPTION_TYPE_BYTE = 3;
    public static final int TM_OPTION_TYPE_CHARACTER = 4;
    public static final int TM_OPTION_TYPE_SHORT = 5;
    public static final int TM_OPTION_TYPE_USHORT = 6;
    public static final int TM_OPTION_TYPE_INTEGER = 7;
    public static final int TM_OPTION_TYPE_UINTEGER = 8;
    public static final int TM_OPTION_TYPE_LONG = 9;
    public static final int TM_OPTION_TYPE_ULONG = 10;
    public static final int TM_OPTION_TYPE_FLOAT = 11;
    public static final int TM_OPTION_TYPE_DOUBLE = 12;
    public static final int TM_OPTION_TYPE_COMPLEX = 13;
    public static final int TM_OPTION_TYPE_64LONG = 14;
    public static final int TM_OPTION_TYPE_UINT64 = 15;
    public static final int TM_OPTION_TYPE_CDATA = 16;
    public static final int TM_OPTION_TYPE_XML = 17;
    private static final Pattern PATTERN = Pattern.compile("([A-Z]+)|[_]([_])|[_]([^_]*)");
    private static final String NOT_DEFINED = "CV_NOT_DEFINED";
    public static final HashSet<String> uniqueNames = new HashSet();
    ClassDef type;
    FieldDef parentField;
    String name;
    private List<AnnotationDefValues> annotations = new ArrayList();
    ClassDef templateType;
    ClassDef mapKeyType;
    ClassDef mapValueType;
    int index;
    private String defaultValue;
    public String comment = "";
    String flagType;
    String flagValue;
    public boolean inheritedField;
    private boolean ref;

    public boolean getInheritedField() {
        return this.inheritedField;
    }

    public void setInheritedField(boolean bl) {
        this.inheritedField = bl;
    }

    public boolean isList() {
        return this.type == ClassDef.LIST || this.type == ClassDef.VECTOR;
    }

    public boolean isInitialisable() {
        return !this.type.enumType && !this.type.name.equals(ClassDef.BSTRING.name);
    }

    public boolean isTemplate() {
        return this.templateType != null;
    }

    public String getConstantName() {
        return this.name.replaceAll("([A-Z]+)", "_$1").toUpperCase();
    }

    public boolean isPrimitive() {
        if (NameSpace.type == Generator.Type.CPP && this.type.enumType) {
            return true;
        }
        if (NameSpace.type == Generator.Type.java) {
            return false;
        }
        return this.type.primitive;
    }

    public String getComment() {
        if (this.comment == null) {
            return "";
        }
        return this.comment;
    }

    public String getUname() {
        return this.name.substring(0, 1).toUpperCase() + this.name.substring(1);
    }

    public boolean isPrimitiveBinary() {
        if (this.type.enumType) {
            return true;
        }
        return this.type.primitive;
    }

    public boolean isDefaultValueExist() {
        return this.defaultValue != null;
    }

    public String getDefaultValue() {
        if (this.defaultValue == null) {
            if (this.type == ClassDef.BOOLEAN) {
                return "false";
            }
            if (this.type == ClassDef.INT || this.type == ClassDef.UINT || this.type == ClassDef.LONG || this.type == ClassDef.ULONG || this.type == ClassDef.LONGLONG || this.type == ClassDef.FLOAT || this.type == ClassDef.DOUBLE) {
                return "0";
            }
        }
        return this.defaultValue;
    }

    public boolean isPrimitiveTemplate() {
        if (this.isTemplate()) {
            return this.templateType.primitive;
        }
        return true;
    }

    public boolean isMapKeyTypePrimitive() {
        if (this.isMap()) {
            return this.mapKeyType.primitive;
        }
        return false;
    }

    public boolean isMapValueTypePrimitive() {
        if (this.isMap()) {
            return this.mapValueType.primitive;
        }
        return false;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String string) {
        this.name = string;
    }

    public String getType() {
        if (this.isTemplate()) {
            return this.getType(this.type) + "<" + this.getTemplateType() + ">";
        }
        if (this.isMap()) {
            return this.getType(this.type) + "<" + this.getMapKeyType() + "," + this.getMapValueType() + ">";
        }
        return this.getType(this.type);
    }

    public String getInstanceTypeName() {
        if (this.isTemplate()) {
            return this.type.getSimpleName() + "<" + this.getTemplateType() + ">";
        }
        return this.type.getNonPrimitiveTypeName();
    }

    public String getConstructor() {
        if (NameSpace.type == Generator.Type.java) {
            if (this.getType().equalsIgnoreCase("String")) {
                return this.getDefaultValue();
            }
            String string = (String)ClassDef.javaMap.get(this.type);
            if (string != null && this.type.primitive) {
                return string + ".valueOf(" + this.getDefaultValue() + ")";
            }
        }
        return "new " + this.getInstanceTypeName() + "(" + this.getDefaultValue() + ")";
    }

    public String getDefaultConstructor() {
        if (this.isTemplate()) {
            if (this.type.name.equals("vector")) {
                return "new Vector <" + this.getTemplateType() + ">" + "()";
            }
            return "new ArrayList <" + this.getTemplateType() + ">" + "()";
        }
        if (this.isMap()) {
            return "new TreeMap <" + this.getMapKeyType() + ", " + this.getMapValueType() + ">()";
        }
        if (this.getType().equalsIgnoreCase("String")) {
            return "\"\"";
        }
        if (this.getType().equalsIgnoreCase("boolean")) {
            if (NameSpace.type == Generator.Type.java) {
                return "Boolean.valueOf(false)";
            }
            return "false";
        }
        if (this.type.name.equals("bstring")) {
            return null;
        }
        String string = (String)ClassDef.javaMap.get(this.type);
        if (NameSpace.type == Generator.Type.java && string != null && (string.equals("Integer") || string.equals("Double") || string.equals("Float"))) {
            return string + ".valueOf(0)";
        }
        if (NameSpace.type == Generator.Type.java && ClassDef.javaMap.containsKey(this.type)) {
            return "new " + this.getInstanceTypeName() + "(0)";
        }
        if (NameSpace.type != Generator.Type.java && this.type.primitive && ClassDef.javaMap.containsKey(this.type)) {
            return "new " + this.getInstanceTypeName() + "(0)";
        }
        return "new " + this.getInstanceTypeName() + "()";
    }

    public String getHandlerName() {
        if (this.isTemplate()) {
            return this.getTemplateType();
        }
        return this.getType();
    }

    public boolean isTemplatePrimitive() {
        if (this.templateType == null) {
            return false;
        }
        return this.templateType.primitive;
    }

    public boolean isTemplateEnumType() {
        if (this.templateType == null) {
            return false;
        }
        return this.templateType.isEnumType();
    }

    public String getTemplateType() {
        if (this.templateType == null) {
            return null;
        }
        if (NameSpace.type == Generator.Type.java) {
            return this.templateType.getNonPrimitiveTypeName();
        }
        return this.templateType.getSimpleName();
    }

    public String getMapKeyType() {
        if (this.mapKeyType == null) {
            return null;
        }
        return this.mapKeyType.getSimpleName();
    }

    public String getMapValueType() {
        if (this.mapValueType == null) {
            return null;
        }
        return this.mapValueType.getSimpleName();
    }

    public boolean isString() {
        return this.type == ClassDef.WSTIRNG || this.type == ClassDef.BSTRING || this.type == ClassDef.STRING;
    }

    private String getType(ClassDef classDef) {
        return classDef.getSimpleName();
    }

    public String getPrimitiveType() {
        if (this.isString()) {
            return "String";
        }
        if (this.type == ClassDef.BOOLEAN) {
            return "boolean";
        }
        if (this.type == ClassDef.LONG || this.type == ClassDef.ULONG || this.type == ClassDef.LONGLONG) {
            return "long";
        }
        return this.type.name;
    }

    public String getConstantTypeName() {
        return this.type.getConstantName();
    }

    public String getTagName() {
        return this.type.getTagName();
    }

    public boolean isEnumType() {
        if (this.isList()) {
            return this.templateType.isEnumType();
        }
        return this.type.isEnumType();
    }

    public int getIndex() {
        return this.index;
    }

    public void setIndex(int n) {
        this.index = n;
    }

    public boolean isHandlerExist() {
        return !this.isPrimitive() && (!this.isList() || this.isTemplate() && !this.isPrimitiveTemplate());
    }

    public String toString() {
        return this.name;
    }

    public void setDafaultValue(String string) {
        this.defaultValue = string;
    }

    public String getEnumValue() {
        int n = 0;
        for (FieldDef fieldDef : this.type.getFields()) {
            if (fieldDef.name.equals(this.defaultValue)) {
                return "" + n;
            }
            ++n;
        }
        return NOT_DEFINED;
    }

    public ClassDef getClassDef() {
        return this.type;
    }

    public String getAnnotation() {
        return GenUtil.getAnnotation((List)this.annotations);
    }

    public String getAnnotationCS() {
        return GenUtil.getAnnotationCS((List)this.annotations);
    }

    public boolean isRef() {
        return this.ref;
    }

    public void setRef(boolean bl) {
        this.ref = bl;
    }

    public ClassDef getTemplateTypeDef() {
        return this.templateType;
    }

    public ClassDef getTypeDef() {
        return this.type;
    }

    public String getFlagType() {
        if (this.flagType == null) {
            return NOT_DEFINED;
        }
        return this.flagType;
    }

    public void setFlagType(String string) {
        this.flagType = string;
    }

    public void setFlagValue(String string) {
        this.flagValue = string;
    }

    public String getFlagValue() {
        if (this.flagValue == null) {
            return NOT_DEFINED;
        }
        return this.flagValue;
    }

    public List<AnnotationDefValues> getAnnotations() {
        return this.annotations;
    }

    public void setAnnotations(List<AnnotationDefValues> list) throws ParseException {
        for (AnnotationDefValues annotationDefValues : list) {
            if (!annotationDefValues.getAnnotationDef().name.equalsIgnoreCase("password") || this.type.name.equalsIgnoreCase("bstring")) continue;
            throw new ParseException("Field " + this.getName() + " has password as annotation.FieldType has to be bstring not " + this.getType());
        }
        this.annotations = list;
    }

    public int getDbType() {
        if (this.isTemplate()) {
            return 0;
        }
        if (this.getType().equalsIgnoreCase("String") || this.getType().equalsIgnoreCase("wstring")) {
            return 1;
        }
        if (this.getType().equalsIgnoreCase("bstring")) {
            for (AnnotationDefValues annotationDefValues : this.annotations) {
                if (!annotationDefValues.getAnnotationDef().name.equalsIgnoreCase("Password")) continue;
                return 3;
            }
            return 1;
        }
        if (this.getType().equalsIgnoreCase("boolean")) {
            return 2;
        }
        if (this.getType().equalsIgnoreCase("uint")) {
            return 8;
        }
        if (this.getType().equalsIgnoreCase("int")) {
            return 7;
        }
        if (this.getType().equalsIgnoreCase("ulong")) {
            return 10;
        }
        if (this.getType().equalsIgnoreCase("long")) {
            return 9;
        }
        if (this.getType().equalsIgnoreCase("longlong")) {
            return 14;
        }
        if (this.getType().equalsIgnoreCase("cdata")) {
            return 16;
        }
        if (this.getType().equalsIgnoreCase("xml")) {
            return 17;
        }
        return 0;
    }

    public String getDbDefaultValue() {
        if (!this.isDefaultValueExist() || this.getDefaultValue() == null || this.getDefaultValue().trim().equals("")) {
            if (this.isString()) {
                return "STRING_NOT_DEFINED";
            }
            return NOT_DEFINED;
        }
        if (this.isEnumType()) {
            return this.getEnumValue();
        }
        String string = this.getDefaultValue();
        if (string.equalsIgnoreCase("true")) {
            return "CV_TRUE";
        }
        if (string.equalsIgnoreCase("false")) {
            return "CV_FALSE";
        }
        return this.getDefaultValue();
    }

    public boolean isContainsDateAnnot() {
        for (AnnotationDefValues annotationDefValues : this.annotations) {
            if (!annotationDefValues.getAnnotationDef().name.equalsIgnoreCase("CVDate")) continue;
            return true;
        }
        return false;
    }

    public boolean isContainsGenByRefAnnot() {
        for (AnnotationDefValues annotationDefValues : this.annotations) {
            if (!annotationDefValues.getAnnotationDef().name.equalsIgnoreCase("GenByRef")) continue;
            return true;
        }
        return false;
    }

    public AnnotationDefValues.AnnotationValue getCommentAnnot() {
        for (AnnotationDefValues annotationDefValues : this.annotations) {
            if (!annotationDefValues.getAnnotationDef().name.equalsIgnoreCase("Text")) continue;
            for (AnnotationDefValues.AnnotationValue annotationValue : annotationDefValues.getAnnotationFieldValues()) {
                if (!annotationValue.getField().name.equalsIgnoreCase("comment")) continue;
                return annotationValue;
            }
        }
        return null;
    }

    public boolean isContainsPasswordAnnot() {
        for (AnnotationDefValues annotationDefValues : this.annotations) {
            if (!annotationDefValues.getAnnotationDef().name.equalsIgnoreCase("Password")) continue;
            return true;
        }
        return false;
    }

    public String getDisplayableText(boolean bl) {
        for (AnnotationDefValues annotationDefValues : this.annotations) {
            if (!annotationDefValues.getAnnotationDef().name.equalsIgnoreCase("Text")) continue;
            for (AnnotationDefValues.AnnotationValue annotationValue : annotationDefValues.getAnnotationFieldValues()) {
                if (!annotationValue.getField().name.equalsIgnoreCase("text")) continue;
                return annotationValue.getUnquotedValue();
            }
        }
        return bl ? this.getDisplayableText(this.name) : null;
    }

    private String getDisplayableText(String string) {
        if ((string = new String(string)).startsWith("#")) {
            string = string.substring(string.indexOf(46) + 1);
        }
        if (string.endsWith(".label")) {
            string = string.substring(0, string.length() - ".label".length());
        }
        string = string.substring(0, 1).toUpperCase() + string.substring(1);
        Pattern pattern = PATTERN;
        Matcher matcher = pattern.matcher(string);
        StringBuffer stringBuffer = new StringBuffer();
        StringBuffer stringBuffer2 = new StringBuffer();
        while (matcher.find()) {
            stringBuffer2.setLength(0);
            String string2 = matcher.group(1);
            String string3 = matcher.group(2);
            String string4 = matcher.group(3);
            if (string2 != null) {
                stringBuffer2.append(" ").append(string2);
            } else if (string3 != null) {
                stringBuffer2.append("_");
            } else if (string4 != null) {
                stringBuffer2.append(" ").append(string4);
            }
            matcher.appendReplacement(stringBuffer, stringBuffer2.toString());
        }
        matcher.appendTail(stringBuffer);
        return stringBuffer.toString().trim();
    }

    public String getUnboxedType() {
        if (NameSpace.type == Generator.Type.java && this.type.getPrimitiveType() != null) {
            return this.type.getPrimitiveType();
        }
        return this.getType();
    }

    public String getHashId() {
        return new Integer(this.name.hashCode() & 0xFFFFFF).toString();
    }

    public boolean isGenerateLocalizeId() {
        return !this.getClassDef().isProcessingInstruction();
    }

    public boolean isContainsCDATAAnnot() {
        for (AnnotationDefValues annotationDefValues : this.annotations) {
            if (!annotationDefValues.getAnnotationDef().name.equalsIgnoreCase("MarkAsCDATA")) continue;
            return true;
        }
        return false;
    }

    public boolean isMap() {
        return this.type == ClassDef.MAP;
    }

    public ClassDef getMapKeyTypeDef() {
        return this.mapKeyType;
    }

    public ClassDef getMapValueTypeDef() {
        return this.mapValueType;
    }
}

