/*
 * Decompiled with CFR 0.152.
 */
package commvault.cte.webproxy;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.net.URL;
import java.security.KeyStore;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLException;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509TrustManager;

public class TrustAllCertificate {
    public static void installCertificate(URL uRL) {
        try {
            String string = uRL.getHost();
            int n = uRL.getPort();
            if (n == -1) {
                if (uRL.getProtocol().equalsIgnoreCase("https")) {
                    n = 443;
                } else if (uRL.getProtocol().equalsIgnoreCase("http")) {
                    n = 80;
                }
            }
            char[] cArray = "changeit".toCharArray();
            char c = File.separatorChar;
            File file = new File(System.getProperty("java.home") + c + "lib" + c + "security");
            File file2 = new File(file, "jssecacerts");
            if (!file2.isFile()) {
                file2 = new File(file, "cacerts");
            }
            System.err.println("Loading KeyStore " + file2 + "...");
            FileInputStream fileInputStream = new FileInputStream(file2);
            KeyStore keyStore = KeyStore.getInstance(KeyStore.getDefaultType());
            keyStore.load(fileInputStream, cArray);
            ((InputStream)fileInputStream).close();
            SSLContext sSLContext = SSLContext.getInstance("TLS");
            TrustManagerFactory trustManagerFactory = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
            trustManagerFactory.init(keyStore);
            X509TrustManager x509TrustManager = (X509TrustManager)trustManagerFactory.getTrustManagers()[0];
            SavingTrustManager savingTrustManager = new SavingTrustManager(x509TrustManager);
            sSLContext.init(null, new TrustManager[]{savingTrustManager}, null);
            SSLSocketFactory sSLSocketFactory = sSLContext.getSocketFactory();
            System.err.println("Opening connection to " + string + ":" + n + "...");
            SSLSocket sSLSocket = (SSLSocket)sSLSocketFactory.createSocket(string, n);
            sSLSocket.setSoTimeout(10000);
            try {
                System.err.println("Starting SSL handshake...");
                sSLSocket.startHandshake();
                sSLSocket.close();
                System.err.println();
                System.err.println("No errors, certificate is already trusted");
                return;
            }
            catch (SSLException sSLException) {
                System.err.println();
                System.err.println("Some certificate(s) are not trusted.");
                X509Certificate[] x509CertificateArray = savingTrustManager.chain;
                if (x509CertificateArray == null) {
                    System.err.println("Could not obtain server certificate chain");
                    return;
                }
                System.err.println();
                System.err.println("Server sent " + x509CertificateArray.length + " untrusted certificate(s):");
                System.err.println();
                for (X509Certificate x509Certificate : x509CertificateArray) {
                    System.err.println(" Subject " + x509Certificate.getSubjectDN());
                    System.err.println(" Issuer  " + x509Certificate.getIssuerDN());
                    System.err.println();
                    keyStore.setCertificateEntry(string, x509Certificate);
                    System.err.println();
                    System.err.println("Added certificate to keystore '" + file2 + "' using alias '" + string + "'");
                }
                FileOutputStream fileOutputStream = new FileOutputStream(file2);
                keyStore.store(fileOutputStream, cArray);
                fileOutputStream.close();
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private static class SavingTrustManager
    implements X509TrustManager {
        private final X509TrustManager tm;
        private X509Certificate[] chain;

        SavingTrustManager(X509TrustManager x509TrustManager) {
            this.tm = x509TrustManager;
        }

        @Override
        public X509Certificate[] getAcceptedIssuers() {
            throw new UnsupportedOperationException();
        }

        @Override
        public void checkClientTrusted(X509Certificate[] x509CertificateArray, String string) throws CertificateException {
            throw new UnsupportedOperationException();
        }

        @Override
        public void checkServerTrusted(X509Certificate[] x509CertificateArray, String string) throws CertificateException {
            this.chain = x509CertificateArray;
            this.tm.checkServerTrusted(x509CertificateArray, string);
        }
    }
}

