/*
 * Decompiled with CFR 0.152.
 */
package commvault.cte.webproxy;

import commvault.cte.CteStringBank;
import commvault.cte.webproxy.Base64;
import commvault.cte.webproxy.ConnectRequestToEvMgrS;
import commvault.cte.webproxy.ConnectResponseFromEvMgrS;
import commvault.cte.webproxy.DisconnectRequestToEvMgrS;
import commvault.cte.webproxy.RecvRequestToEvMgrS;
import commvault.cte.webproxy.SendRequestToEvMgrS;
import commvault.cte.webproxy.SendResponseFromEvMgrS;
import commvault.cte.webproxy.WebProxyWebServiceLocator;
import commvault.cte.webproxy.WebProxyWebServiceSoap;
import commvault.cte.webproxy.WebProxyWebServiceSoapStub;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.math.BigInteger;
import java.net.Socket;
import java.net.SocketAddress;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Date;
import javax.xml.rpc.ServiceException;

public class RpcHTTPSocket
extends Socket {
    private static BigInteger READ_BYTE = new BigInteger(CteStringBank.RpcHTTPSocket_0.getI18n());
    private WebProxyWebServiceSoap stub;
    private BigInteger sessionId;
    private OutputStream outStream;
    private InputStream inStream;
    private boolean isLoggingEnabled = false;

    public RpcHTTPSocket(String string, int n, String string2) throws IOException {
        super(string, n);
        try {
            WebProxyWebServiceLocator webProxyWebServiceLocator = new WebProxyWebServiceLocator(string2);
            this.stub = webProxyWebServiceLocator.getWebProxyWebServiceSoap();
            if (this.stub instanceof WebProxyWebServiceSoapStub) {
                ((WebProxyWebServiceSoapStub)this.stub).setTimeout(Integer.MAX_VALUE);
            }
            this.log("Creating the RPC Socket.");
        }
        catch (ServiceException serviceException) {
            serviceException.printStackTrace();
            throw new IOException(serviceException.getMessage());
        }
        this.httpConnect(string);
        this.inStream = new RpcHTTPSocketInputStream();
        this.outStream = new RpcHTTPSocketOutputStream();
    }

    @Override
    public synchronized void connect(SocketAddress socketAddress) throws IOException {
    }

    public synchronized void httpConnect(String string) throws IOException {
        this.log("Opening Connection to " + string);
        ConnectRequestToEvMgrS connectRequestToEvMgrS = new ConnectRequestToEvMgrS(string);
        ConnectResponseFromEvMgrS connectResponseFromEvMgrS = this.stub.connectRequestToEvMgrSOP(connectRequestToEvMgrS);
        this.sessionId = connectResponseFromEvMgrS.getSessionID();
        if (this.sessionId.intValue() == 0) {
            throw new IOException(CteStringBank.connectionFailed.getI18n());
        }
        this.log("Connected to " + string);
    }

    @Override
    public InputStream getInputStream() throws IOException {
        return this.inStream;
    }

    @Override
    public OutputStream getOutputStream() throws IOException {
        return this.outStream;
    }

    @Override
    public synchronized void close() throws IOException {
        this.log("Disconnecting connection");
        this.stub.disconnectRequestToEvMgrSOP(new DisconnectRequestToEvMgrS(this.sessionId));
        this.log("Connection Disconnected");
    }

    private void log(String string) {
        if (this.isLoggingEnabled) {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append(this.getTimeStamp());
            stringBuilder.append("    ");
            stringBuilder.append(this.sessionId);
            stringBuilder.append("    ");
            stringBuilder.append(string);
            System.out.println(stringBuilder);
        }
    }

    private String getTimeStamp() {
        return DateFormat.getInstance().format(new Date());
    }

    class RpcHTTPSocketOutputStream
    extends ByteArrayOutputStream {
        private ArrayList<Integer> outByteArrayList = new ArrayList();

        RpcHTTPSocketOutputStream() {
            RpcHTTPSocket.this.log("Creating Socket output stream");
        }

        @Override
        public synchronized void write(int n) {
            RpcHTTPSocket.this.log("Writing byte data");
            this.outByteArrayList.add(n);
        }

        @Override
        public synchronized void write(byte[] byArray, int n, int n2) {
            RpcHTTPSocket.this.log("Writing block of data offset = " + n + " dataLength = " + n2);
            if (n < 0 || n > byArray.length || n2 < 0 || n + n2 > byArray.length || n + n2 < 0) {
                throw new IndexOutOfBoundsException();
            }
            if (n2 == 0) {
                return;
            }
            for (int i = 0; i < n2; ++i) {
                this.outByteArrayList.add(byArray[i] & 0xFF);
            }
        }

        @Override
        public synchronized void flush() throws IOException {
            int[] nArray = new int[this.outByteArrayList.size()];
            for (int i = 0; i < this.outByteArrayList.size(); ++i) {
                nArray[i] = this.outByteArrayList.get(i).byteValue();
            }
            RpcHTTPSocket.this.log("Flusing data to socket");
            SendRequestToEvMgrS sendRequestToEvMgrS = new SendRequestToEvMgrS(RpcHTTPSocket.this.sessionId, Base64.encode(nArray));
            SendResponseFromEvMgrS sendResponseFromEvMgrS = RpcHTTPSocket.this.stub.sendRequestToEvMgrSOP(sendRequestToEvMgrS);
            if (nArray.length != sendResponseFromEvMgrS.getBytesWritten().intValue()) {
                throw new IOException(CteStringBank.RpcHTTPSocket_3.getI18n());
            }
            this.outByteArrayList.clear();
        }
    }

    class RpcHTTPSocketInputStream
    extends InputStream {
        RpcHTTPSocketInputStream() {
            RpcHTTPSocket.this.log("Creating Socket input stream");
        }

        @Override
        public synchronized int read() throws IOException {
            RpcHTTPSocket.this.log("Reading byte data");
            RecvRequestToEvMgrS recvRequestToEvMgrS = new RecvRequestToEvMgrS(RpcHTTPSocket.this.sessionId, READ_BYTE);
            String string = RpcHTTPSocket.this.stub.recvRequestToEvMgrSOP(recvRequestToEvMgrS).getBlobBase64();
            int[] nArray = Base64.decodeAsInt(string);
            if (nArray.length <= 0) {
                try {
                    RpcHTTPSocket.this.log("Waiting for data in socket ");
                    RpcHTTPSocket.this.inStream.wait(5L);
                }
                catch (InterruptedException interruptedException) {
                    interruptedException.printStackTrace();
                }
            }
            RpcHTTPSocket.this.log("Returning byte data");
            return nArray[0];
        }

        @Override
        public synchronized int read(byte[] byArray, int n, int n2) throws IOException {
            RpcHTTPSocket.this.log("Reading block of data offset = " + n + " dataLength = " + n2);
            BigInteger bigInteger = new BigInteger(CteStringBank.RpcHTTPSocket_2.getI18n() + n2);
            RecvRequestToEvMgrS recvRequestToEvMgrS = new RecvRequestToEvMgrS(RpcHTTPSocket.this.sessionId, bigInteger);
            String string = RpcHTTPSocket.this.stub.recvRequestToEvMgrSOP(recvRequestToEvMgrS).getBlobBase64();
            byte[] byArray2 = Base64.decodeAsByte(string);
            System.arraycopy(byArray2, 0, byArray, n, byArray2.length);
            RpcHTTPSocket.this.log("Returning block data");
            return byArray2.length;
        }
    }
}

