/*
 * Decompiled with CFR 0.152.
 */
package commvault.cte.util;

import java.util.Timer;
import java.util.TimerTask;
import java.util.Vector;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;

public final class TimedMap<K, V> {
    private final ConcurrentMap<K, ExpiredObject<K, V>> map = new ConcurrentHashMap<K, ExpiredObject<K, V>>();
    private final Lock writeLock = new ReentrantLock();
    private Timer timer = new Timer("TimedMap Timer", true);
    private Long timeToLive;

    public TimedMap(long l) {
        this.timeToLive = l;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void put(K k, V v, long l) {
        try {
            this.writeLock.lock();
            if (!this.map.containsKey(k)) {
                this.map.put(k, new ExpiredObject<K, V>(k, v, l));
            } else {
                ExpiredObject<K, V> expiredObject = this.map.put(k, new ExpiredObject<K, V>(k, v, l));
                if (expiredObject != null) {
                    expiredObject.getTask().cancel();
                }
            }
        }
        finally {
            this.writeLock.unlock();
        }
    }

    public void put(K k, V v) {
        this.put(k, v, this.timeToLive);
    }

    public V get(K k) {
        return this.map.containsKey(k) ? (V)((ExpiredObject)this.map.get(k)).getValue() : null;
    }

    public Vector<V> values() {
        Vector vector = new Vector();
        for (ExpiredObject expiredObject : this.map.values()) {
            vector.add(expiredObject.getValue());
        }
        return vector;
    }

    public void clear() {
        try {
            this.writeLock.lock();
            for (ExpiredObject expiredObject : this.map.values()) {
                expiredObject.getTask().cancel();
            }
            this.map.clear();
            this.timer.purge();
        }
        finally {
            this.writeLock.unlock();
        }
    }

    public boolean containsKey(K k) {
        return this.map.containsKey(k);
    }

    public boolean isEmpty() {
        return this.map.isEmpty();
    }

    public V remove(K k) {
        ExpiredObject expiredObject;
        try {
            this.writeLock.lock();
            System.out.println("Removing element with key:" + k);
            expiredObject = (ExpiredObject)this.map.remove(k);
            if (expiredObject != null) {
                expiredObject.getTask().cancel();
            }
        }
        finally {
            this.writeLock.unlock();
        }
        return expiredObject == null ? null : (V)expiredObject.getValue();
    }

    public int size() {
        return this.map.size();
    }

    public void exit() {
        this.timer.purge();
        this.timer = null;
    }

    public void setTimeToLive(Long l) {
        this.timeToLive = l;
    }

    class ExpiryTask<Ke>
    extends TimerTask {
        private final Ke key;

        public ExpiryTask(Ke Ke) {
            this.key = Ke;
        }

        public Ke getKey() {
            return this.key;
        }

        @Override
        public void run() {
            System.out.println("Expiring element with key [" + this.key + "]");
            try {
                TimedMap.this.writeLock.lock();
                if (TimedMap.this.map.containsKey(this.key)) {
                    TimedMap.this.map.remove(this.getKey());
                }
            }
            finally {
                TimedMap.this.writeLock.unlock();
            }
        }
    }

    class ExpiredObject<Ke, Va> {
        private final Va value;
        private final ExpiryTask<Ke> task;

        public ExpiredObject(Ke Ke, Va Va, long l) {
            this.value = Va;
            this.task = new ExpiryTask<Ke>(Ke);
            TimedMap.this.timer.schedule(this.task, l);
        }

        public ExpiryTask<Ke> getTask() {
            return this.task;
        }

        public Va getValue() {
            return this.value;
        }
    }
}

