/*
 * Decompiled with CFR 0.152.
 */
package commvault.cte.reports.util;

public final class CapacityFormatter {
    public static final long MULTIPLIER = 1024L;
    public static final CapacityFormatter BYTES = new CapacityFormatter(0, "B");
    public static final CapacityFormatter KBYTES = new CapacityFormatter(1, "KB");
    public static final CapacityFormatter MBYTES = new CapacityFormatter(2, "MB");
    public static final CapacityFormatter GBYTES = new CapacityFormatter(3, "GB");
    public static final CapacityFormatter TBYTES = new CapacityFormatter(4, "TB");
    public static final CapacityFormatter PBYTES = new CapacityFormatter(5, "PB");
    public static final CapacityFormatter EBYTES = new CapacityFormatter(6, "EB");
    public static final CapacityFormatter[] _formats = new CapacityFormatter[]{BYTES, KBYTES, MBYTES, GBYTES, TBYTES, PBYTES, EBYTES};
    public static final CapacityFormatter[] _formatsWithMB = new CapacityFormatter[]{MBYTES, GBYTES, TBYTES, PBYTES, EBYTES};
    private long _minfactor = 1L;
    private final String _units;

    public CapacityFormatter(int n, String string) {
        this._minfactor = (long)Math.pow(1024.0, n);
        this._units = string;
    }

    public long getMinFactor() {
        return this._minfactor;
    }

    public String getUnits() {
        return this._units;
    }

    public String toString() {
        return this._units;
    }
}

