/*
 * Decompiled with CFR 0.152.
 */
package commvault.cte.reports.util;

import commvault.cte.component.table.EvenOddTableCellRenderer;
import commvault.cte.reports.util.ReportConstants;
import commvault.cte.util.Logger;
import java.text.NumberFormat;
import java.text.ParseException;
import javax.swing.table.TableCellRenderer;

public class Capacity
extends Number
implements Comparable {
    private long _value = 0L;
    private double _fuzzyValue = 0.0;
    private String _text = null;

    public Capacity(long l) {
        this._value = l;
    }

    public Capacity(long l, Formatter formatter) {
        this.setValue(l, formatter);
    }

    public Capacity(double d, Formatter formatter) {
        this.setValue(d, formatter);
    }

    public Capacity() {
    }

    public void setValue(long l) {
        this._value = l;
        this._text = null;
    }

    public long getValue() {
        return this._value;
    }

    public void setValue(long l, Formatter formatter) {
        this._value = l * formatter.getMinFactor();
        this._text = null;
    }

    public void setValue(double d, Formatter formatter) {
        this._value = (long)(d * (double)formatter.getMinFactor());
        this._text = null;
    }

    public double getValue(Formatter formatter) {
        return this.doubleValue() / (double)formatter.getMinFactor();
    }

    protected String getText() {
        return this._text;
    }

    protected void setText(String string) {
        this._text = string;
    }

    public final int compareTo(Object object) {
        if (this == object) {
            return 0;
        }
        Capacity capacity = (Capacity)object;
        if (this._value < capacity._value) {
            return -1;
        }
        if (this._value > capacity._value) {
            return 1;
        }
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String toString() {
        if (this._text == null) {
            Capacity capacity = this;
            synchronized (capacity) {
                if (this._text == null) {
                    this._text = this.isNA() ? ReportConstants.NA_STRING : this.formatValue();
                }
            }
        }
        return this._text;
    }

    public boolean isNA() {
        return this.longValue() < 0L;
    }

    public final int hashCode() {
        return (int)(this._value ^ this._value >> 32);
    }

    public final boolean equals(Object object) {
        return this == object || object instanceof Capacity && this._value == ((Capacity)object)._value;
    }

    public boolean fuzzyEquals(Capacity capacity) {
        this.toString();
        capacity.toString();
        return this == capacity || this._fuzzyValue == capacity._fuzzyValue;
    }

    public boolean fuzzyLess(Capacity capacity) {
        this.toString();
        capacity.toString();
        return this != capacity && this._fuzzyValue < capacity._fuzzyValue;
    }

    public boolean fuzzyGreater(Capacity capacity) {
        this.toString();
        capacity.toString();
        return this != capacity && this._fuzzyValue > capacity._fuzzyValue;
    }

    public final long asLong() {
        return this._value;
    }

    protected double getFuzzyValue() {
        return this._fuzzyValue;
    }

    protected void setFuzzyValue(double d) {
        this._fuzzyValue = d;
    }

    private final String formatValue() {
        String string = null;
        Formatter formatter = null;
        NumberFormat numberFormat = NumberFormat.getInstance();
        numberFormat.setMaximumFractionDigits(2);
        double d = 0.0;
        String string2 = "0.0";
        for (int i = Formatter._formats.length - 1; i >= 0; --i) {
            formatter = Formatter._formats[i];
            long l = formatter.getMinFactor();
            if (this._value < l) continue;
            d = (double)this._value / (double)l;
            string2 = numberFormat.format(d);
            string = string2 + " " + formatter.getUnits();
            try {
                this._fuzzyValue = numberFormat.parse(string2).doubleValue();
                this._fuzzyValue *= (double)l;
            }
            catch (ParseException parseException) {
                this._fuzzyValue = d;
                Object[] objectArray = new Object[]{"Error. Determining capacity fuzzy value." + parseException};
                Logger.instance().println(objectArray);
            }
            return string;
        }
        formatter = Formatter._formats[0];
        string2 = numberFormat.format(this._value);
        this._fuzzyValue = this._value;
        string = string2 + " " + formatter.getUnits();
        return string;
    }

    public final Formatter getFormatter() {
        Formatter formatter = null;
        for (int i = Formatter._formats.length - 1; i >= 0; --i) {
            formatter = Formatter._formats[i];
            long l = formatter.getMinFactor();
            if (this._value < l) continue;
            return formatter;
        }
        formatter = Formatter._formats[0];
        return formatter;
    }

    @Override
    public double doubleValue() {
        return this._value;
    }

    @Override
    public float floatValue() {
        return this._value;
    }

    @Override
    public int intValue() {
        return (int)this._value;
    }

    @Override
    public long longValue() {
        return this._value;
    }

    public static final class CapacityTableCellRenderer
    extends EvenOddTableCellRenderer {
        private static CapacityTableCellRenderer _singleton = null;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public static TableCellRenderer getInstance() {
            if (_singleton != null) return _singleton;
            Class<CapacityTableCellRenderer> clazz = CapacityTableCellRenderer.class;
            synchronized (CapacityTableCellRenderer.class) {
                if (_singleton != null) return _singleton;
                _singleton = new CapacityTableCellRenderer();
                // ** MonitorExit[var0] (shouldn't be in output)
                return _singleton;
            }
        }

        private CapacityTableCellRenderer() {
            this.setHorizontalAlignment(4);
        }
    }

    public static final class Formatter {
        private static final long MULTIPLIER = 1024L;
        public static final Formatter BYTES = new Formatter(0, "B");
        public static final Formatter KBYTES = new Formatter(1, "KB");
        public static final Formatter MBYTES = new Formatter(2, "MB");
        public static final Formatter GBYTES = new Formatter(3, "GB");
        public static final Formatter TBYTES = new Formatter(4, "TB");
        public static final Formatter PBYTES = new Formatter(5, "PB");
        public static final Formatter EBYTES = new Formatter(6, "XB");
        public static final Formatter[] _formats = new Formatter[]{BYTES, KBYTES, MBYTES, GBYTES, TBYTES, PBYTES, EBYTES};
        private long _minfactor = 1L;
        private final String _units;

        public Formatter(int n, String string) {
            this._minfactor = (long)Math.pow(1024.0, n);
            this._units = string;
        }

        public long getMinFactor() {
            return this._minfactor;
        }

        public String getUnits() {
            return this._units;
        }

        public String toString() {
            return this._units;
        }
    }
}

