/*
 * Decompiled with CFR 0.152.
 */
package commvault.cte.reports.components;

import com.jidesoft.chart.Chart;
import com.jidesoft.chart.util.ChartUtils;
import com.jidesoft.grid.DefaultGroupRow;
import com.jidesoft.grid.MultilineTableCellRenderer;
import com.jidesoft.grid.TableModelWrapperUtils;
import com.jidesoft.grid.TreeExpandablePanel;
import com.jidesoft.grid.TreeTable;
import com.jidesoft.grid.TreeTableModel;
import com.jidesoft.utils.Base64;
import commvault.cte.CteStringBank;
import commvault.cte.component.CVFrame;
import commvault.cte.component.Utilities;
import commvault.cte.component.table.CVTreeTableRow;
import commvault.cte.component.table.decorator.ProgressBarTableCellRenderer;
import commvault.cte.component.table.decorator.ProgressValue;
import commvault.cte.component.table.renderer.IBulletRenderer;
import commvault.cte.component.table.renderer.StringNewLineWithState;
import commvault.cte.component.table.renderer.StringNewLineWithStateRenderer;
import commvault.cte.reports.components.ChartItem;
import commvault.cte.reports.components.ConversionType;
import commvault.cte.reports.components.ExcelHelper;
import commvault.cte.reports.components.HeaderItem;
import commvault.cte.reports.components.ImageEnum;
import commvault.cte.reports.components.LegendItem;
import commvault.cte.reports.components.PaperSizeEnum;
import commvault.cte.reports.components.ReportElementEnum;
import commvault.cte.reports.components.ReportItem;
import commvault.cte.reports.components.ReportLegend;
import commvault.cte.reports.components.TableItem;
import commvault.cte.reports.util.ReportConverterUtilities;
import commvault.cte.util.Logger;
import commvault.msgs.App.ExportFile;
import commvault.msgs.App.ExportFileType;
import commvault.qnet.sys.ProcessInfo;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.image.BufferedImage;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.URL;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Properties;
import java.util.TreeMap;
import java.util.Vector;
import javax.activation.DataHandler;
import javax.activation.DataSource;
import javax.activation.FileDataSource;
import javax.mail.BodyPart;
import javax.mail.MessagingException;
import javax.mail.Multipart;
import javax.mail.Session;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimeMultipart;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JProgressBar;
import javax.swing.JTable;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;

public class ReportFormatter {
    private List<ReportItem> builder = new Vector<ReportItem>();
    private List<String> images = new ArrayList<String>();
    private static final String bannerTitleStr = "<TABLE class='BANNER_TITLE'> <TR><TD> {0}</TD></TR> </TABLE>";
    private static final String chartTitleStr = "<TABLE class='CHART_TITLE'> <TR><TD> {0}</TD></TR> </TABLE>";
    private final String headerStr = "<CENTER><B><FONT SIZE='+1' COLOR='#0033CC'>{0}</B></FONT></CENTER>  ";
    private static final String labelCenterStr = "<CENTER>{0}</CENTER>";
    private static final String labelLeftStr = "<P CLASS='LEFT'>{0}</P>";
    private static final String cellBold = "<TD class='BOLD'>{0}</TD>";
    private static final String cellNormal = "<TD class='NORMAL'>{0}</TD>";
    private static final String cellMessagePanelStr = "<TD class='NORMAL' VALIGN='CENTER'> {0} {1}</TD>";
    private static String cellImageStr = "<TD ALIGN='left'> <img id='imageCell'  SRC= {0} > </TD>";
    private static final String messagePanelStr = "<TABLE> <TR> <TD class='NORMAL' VALIGN='CENTER'> {0} {1}</TD> </TR></TABLE>";
    private static final String emptyCellStr = "<td>&nbsp;</td>";
    private static String imageStr = "<IMG id='imageCell'  SRC={0}>";
    private static final String cellTitle = "<TD class='CHART_TITLE'>{0}</TD>";
    private static final String cellTitleGray = "<TD class='CHART_CHART_TITLE_GRAY'>{0}</TD>";
    private static final String bannerTwoTitleStr = "<TABLE class='BANNER_TITLE'> <TR><TD> {0}</TD><TD ALIGN='RIGHT'> {1}</TD></TR> </TABLE>";
    public static String LINE_SEPARATOR = "\n";
    private int imageIndex = 0;
    private final String IMAGE = "IMAGE_";
    private final String EXTENSION = ".png";
    private final String SPACE = new String("&nbsp;");
    private final String TAB_SPACE = new String("&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;");
    private final String EMPTY_STRING = new String("");
    private File workingFolder = null;
    private String templateLocation = null;
    private ConversionType conversionType = ConversionType.PDF;
    private boolean isMultipleCharts = false;
    private static int scale = 100;
    private String paperSize = PaperSizeEnum.Letter.toString();
    public static final int PORTRAIT = 1;
    public static final int LANDSCAPE = 2;
    private int pageOrientation = 2;
    public static int fileCount = 0;
    private String exportData = "";
    private boolean createNewFile = true;
    private String folder = "";
    private List<ExportFile> pdfExportFiles = new ArrayList<ExportFile>();

    public void setScale(int n) {
        scale = n;
    }

    public int getScale() {
        return scale;
    }

    public void setConversionType(ConversionType conversionType) {
        this.conversionType = conversionType;
    }

    public ConversionType getConversionType() {
        return this.conversionType;
    }

    public String getTemplateLoc() {
        return this.templateLocation;
    }

    public void setTemplateLoc(String string) {
        this.templateLocation = string;
    }

    public int getPageOrientation() {
        return this.pageOrientation;
    }

    public void setPageOrientation(int n) {
        this.pageOrientation = n;
    }

    public void setPaperSize(String string) {
        this.paperSize = string;
    }

    public String getPaperSize() {
        return this.paperSize;
    }

    public void setCreateNewFile(boolean bl) {
        this.createNewFile = bl;
    }

    public boolean isCreateNewFile() {
        return this.createNewFile;
    }

    public boolean isMultipleCharts() {
        return this.isMultipleCharts;
    }

    public void setIsMultipleCharts(boolean bl) {
        this.isMultipleCharts = bl;
    }

    public void addIndentedText(String string) {
        this.builder.add(new ReportItem(ReportElementEnum.INDENTED_TEXT, string));
    }

    public void addText(String string) {
        this.builder.add(new ReportItem(ReportElementEnum.TEXT, string));
    }

    public void addBoldText(String string) {
        this.builder.add(new ReportItem(ReportElementEnum.BOLD_TEXT, string));
    }

    public void addHorizontalRule() {
        this.builder.add(new ReportItem(ReportElementEnum.HORIZONTAL_RULE, null));
    }

    public void addBannerTitle(String string, String string2) {
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add(string);
        arrayList.add(string2);
        this.builder.add(new ReportItem(ReportElementEnum.BANNER_TWO_TITLE_LABEL, arrayList));
    }

    public void addBannerTitle(String string) {
        this.builder.add(new ReportItem(ReportElementEnum.BANNER_TITLE_LABEL, string));
    }

    public void addChartBannerTitle(String string) {
        if (this.conversionType == ConversionType.EXCEL) {
            return;
        }
        this.builder.add(new ReportItem(ReportElementEnum.CHART_BANNER_TITLE_LABEL, string));
    }

    public void addChart(ChartItem chartItem) {
        if (chartItem.isPieChart()) {
            this.builder.add(new ReportItem(ReportElementEnum.PIE_CHART, chartItem));
        } else {
            this.builder.add(new ReportItem(ReportElementEnum.CHART, chartItem));
        }
    }

    public void addPieChart(ChartItem chartItem) {
        this.builder.add(new ReportItem(ReportElementEnum.PIE_CHART, chartItem));
    }

    public void addMultipleChart(List<ChartItem> list) {
        this.builder.add(new ReportItem(ReportElementEnum.MULTIPLE_CHARTS, list));
    }

    public void addNewLine() {
        this.builder.add(new ReportItem(ReportElementEnum.NEW_LINE, null));
    }

    public void addNewFrame() {
        this.builder.add(new ReportItem(ReportElementEnum.NEW_FRAME, null));
    }

    public void removeLastEntry() {
        int n = this.builder.size();
        if (n > 0) {
            this.builder.remove(n - 1);
        }
    }

    public void addTable(JTable jTable) {
        TableItem tableItem = new TableItem(jTable);
        if (jTable.getRowCount() != 0) {
            this.builder.add(new ReportItem(ReportElementEnum.TABLE, tableItem));
        } else {
            this.addText(CteStringBank.No_data_found.getI18n());
        }
    }

    public void addTableItem(TableItem tableItem) {
        this.builder.add(new ReportItem(ReportElementEnum.TABLE, tableItem));
    }

    public void addDataTable(Vector vector) {
        this.builder.add(new ReportItem(ReportElementEnum.DATA_TABLE, vector));
    }

    public void addTreeTableTable(JTable jTable) {
        TableItem tableItem = new TableItem(jTable);
        tableItem.setTreeTable(true);
        this.builder.add(new ReportItem(ReportElementEnum.TABLE, tableItem));
    }

    public void setColumnCount(int n) {
        this.builder.add(new ReportItem(ReportElementEnum.COLUMN_COUNT, n));
    }

    public void addNewPage() {
        this.builder.add(new ReportItem(ReportElementEnum.NEW_PAGE, null));
    }

    public void addNewPage(String string) {
        this.builder.add(new ReportItem(ReportElementEnum.NEW_PAGE, string));
    }

    public void adjustPageTemplate(String string) {
        this.builder.add(new ReportItem(ReportElementEnum.PAGE_TEMPLATE, string));
    }

    public void addFrameBreak() {
        this.builder.add(new ReportItem(ReportElementEnum.FRAME_BREAK, true));
    }

    public void addFrameBreak(boolean bl) {
        this.builder.add(new ReportItem(ReportElementEnum.FRAME_BREAK, bl));
    }

    public void addLabelToCenter() {
        this.builder.add(new ReportItem(ReportElementEnum.LABEL_CENTER, null));
    }

    public void addLabelToLeft() {
        this.builder.add(new ReportItem(ReportElementEnum.LABEL_LEFT, null));
    }

    public void addMessagePanel(String string, Icon icon) {
        this.builder.add(new ReportItem(ReportElementEnum.MESSAGE_PANEL, string, icon));
    }

    public void addLegend(ReportLegend reportLegend) {
        this.builder.add(new ReportItem(ReportElementEnum.LEGEND, reportLegend));
    }

    public void addReportTitle(HeaderItem headerItem) {
        this.builder.add(new ReportItem(ReportElementEnum.REPORT_TITLE, headerItem));
    }

    public void addReportSummary(Vector vector) {
        this.builder.add(new ReportItem(ReportElementEnum.TASK_SUMMARY, vector));
    }

    public boolean buildReport(String string, ConversionType conversionType) {
        try {
            switch (conversionType) {
                case PDF: {
                    this.createPDFFile(string);
                    break;
                }
                case MHTML: {
                    this.createHTMLFile(string);
                    break;
                }
                case EXCEL: {
                    ExcelHelper excelHelper = new ExcelHelper(ConversionType.EXCEL);
                    excelHelper.setWebReport(true);
                    this.exportData = excelHelper.generateExportData(this.builder);
                }
            }
            return true;
        }
        catch (OutOfMemoryError outOfMemoryError) {
            CVFrame.instance().resetCursor();
            Utilities.showErrorMessage(CteStringBank.Out_Of_Memory_Error.getI18n(), true);
            outOfMemoryError.printStackTrace();
            return false;
        }
        catch (Exception exception) {
            CVFrame.instance().resetCursor();
            Utilities.showErrorMessage(CteStringBank.Unable_to_save_file.getI18n(), true);
            exception.printStackTrace();
            return false;
        }
    }

    public List<ReportItem> getBuilder() {
        return this.builder;
    }

    public String getExportData() {
        return this.exportData;
    }

    public boolean createTempFolder() {
        Boolean bl = (Boolean)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                String string = System.getProperty("java.io.tmpdir");
                return ReportFormatter.this.setFileLocation(string);
            }
        });
        return bl;
    }

    private boolean setFileLocation(String string) {
        Logger.write(Logger.INFO, this, "ReportFormatter", "report conversion path for temporary files: " + string);
        this.folder = string + File.separator + "temp_" + this.getFilenameTimeStamp();
        try {
            File file = new File(this.folder);
            if (!file.exists() && !file.mkdir()) {
                Logger.write(Logger.ERROR, this, "setFileLocation", "Unable to create temp folder. Images will not be created");
                return false;
            }
            if (!file.canWrite()) {
                return false;
            }
            file.deleteOnExit();
            this.workingFolder = file;
        }
        catch (Exception exception) {
            Logger.write(Logger.ERROR, this, "setFileLocation", "Unable to create temp folder. Images will not be created");
            return false;
        }
        Logger.write(Logger.INFO, this, "ReportFormatter", "working folder created");
        return true;
    }

    private String getFilenameTimeStamp() {
        Calendar calendar = Calendar.getInstance();
        String string = "";
        string = string + Utilities.formatNum(calendar.get(2) + 1) + Utilities.formatNum(calendar.get(5)) + calendar.get(1);
        string = string + "_" + Utilities.formatNum(calendar.get(11)) + Utilities.formatNum(calendar.get(12)) + Utilities.formatNum(calendar.get(13));
        return string;
    }

    private boolean encodeImage(Icon icon, String string) {
        return true;
    }

    private boolean encodeComponent(JComponent jComponent, String string, boolean bl) {
        try {
            if (jComponent instanceof Chart) {
                ((Chart)jComponent).setAnimateOnShow(false);
            }
            if (bl && !this.images.contains(string) || !bl) {
                File file = new File(this.folder + File.separator + string);
                file.deleteOnExit();
                BufferedImage bufferedImage = new BufferedImage(jComponent.getPreferredSize().width, jComponent.getPreferredSize().height, 1);
                Graphics graphics = bufferedImage.getGraphics();
                jComponent.print(graphics);
                ChartUtils.writePngToFile((Component)jComponent, (File)file);
                this.images.add(file.getName());
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return false;
        }
        return true;
    }

    private String getNewImageName() {
        return "IMAGE_" + this.imageIndex++ + ".png";
    }

    public void createHTMLFile(String string) {
        Object object;
        final String string2 = this.getHTMLString();
        URL uRL = this.getClass().getClassLoader().getResource("styleSheets/BlueThemeStyle.css");
        System.out.println("StyleSheets URL: " + uRL);
        File file = new File(this.folder + "\\BlueThemeStyle.css");
        System.out.println("StyleSheet destination file: " + file.getAbsolutePath());
        try {
            int n;
            object = new BufferedInputStream(uRL.openStream());
            BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(new FileOutputStream(file));
            byte[] byArray = new byte[2048];
            while ((n = ((InputStream)object).read(byArray)) > 0) {
                ((OutputStream)bufferedOutputStream).write(byArray, 0, n);
            }
            ((OutputStream)bufferedOutputStream).flush();
            ((OutputStream)bufferedOutputStream).close();
            ((InputStream)object).close();
            System.out.println("Stylesheet saved to: " + file.getAbsolutePath());
        }
        catch (Exception exception) {
            System.out.println("Unable to save Stylesheet file");
            exception.printStackTrace();
        }
        object = file;
        AccessController.doPrivileged(new PrivilegedAction((File)object, string){
            final /* synthetic */ File val$cssFile;
            final /* synthetic */ String val$fileName;
            {
                this.val$cssFile = file;
                this.val$fileName = string22;
            }

            public Object run() {
                try {
                    Object object2;
                    Properties properties = new Properties();
                    Session session = Session.getInstance((Properties)properties, null);
                    MimeMessage mimeMessage = new MimeMessage(session);
                    MimeMultipart mimeMultipart = new MimeMultipart("related");
                    MimeBodyPart mimeBodyPart = new MimeBodyPart();
                    mimeBodyPart.setContent((Object)string2, "text/html; charset=UTF-8");
                    mimeMultipart.addBodyPart((BodyPart)mimeBodyPart);
                    if (this.val$cssFile != null) {
                        mimeMultipart.addBodyPart(ReportFormatter.bodyPart((DataSource)new FileDataSource(this.val$cssFile)));
                    }
                    for (Object object2 : ReportFormatter.this.images) {
                        mimeMultipart.addBodyPart(ReportFormatter.bodyPart((DataSource)new FileDataSource(ReportFormatter.this.folder + "\\" + (String)object2)));
                    }
                    mimeMessage.setContent((Multipart)mimeMultipart);
                    mimeMessage.setSubject("MHTML Report");
                    File file = new File(this.val$fileName);
                    object2 = new FileOutputStream(file);
                    mimeMessage.writeTo((OutputStream)object2);
                    if (ReportFormatter.this.workingFolder != null) {
                        File[] fileArray = ReportFormatter.this.workingFolder.listFiles();
                        for (int i = 0; i < fileArray.length; ++i) {
                            fileArray[i].delete();
                        }
                        ReportFormatter.this.workingFolder.delete();
                    }
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
                return null;
            }
        });
    }

    public String getHTMLString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("<HTML>").append(LINE_SEPARATOR);
        stringBuilder.append("<head><link rel='stylesheet' type='text/css' href='BlueThemeStyle.css' /> <meta charset='UTF-8'></head>").append(LINE_SEPARATOR);
        stringBuilder.append("<BODY BGCOLOR='#FFFFFF' WIDTH='100%'>").append(LINE_SEPARATOR);
        for (ReportItem reportItem : this.builder) {
            switch (reportItem.getProperty()) {
                case TEXT: {
                    stringBuilder.append(reportItem.getValue()).append("<BR>").append(LINE_SEPARATOR);
                    break;
                }
                case BOLD_TEXT: {
                    stringBuilder.append("<B>").append(reportItem.getValue()).append("</B><BR>");
                    break;
                }
                case HORIZONTAL_RULE: {
                    stringBuilder.append("<HR>").append(LINE_SEPARATOR);
                    break;
                }
                case CHART_BANNER_TITLE_LABEL: 
                case BANNER_TITLE_LABEL: {
                    stringBuilder.append(MessageFormat.format(bannerTitleStr, reportItem.getValue())).append(LINE_SEPARATOR);
                    break;
                }
                case BANNER_TWO_TITLE_LABEL: {
                    List list = (List)reportItem.getValue();
                    stringBuilder.append(MessageFormat.format(bannerTwoTitleStr, list.get(0), list.get(1))).append(LINE_SEPARATOR);
                    break;
                }
                case NEW_LINE: {
                    stringBuilder.append("<BR>");
                    break;
                }
                case HEADER: {
                    stringBuilder.append(MessageFormat.format("<CENTER><B><FONT SIZE='+1' COLOR='#0033CC'>{0}</B></FONT></CENTER>  ", reportItem.getValue()));
                    break;
                }
                case LABEL_CENTER: {
                    stringBuilder.append(MessageFormat.format(labelCenterStr, reportItem.getValue()));
                    break;
                }
                case LABEL_LEFT: {
                    stringBuilder.append(MessageFormat.format(labelLeftStr, reportItem.getValue())).append(LINE_SEPARATOR);
                    break;
                }
                case TASK_SUMMARY: {
                    stringBuilder.append(this.getSummaryHTMLString((Vector)reportItem.getValue()));
                    break;
                }
                case REPORT_TITLE: {
                    stringBuilder.append(this.getTitleHTMLString((HeaderItem)reportItem.getValue()));
                    break;
                }
                case MESSAGE_PANEL: {
                    stringBuilder.append(this.getMessagePanelHTMLString(reportItem.getValue().toString(), reportItem.getIcon())).append(LINE_SEPARATOR);
                    break;
                }
                case MULTIPLE_CHARTS: {
                    stringBuilder.append(this.getMultipleChartsHTMLString(reportItem.getValue())).append(LINE_SEPARATOR);
                    break;
                }
                case CHART: 
                case PIE_CHART: {
                    stringBuilder.append(this.getChartHTMLString(reportItem.getValue())).append(LINE_SEPARATOR);
                    break;
                }
                case TABLE: {
                    stringBuilder.append(this.getTableHTMLString(reportItem.getValue())).append(LINE_SEPARATOR);
                    break;
                }
                case INDENTED_TEXT: {
                    stringBuilder.append(this.TAB_SPACE).append(reportItem.getValue().toString()).append("<BR>").append(LINE_SEPARATOR);
                    break;
                }
                case LEGEND: {
                    stringBuilder.append(this.getLegendHTMLString((ReportLegend)reportItem.getValue()));
                    break;
                }
                case DATA_TABLE: {
                    stringBuilder.append(this.getDataTableHTMLString((Vector)reportItem.getValue())).append(LINE_SEPARATOR);
                }
            }
        }
        stringBuilder.append("</BODY>");
        stringBuilder.append("</HTML>");
        return stringBuilder.toString();
    }

    private String getSummaryHTMLString(Vector vector) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("<TABLE>");
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            stringBuilder.append("<TR>");
            stringBuilder.append(LINE_SEPARATOR);
            Vector vector2 = (Vector)enumeration.nextElement();
            stringBuilder.append(MessageFormat.format(cellBold, this.getHTMLCompatibleString(vector2.elementAt(0).toString())));
            stringBuilder.append(MessageFormat.format(cellNormal, vector2.elementAt(1)));
            stringBuilder.append(LINE_SEPARATOR);
            stringBuilder.append("</TR>");
            stringBuilder.append(LINE_SEPARATOR);
        }
        stringBuilder.append("</TABLE>");
        stringBuilder.append(LINE_SEPARATOR);
        return stringBuilder.toString();
    }

    private String getChartMessagesHTMLString(List<String> list) {
        Vector vector;
        Vector<Vector> vector2 = new Vector<Vector>();
        for (String object2 : list) {
            vector = new Vector();
            vector.add(object2);
            vector2.add(vector);
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("<TABLE>");
        Enumeration enumeration = vector2.elements();
        while (enumeration.hasMoreElements()) {
            stringBuilder.append("<TR>");
            stringBuilder.append(LINE_SEPARATOR);
            vector = (Vector)enumeration.nextElement();
            stringBuilder.append(MessageFormat.format(cellNormal, vector.elementAt(0).toString()));
            stringBuilder.append(LINE_SEPARATOR);
            stringBuilder.append("</TR>");
            stringBuilder.append(LINE_SEPARATOR);
        }
        stringBuilder.append("</TABLE>");
        stringBuilder.append(LINE_SEPARATOR);
        return stringBuilder.toString();
    }

    private String getTitleHTMLString(HeaderItem headerItem) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("<HR>").append(LINE_SEPARATOR);
        stringBuilder.append("<BR>");
        stringBuilder.append(MessageFormat.format("<CENTER><B><FONT SIZE='+1' COLOR='#0033CC'>{0}</B></FONT></CENTER>  ", headerItem.getTitle()));
        if (headerItem.getTimeStamp() != null) {
            stringBuilder.append(MessageFormat.format(labelCenterStr, headerItem.getTimeStamp()));
            if (headerItem.getExtraInfo() != null) {
                stringBuilder.append(MessageFormat.format(labelCenterStr, headerItem.getExtraInfo()));
            }
        } else if (headerItem.getHeaderItem().size() == 1) {
            stringBuilder.append(MessageFormat.format(labelCenterStr, headerItem.getHeaderItem().get(0).toString()));
        }
        return stringBuilder.toString();
    }

    private String getInfoMessagePanelHTMLString(String string, Icon icon) {
        return this.getMessagePanelHTMLString(string, icon, messagePanelStr, ImageEnum.InfoIcon.getName());
    }

    private String getInfoMessagePanelHTMLString(String string, Icon icon, String string2) {
        return this.getMessagePanelHTMLString(string, icon, string2, ImageEnum.InfoIcon.getName());
    }

    private String getMessagePanelHTMLString(String string, Icon icon) {
        String string2 = this.getImageName(icon);
        return this.getMessagePanelHTMLString(string, icon, messagePanelStr, string2);
    }

    private String getMessagePanelHTMLString(String string, Icon icon, String string2, String string3) {
        Object[] objectArray = new Object[]{"", string};
        if (this.encodeImage(icon, string3)) {
            objectArray[0] = "<IMG SRC='" + string3 + "'>";
        }
        return MessageFormat.format(string2, objectArray);
    }

    private String getChartHTMLString(Object object) {
        String string;
        ChartItem chartItem = (ChartItem)object;
        StringBuilder stringBuilder = new StringBuilder();
        ChartItem chartItem2 = (ChartItem)object;
        stringBuilder.append("<div id='chartDiv'>");
        if (chartItem2.getTitle() != null) {
            stringBuilder.append(MessageFormat.format(chartTitleStr, chartItem2.getTitle())).append(LINE_SEPARATOR);
        }
        if (chartItem2.getChart() == null) {
            if (chartItem2.getMessage() != null) {
                stringBuilder.append(this.getMessagePanelHTMLString(chartItem2.getMessage(), chartItem2.getIcon()));
            }
        } else if (chartItem2.getHeader() != null && chartItem2.getHeader().size() > 0) {
            stringBuilder.append("<TABLE  WIDTH='100%' style='page-break-inside:avoid;'>").append(LINE_SEPARATOR);
            stringBuilder.append("<TR>").append(LINE_SEPARATOR);
            if (chartItem2.getHeader() != null && chartItem2.getHeader().size() > 0) {
                if (chartItem2.getTitle() != null) {
                    stringBuilder.append(MessageFormat.format(cellNormal, chartItem2.getHeader().get(0)));
                } else {
                    stringBuilder.append(MessageFormat.format(cellBold, chartItem2.getHeader().get(0)));
                }
            } else {
                stringBuilder.append(emptyCellStr);
            }
            stringBuilder.append(LINE_SEPARATOR);
            stringBuilder.append("</TR>").append(LINE_SEPARATOR);
            for (int i = 1; i < chartItem2.getHeader().size(); ++i) {
                stringBuilder.append("<TR>").append(LINE_SEPARATOR);
                stringBuilder.append(MessageFormat.format(cellNormal, chartItem2.getHeader().get(i).toString()));
                stringBuilder.append(LINE_SEPARATOR);
                stringBuilder.append("</TR>").append(LINE_SEPARATOR);
            }
            stringBuilder.append("<TR>").append(LINE_SEPARATOR);
            string = this.getNewImageName();
            if (this.encodeComponent(chartItem2.getChart(), string, false)) {
                stringBuilder.append(MessageFormat.format(cellImageStr, string));
            } else {
                stringBuilder.append(emptyCellStr);
            }
            stringBuilder.append(LINE_SEPARATOR);
            stringBuilder.append("</TR>").append(LINE_SEPARATOR);
            stringBuilder.append("</TABLE>").append(LINE_SEPARATOR);
        } else {
            string = this.getNewImageName();
            if (this.encodeComponent(chartItem.getChart(), string, false)) {
                stringBuilder.append(MessageFormat.format(imageStr, string) + "<BR>");
            }
        }
        stringBuilder.append("</div>");
        if (chartItem.isChartContainsMsgs()) {
            stringBuilder.append("<TR>").append(LINE_SEPARATOR);
            string = this.getChartMessagesHTMLString(chartItem.getMsgStrings());
            stringBuilder.append(MessageFormat.format(cellNormal, string));
            stringBuilder.append("</TR>").append(LINE_SEPARATOR);
        }
        return stringBuilder.toString();
    }

    private String getMultiChartHTMLStringForWeb(List<ChartItem> list) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("<TABLE WIDTH='100%'>").append(LINE_SEPARATOR);
        stringBuilder.append("<TR>").append(LINE_SEPARATOR);
        for (ChartItem chartItem : list) {
            stringBuilder.append("<TD>").append(LINE_SEPARATOR);
            if (chartItem.isTitleBackground()) {
                stringBuilder.append(MessageFormat.format(cellTitleGray, chartItem.getTitle())).append(LINE_SEPARATOR);
            } else {
                stringBuilder.append(MessageFormat.format(cellBold, chartItem.getTitle())).append(LINE_SEPARATOR);
            }
            stringBuilder.append("</TD>").append(LINE_SEPARATOR);
            stringBuilder.append(LINE_SEPARATOR);
        }
        stringBuilder.append("</TR>").append(LINE_SEPARATOR);
        for (ChartItem chartItem : list) {
            stringBuilder.append("<TD>").append(LINE_SEPARATOR);
            File file = new File(chartItem.getImageFile());
            stringBuilder.append(MessageFormat.format(cellImageStr, file.getName()));
            this.images.add(chartItem.getImageFile());
            stringBuilder.append("</TD>").append(LINE_SEPARATOR);
        }
        stringBuilder.append("</TR>").append(LINE_SEPARATOR);
        stringBuilder.append("</TABLE>").append(LINE_SEPARATOR);
        stringBuilder.append("<BR>");
        return stringBuilder.toString();
    }

    private String getChartHTMLStringForWeb(ChartItem chartItem) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("<TABLE WIDTH='100%' style='page-break-inside:avoid;'>").append(LINE_SEPARATOR);
        stringBuilder.append("<TR>").append(LINE_SEPARATOR);
        stringBuilder.append("<TD>").append(LINE_SEPARATOR);
        File file = new File(chartItem.getImageFile());
        stringBuilder.append(MessageFormat.format(cellImageStr, file.getName()));
        this.images.add(chartItem.getImageFile());
        stringBuilder.append("</TD>").append(LINE_SEPARATOR);
        stringBuilder.append("</TR>").append(LINE_SEPARATOR);
        stringBuilder.append("</TABLE>").append(LINE_SEPARATOR);
        stringBuilder.append("<BR>");
        return stringBuilder.toString();
    }

    private String getMultipleChartsHTMLString(Object object) {
        List list = (List)object;
        ChartItem chartItem = (ChartItem)list.get(0);
        ChartItem chartItem2 = (ChartItem)list.get(1);
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        if (chartItem.getHeader() != null) {
            n = chartItem.getHeader().size();
            n2 = chartItem.getHeader().size();
        }
        if (chartItem2.getHeader() != null) {
            n = chartItem2.getHeader().size();
            n3 = chartItem2.getHeader().size();
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("<TABLE  WIDTH='100%'>").append(LINE_SEPARATOR);
        if (chartItem.getTitle() != null && chartItem2.getTitle() != null) {
            stringBuilder.append("<TR>").append(LINE_SEPARATOR);
            stringBuilder.append(MessageFormat.format(cellTitle, chartItem.getTitle())).append(LINE_SEPARATOR);
            stringBuilder.append(LINE_SEPARATOR);
            stringBuilder.append(MessageFormat.format(cellTitle, chartItem2.getTitle())).append(LINE_SEPARATOR);
            stringBuilder.append(LINE_SEPARATOR);
            stringBuilder.append("</TR>").append(LINE_SEPARATOR);
        }
        stringBuilder.append("<TR>").append(LINE_SEPARATOR);
        if (chartItem.getHeader() != null && chartItem.getHeader().size() > 0) {
            if (chartItem.getTitle() != null) {
                stringBuilder.append(MessageFormat.format(cellNormal, chartItem.getHeader().get(0)));
            } else {
                stringBuilder.append(MessageFormat.format(cellBold, chartItem.getHeader().get(0)));
            }
        } else {
            stringBuilder.append(emptyCellStr);
        }
        if (chartItem2.getHeader() != null && chartItem2.getHeader().size() > 0) {
            if (chartItem2.getTitle() != null) {
                stringBuilder.append(MessageFormat.format(cellNormal, chartItem2.getHeader().get(0)));
            } else {
                stringBuilder.append(MessageFormat.format(cellBold, chartItem2.getHeader().get(0)));
            }
        } else {
            stringBuilder.append(emptyCellStr);
        }
        stringBuilder.append(LINE_SEPARATOR);
        stringBuilder.append("</TR>").append(LINE_SEPARATOR);
        for (int i = 1; i < n; ++i) {
            stringBuilder.append("<TR>").append(LINE_SEPARATOR);
            if (i < n2) {
                stringBuilder.append(MessageFormat.format(cellNormal, chartItem.getHeader().get(i).toString()));
            } else if (i == n2 && chartItem.getChart() == null) {
                stringBuilder.append(this.getInfoMessagePanelHTMLString(chartItem.getMessage(), chartItem.getIcon(), cellMessagePanelStr));
            } else {
                stringBuilder.append(emptyCellStr);
            }
            stringBuilder.append(LINE_SEPARATOR);
            if (i < n3) {
                stringBuilder.append(MessageFormat.format(cellNormal, chartItem2.getHeader().get(i).toString()));
            } else if (i >= n3 && chartItem2.getChart() == null) {
                stringBuilder.append(this.getInfoMessagePanelHTMLString(chartItem2.getMessage(), chartItem2.getIcon(), cellMessagePanelStr));
            } else {
                stringBuilder.append(emptyCellStr);
            }
            stringBuilder.append(LINE_SEPARATOR);
            stringBuilder.append("</TR>").append(LINE_SEPARATOR);
        }
        stringBuilder.append("<TR>").append(LINE_SEPARATOR);
        if (chartItem.getChart() != null) {
            String string = this.getNewImageName();
            if (this.encodeComponent(chartItem.getChart(), string, false)) {
                stringBuilder.append(MessageFormat.format(cellImageStr, string));
            } else {
                stringBuilder.append(emptyCellStr);
            }
        } else if (chartItem.getMessage() != null) {
            stringBuilder.append(this.getInfoMessagePanelHTMLString(chartItem.getMessage(), chartItem.getIcon(), cellMessagePanelStr));
        } else {
            stringBuilder.append(emptyCellStr);
        }
        stringBuilder.append(LINE_SEPARATOR);
        if (chartItem2.getChart() != null) {
            String string = this.getNewImageName();
            if (this.encodeComponent(chartItem2.getChart(), string, false)) {
                stringBuilder.append(MessageFormat.format(cellImageStr, string));
            } else {
                stringBuilder.append(emptyCellStr);
            }
        } else if (chartItem2.getMessage() != null) {
            stringBuilder.append(this.getInfoMessagePanelHTMLString(chartItem2.getMessage(), chartItem2.getIcon(), cellMessagePanelStr));
        } else {
            stringBuilder.append(emptyCellStr);
        }
        stringBuilder.append("</TR>").append(LINE_SEPARATOR);
        if (chartItem.isChartContainsMsgs() || chartItem2.isChartContainsMsgs()) {
            stringBuilder.append("<TR>");
            if (chartItem.isChartContainsMsgs()) {
                String string = this.getChartMessagesHTMLString(chartItem.getMsgStrings());
                stringBuilder.append(MessageFormat.format(cellNormal, string));
            } else {
                stringBuilder.append(emptyCellStr);
            }
            if (chartItem2.isChartContainsMsgs()) {
                String string = this.getChartMessagesHTMLString(chartItem2.getMsgStrings());
                stringBuilder.append(MessageFormat.format(cellNormal, string));
            } else {
                stringBuilder.append(emptyCellStr);
            }
            stringBuilder.append("</TR>").append(LINE_SEPARATOR);
        }
        stringBuilder.append("</TABLE>").append(LINE_SEPARATOR);
        stringBuilder.append("<BR>");
        return stringBuilder.toString();
    }

    private String getHTMLCompatibleString(String string) {
        string = string.replaceAll(" ", this.SPACE);
        string = string.replaceAll("\n", "<BR>");
        return string;
    }

    private String getHTMLCompatibleBulletString(String string) {
        string = string.replaceAll(" ", this.SPACE);
        String[] stringArray = string.split("\n");
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < stringArray.length; ++i) {
            String string2 = stringArray[i];
            if (string2 == null || string2.length() <= 0) continue;
            stringBuilder.append("<LI>");
            stringBuilder.append(stringArray[i]);
            stringBuilder.append("</LI>");
        }
        return stringBuilder.toString();
    }

    private String getTableHTMLString(Object object) {
        StringBuilder stringBuilder = new StringBuilder();
        TableItem tableItem = (TableItem)object;
        JTable jTable = tableItem.getTable();
        if (tableItem.isTreeTable()) {
            stringBuilder.append(this.getHTMLStringForTreeTable((TreeTable)jTable));
        } else if (jTable.getRowCount() == 0 && tableItem.getTablePanel() != null) {
            stringBuilder.append(this.getInfoMessagePanelHTMLString(tableItem.getTablePanel().getMessage(), tableItem.getTablePanel().getMessageIcon()));
        } else {
            stringBuilder.append(this.getHTMLStringForTable(tableItem));
        }
        return stringBuilder.toString();
    }

    private String getImageName(Icon icon) {
        String string = "";
        if (icon instanceof ImageIcon && ((ImageIcon)icon).getDescription() != null) {
            string = ((ImageIcon)icon).getDescription();
            if (string.indexOf("/") != -1 && string.lastIndexOf("/") < string.length()) {
                string = string.substring(string.lastIndexOf("/") + 1);
            }
            if (string.indexOf(".") != -1) {
                string = string.substring(0, string.indexOf("."));
            }
            string = string.length() < 0 ? this.getNewImageName() : string + ".png";
        } else {
            string = this.getNewImageName();
        }
        return string;
    }

    private String getHTMLStringForTable(TableItem tableItem) {
        Object object;
        int n;
        Object object2;
        JTable jTable = tableItem.getTable();
        List list = tableItem.getHiddenHeaderList();
        TableCellRenderer[] tableCellRendererArray = new TableCellRenderer[jTable.getColumnCount()];
        for (int i = tableCellRendererArray.length - 1; i >= 0; --i) {
            object2 = jTable.getDefaultRenderer(jTable.getColumnClass(i));
            tableCellRendererArray[i] = object2 instanceof JLabel ? object2 : null;
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("<TABLE  CLASS='REPORT' >").append(LINE_SEPARATOR);
        object2 = jTable.getColumnModel();
        int n2 = jTable.getColumnCount();
        int n3 = 0;
        for (n = 0; n < n2; ++n) {
            object = jTable.getDefaultRenderer(jTable.getColumnClass(n));
            if (object instanceof IBulletRenderer) continue;
            stringBuilder.append("<TH CLASS='REPORT_HEADER' >");
            if (list != null && list.contains(object2.getColumn(n).getHeaderValue().toString())) {
                stringBuilder.append(this.SPACE);
            } else {
                stringBuilder.append(this.getHTMLCompatibleString(object2.getColumn(n).getHeaderValue().toString()));
            }
            stringBuilder.append("</TH>").append(LINE_SEPARATOR);
            ++n3;
        }
        for (n = 0; n < jTable.getRowCount(); ++n) {
            if (n % 2 == 0) {
                stringBuilder.append("<TR CLASS='LIGHT_GRAY'>").append(LINE_SEPARATOR);
            } else {
                stringBuilder.append("<TR CLASS='LIGHT_BLUE'>").append(LINE_SEPARATOR);
            }
            object = new TreeMap();
            for (int i = 0; i < jTable.getColumnCount(); ++i) {
                boolean bl = false;
                boolean bl2 = false;
                Object object3 = jTable.getValueAt(n, i);
                String string = this.EMPTY_STRING;
                if (object3 == null) {
                    string = this.SPACE;
                } else {
                    Object object4;
                    TableCellRenderer tableCellRenderer = jTable.getCellRenderer(n, i);
                    if (tableCellRenderer == null) {
                        string = this.getHTMLCompatibleString(object3.toString());
                    } else if (tableCellRenderer instanceof MultilineTableCellRenderer) {
                        string = this.getHTMLCompatibleString(object3.toString());
                    } else if (tableCellRenderer instanceof ProgressBarTableCellRenderer) {
                        if (tableCellRenderer.getTableCellRendererComponent(jTable, object3, false, false, n, i) instanceof JProgressBar) {
                            object4 = (JProgressBar)tableCellRenderer.getTableCellRendererComponent(jTable, object3, false, false, n, i);
                            string = Integer.toString(((JProgressBar)object4).getValue()) + " %";
                        } else if (object3 instanceof ProgressValue) {
                            string = object3.toString();
                        }
                    } else if (tableCellRenderer instanceof StringNewLineWithStateRenderer) {
                        if (object3 instanceof StringNewLineWithState) {
                            object4 = (StringNewLineWithState)object3;
                            string = ((StringNewLineWithState)object4).getDisplayText();
                        }
                    } else if (tableCellRenderer instanceof IBulletRenderer) {
                        string = this.getHTMLCompatibleBulletString(object3.toString());
                        object4 = object2.getColumn(i).getHeaderValue().toString();
                        object.put(object4, string);
                        bl2 = true;
                    } else if (object3 instanceof Boolean) {
                        string = (Boolean)object3 == true ? ReportConverterUtilities.getLocalizedString(CteStringBank.Yes) : ReportConverterUtilities.getLocalizedString(CteStringBank.No);
                    } else if (object3 instanceof DefaultGroupRow) {
                        if (tableCellRenderer.getTableCellRendererComponent(jTable, object3, false, false, n, i) instanceof TreeExpandablePanel) {
                            string = object3.toString();
                        }
                    } else if (object3 instanceof String) {
                        string = object3.toString();
                    } else {
                        Icon icon;
                        String string2;
                        object4 = (JLabel)tableCellRenderer.getTableCellRendererComponent(jTable, object3, false, false, n, i);
                        if (((JLabel)object4).getHorizontalAlignment() == 0) {
                            bl = true;
                        }
                        if ((string2 = ((JLabel)object4).getText()).indexOf("HTML") != -1 || string2.indexOf("html") != -1) {
                            string2 = ReportConverterUtilities.removeHTMLTagsFromString(((JLabel)object4).getText());
                        }
                        if ((icon = ((JLabel)object4).getIcon()) != null) {
                            String string3 = this.getImageName(icon);
                            if (this.encodeImage(icon, string3)) {
                                string = MessageFormat.format(imageStr, string3);
                            }
                            string = string + this.getHTMLCompatibleString(string2);
                        } else {
                            string = this.SPACE + this.getHTMLCompatibleString(string2);
                        }
                    }
                }
                if (bl2) continue;
                if (string.trim().length() == 0) {
                    string = this.SPACE;
                }
                if (bl) {
                    stringBuilder.append("<TD class='REPORT_CENTER'>");
                } else {
                    stringBuilder.append("<TD class='REPORT'>");
                }
                stringBuilder.append(string);
                stringBuilder.append("</TD>").append(LINE_SEPARATOR);
            }
            stringBuilder.append("</TR>").append(LINE_SEPARATOR);
            if (object.size() <= 0) continue;
            for (String string : object.keySet()) {
                String string4 = (String)object.get(string);
                if (n % 2 == 0) {
                    stringBuilder.append("<TR CLASS='LIGHT_GRAY'>").append(LINE_SEPARATOR);
                } else {
                    stringBuilder.append("<TR CLASS='LIGHT_BLUE'>").append(LINE_SEPARATOR);
                }
                if (string4.trim().length() == 0) {
                    string4 = this.SPACE;
                }
                stringBuilder.append("<TD class='REPORT' colspan=" + n3 + "><u>" + string + "</u><br/>");
                stringBuilder.append(string4);
                stringBuilder.append("</TD>").append(LINE_SEPARATOR);
                stringBuilder.append("</TR>").append(LINE_SEPARATOR);
            }
        }
        stringBuilder.append("</TABLE>").append(LINE_SEPARATOR);
        return stringBuilder.toString();
    }

    private String getHTMLStringForTreeTable(TreeTable treeTable) {
        StringBuilder stringBuilder = new StringBuilder();
        int n = treeTable.getColumnCount();
        int n2 = 0;
        Object object = null;
        TreeTableModel treeTableModel = (TreeTableModel)TableModelWrapperUtils.getActualTableModel((TableModel)treeTable.getModel());
        TableCellRenderer[] tableCellRendererArray = new TableCellRenderer[n];
        for (int i = tableCellRendererArray.length - 1; i >= 0; --i) {
            TableCellRenderer tableCellRenderer = treeTable.getDefaultRenderer(treeTable.getColumnClass(i));
            tableCellRendererArray[i] = tableCellRenderer instanceof JLabel ? tableCellRenderer : null;
        }
        stringBuilder.append("<TABLE WIDTH=100% BORDER=1 CELLSPACING=0 CELLPADDING=3 BORDERCOLOR='black' >").append(LINE_SEPARATOR);
        TableColumnModel tableColumnModel = treeTable.getColumnModel();
        for (int i = 0; i < n; ++i) {
            stringBuilder.append("<TH>");
            stringBuilder.append(this.getHTMLCompatibleString(tableColumnModel.getColumn(i).getHeaderValue().toString()));
            stringBuilder.append("</TH>").append(LINE_SEPARATOR);
        }
        StringBuilder stringBuilder2 = new StringBuilder();
        Iterator iterator = treeTableModel.getRows().iterator();
        while (iterator.hasNext()) {
            if (n2 % 2 == 0) {
                stringBuilder.append("<TR CLASS='LIGHT_GRAY'>").append(LINE_SEPARATOR);
            } else {
                stringBuilder.append("<TR CLASS='LIGHT_BLUE'>").append(LINE_SEPARATOR);
            }
            CVTreeTableRow cVTreeTableRow = (CVTreeTableRow)((Object)iterator.next());
            stringBuilder2.replace(0, stringBuilder.length(), this.EMPTY_STRING);
            for (int i = 0; i < n; ++i) {
                boolean bl = false;
                int n3 = treeTable.convertColumnIndexToModel(i);
                object = treeTableModel.getValueAt(n2, n3);
                String string = this.EMPTY_STRING;
                if (object == null) {
                    string = this.SPACE;
                } else {
                    JComponent jComponent;
                    TableCellRenderer tableCellRenderer;
                    if (i == 0 && cVTreeTableRow.getLevel() > 0) {
                        for (int j = 0; j < cVTreeTableRow.getLevel(); ++j) {
                            string = string + this.TAB_SPACE;
                        }
                    }
                    if ((tableCellRenderer = tableCellRendererArray[i]) == null) {
                        string = string + this.getHTMLCompatibleString(object.toString());
                    } else if (tableCellRenderer instanceof MultilineTableCellRenderer) {
                        string = string + this.getHTMLCompatibleString(object.toString());
                    } else if (tableCellRenderer instanceof ProgressBarTableCellRenderer) {
                        if (tableCellRenderer.getTableCellRendererComponent((JTable)treeTable, object, false, false, n2, i) instanceof JProgressBar) {
                            jComponent = (JProgressBar)tableCellRenderer.getTableCellRendererComponent((JTable)treeTable, object, false, false, n2, i);
                            string = string + Integer.toString(((JProgressBar)jComponent).getValue()) + " %";
                        } else if (object instanceof ProgressValue) {
                            string = string + object.toString();
                        }
                    } else if (object instanceof Boolean) {
                        string = string + ((Boolean)object == true ? ReportConverterUtilities.getLocalizedString(CteStringBank.Yes) : ReportConverterUtilities.getLocalizedString(CteStringBank.No));
                    } else if (object instanceof String) {
                        string = string + object.toString();
                    } else {
                        String string2;
                        jComponent = (JLabel)tableCellRenderer.getTableCellRendererComponent((JTable)treeTable, object, false, false, n2, i);
                        if (((JLabel)jComponent).getHorizontalAlignment() == 0) {
                            bl = true;
                        }
                        if ((string = string + ((JLabel)jComponent).getText()).indexOf("HTML") != -1 || string.indexOf("html") != -1) {
                            string = string + ReportConverterUtilities.removeHTMLTagsFromString(((JLabel)jComponent).getText());
                        }
                        string = this.getHTMLCompatibleString(string);
                        Icon icon = ((JLabel)jComponent).getIcon();
                        if (icon != null && this.encodeImage(icon, string2 = this.getImageName(icon))) {
                            string = string + MessageFormat.format(imageStr, string2);
                        }
                        if (string == null || string.trim().length() == 0) {
                            string = this.SPACE;
                        }
                    }
                }
                if (string.trim().length() == 0) {
                    string = this.SPACE;
                }
                if (bl) {
                    stringBuilder.append("<TD class='REPORT_CENTER'>");
                } else {
                    stringBuilder.append("<TD class='REPORT'>");
                }
                stringBuilder.append(string);
                stringBuilder.append("</TD>").append(LINE_SEPARATOR);
            }
            ++n2;
            stringBuilder.append("</TR>").append(LINE_SEPARATOR);
        }
        stringBuilder.append("</TABLE>").append(LINE_SEPARATOR);
        return stringBuilder.toString();
    }

    private String getLegendHTMLString(ReportLegend reportLegend) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("<TABLE cellspacing =10>").append(LINE_SEPARATOR);
        LegendItem legendItem = null;
        int n = 0;
        while (n < reportLegend.getNumberOfLegends()) {
            stringBuilder.append("<TR>").append(LINE_SEPARATOR);
            for (int i = 0; i < reportLegend.getNumberOfColumns() && n < reportLegend.getNumberOfLegends(); ++i, ++n) {
                legendItem = reportLegend.getLegendAt(n);
                stringBuilder.append("<TD BGCOLOR=" + legendItem.getColor().getHTMLColor() + ">&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;</TD>").append(LINE_SEPARATOR);
                stringBuilder.append(MessageFormat.format(cellNormal, legendItem.getLabel())).append(LINE_SEPARATOR);
            }
            stringBuilder.append("<TR>").append(LINE_SEPARATOR);
        }
        stringBuilder.append("</TABLE>").append(LINE_SEPARATOR);
        return stringBuilder.toString();
    }

    private String getDataTableHTMLString(Vector vector) {
        if (vector == null || vector.size() == 0) {
            return "";
        }
        int n = ((Vector)vector.elementAt(0)).size();
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("<TABLE>");
        for (int i = 0; i < vector.size(); ++i) {
            Vector vector2 = (Vector)vector.elementAt(i);
            stringBuilder.append("<TR>").append(LINE_SEPARATOR);
            for (int j = 0; j < n; ++j) {
                if (j % 2 == 0) {
                    stringBuilder.append(MessageFormat.format(cellNormal, vector2.elementAt(j).toString())).append(LINE_SEPARATOR);
                    continue;
                }
                stringBuilder.append(MessageFormat.format(cellNormal, vector2.elementAt(j).toString() + this.TAB_SPACE)).append(LINE_SEPARATOR);
            }
            stringBuilder.append("</TR>").append(LINE_SEPARATOR);
        }
        stringBuilder.append("</TABLE>").append(LINE_SEPARATOR);
        return stringBuilder.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void createPDFFile1(String string) throws Exception {
        Object object;
        Object object2;
        Object object3;
        Object object4;
        String string2 = this.getHTMLString();
        URL uRL = this.getClass().getClassLoader().getResource("styleSheets/BlueThemeStyle.css");
        System.out.println("StyleSheets URL: " + uRL);
        String string3 = "report.html";
        File file = new File(this.folder + "\\BlueThemeStyle.css");
        File file2 = new File(this.folder + "\\" + string3);
        System.out.println("destination folder: " + this.folder);
        try {
            int n;
            object4 = new BufferedInputStream(uRL.openStream());
            object3 = new BufferedOutputStream(new FileOutputStream(file));
            object2 = new byte[2048];
            while ((n = ((InputStream)object4).read((byte[])object2)) > 0) {
                ((OutputStream)object3).write((byte[])object2, 0, n);
            }
            ((OutputStream)object3).flush();
            ((OutputStream)object3).close();
            ((InputStream)object4).close();
            object = new FileOutputStream(file2);
            ((FileOutputStream)object).write(string2.getBytes());
            ((OutputStream)object).flush();
            ((FileOutputStream)object).close();
        }
        catch (Exception exception) {
            System.out.println("Unable to save file");
            exception.printStackTrace();
        }
        object4 = new ArrayList();
        object3 = this.getClass().getClassLoader().getResource("cv.jar");
        System.out.println("cv.jar path: " + ((URL)object3).getPath());
        object2 = new ProcessInfo();
        object = this.getClass().getClassLoader().getResource("export/wkhtmltopdf");
        String string4 = ((URL)object).getPath();
        if (string4.indexOf("/") == 0) {
            string4 = string4.replaceFirst("/", "");
        }
        ((ArrayList)object4).add(string4 + "/wkhtmltopdf.exe ");
        ((ArrayList)object4).add("--no-outline");
        ((ArrayList)object4).add("--orientation");
        ((ArrayList)object4).add("Portrait");
        ((ArrayList)object4).add("--page-size");
        ((ArrayList)object4).add("Letter");
        ((ArrayList)object4).add("--disable-javascript");
        ((ArrayList)object4).add("--cookie");
        ((ArrayList)object4).add("JSESSIONID");
        ((ArrayList)object4).add("999");
        ((ArrayList)object4).add("--load-error-handling");
        ((ArrayList)object4).add("skip");
        String string5 = "file:///" + file2.getAbsolutePath().replace("\\", "/");
        ((ArrayList)object4).add("file=" + string5);
        ((ArrayList)object4).add(string);
        Process process = Runtime.getRuntime().exec(((ArrayList)object4).toArray(new String[0]));
        try {
            ExportStreamGobbler exportStreamGobbler = new ExportStreamGobbler(process.getErrorStream(), true, "wkhtmltopdf");
            ExportStreamGobbler exportStreamGobbler2 = new ExportStreamGobbler(process.getInputStream(), false, "wkhtmltopdf");
            exportStreamGobbler.start();
            exportStreamGobbler2.start();
            int n = process.waitFor();
            if (n != 0) {
                throw new RuntimeException("Export returned with return code: " + n);
            }
            Logger.write(Logger.INFO, "ReportFormatter", "createPDFFile", "ExportToPdf.exe returned with return code: " + n);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        finally {
            try {
                if (process != null) {
                    process.destroy();
                }
            }
            catch (Exception exception) {}
        }
    }

    private void addToExportFile(String string, byte[] byArray, long l, ExportFileType exportFileType) {
        ExportFile exportFile = new ExportFile();
        exportFile.setFilename(string);
        exportFile.setFileType(exportFileType);
        exportFile.setOffset(0L);
        exportFile.setCheckSumSize(l);
        exportFile.setBinaryData(byArray);
        this.pdfExportFiles.add(exportFile);
    }

    public void createPDFFile(String string) throws Exception {
        Object object;
        Object object2;
        Object object3;
        Object object4;
        Logger.write(Logger.INFO, "ReportFormatter", "createPDFFile", "working folder: " + this.folder);
        String string2 = this.getHTMLString();
        URL uRL = this.getClass().getClassLoader().getResource("styleSheets/BlueThemeStyle.css");
        String string3 = "report.html";
        File file = new File(this.folder + "\\BlueThemeStyle.css");
        File file2 = new File(this.folder + "\\" + string3);
        try {
            int n;
            Logger.write(Logger.INFO, "ReportFormatter", "createPDFFile", "Saving CSS...");
            BufferedInputStream bufferedInputStream = new BufferedInputStream(uRL.openStream());
            FileOutputStream object5 = new FileOutputStream(file);
            object4 = new ByteArrayOutputStream();
            object3 = null;
            do {
                object3 = new byte[2048];
                n = ((InputStream)bufferedInputStream).read((byte[])object3);
                ((OutputStream)object4).write((byte[])object3);
                object5.write((byte[])object3);
            } while (n > 0);
            object2 = ((ByteArrayOutputStream)object4).toByteArray();
            ((OutputStream)object4).flush();
            ((ByteArrayOutputStream)object4).close();
            object5.flush();
            object5.close();
            ((InputStream)bufferedInputStream).close();
            this.addToExportFile("BlueThemeStyle.css", (byte[])object2, ((byte[])object2).length, ExportFileType.CSS);
            Logger.write(Logger.INFO, "ReportFormatter", "createPDFFile", "Saving CSS Completed.");
            Logger.write(Logger.INFO, "ReportFormatter", "createPDFFile", "Saving HTML...");
            object = new FileOutputStream(file2);
            ((FileOutputStream)object).write(string2.getBytes("UTF-8"));
            ((OutputStream)object).flush();
            ((FileOutputStream)object).close();
            this.addToExportFile(string3, string2.getBytes("UTF-8"), file2.length(), ExportFileType.HTML);
            Logger.write(Logger.INFO, "ReportFormatter", "createPDFFile", "Saving HTML Completed.");
        }
        catch (Exception exception) {
            Logger.write(Logger.ERROR, "ReportFormatter", "createPDFFile", "Unable to save CSS or HTML");
            Logger.write(Logger.ERROR, "ReportFormatter", "createPDFFile", exception);
            exception.printStackTrace();
        }
        try {
            for (String string4 : this.images) {
                int n;
                object4 = new File(this.folder + "\\" + string4);
                object3 = new BufferedInputStream(new FileInputStream((File)object4));
                object2 = new ByteArrayOutputStream();
                object = new byte[2048];
                do {
                    n = ((InputStream)object3).read((byte[])object);
                    ((OutputStream)object2).write((byte[])object);
                } while (n > 0);
                byte[] byArray = ((ByteArrayOutputStream)object2).toByteArray();
                this.addToExportFile(string4, byArray, byArray.length, ExportFileType.IMAGE);
            }
        }
        catch (Exception exception) {
            Logger.write(Logger.ERROR, "ReportFormatter", "createPDFFile", "unable to get Image bytes");
            Logger.write(Logger.ERROR, "ReportFormatter", "createPDFFile", exception);
            exception.printStackTrace();
        }
    }

    public List<ExportFile> getPDFpdfExportFiles() {
        return this.pdfExportFiles;
    }

    public static void main(String[] stringArray) {
        ReportFormatter reportFormatter = new ReportFormatter();
        reportFormatter.addHorizontalRule();
        reportFormatter.addBannerTitle("This is a title sss");
        reportFormatter.addText("this is normal text");
        reportFormatter.addBoldText("this is a bold text");
        reportFormatter.createHTMLFile("h:\\PDF\\test2.mhtml");
    }

    static BodyPart bodyPart(DataSource dataSource) throws MessagingException {
        MimeBodyPart mimeBodyPart = new MimeBodyPart();
        DataHandler dataHandler = new DataHandler(dataSource);
        mimeBodyPart.setDisposition("inline");
        mimeBodyPart.setDataHandler(dataHandler);
        mimeBodyPart.setFileName(dataHandler.getName());
        mimeBodyPart.addHeader("Content-Location", dataHandler.getName());
        return mimeBodyPart;
    }

    public void setLocaleSettings(String string, String string2) {
        Locale locale = null;
        locale = string2 != null && string2.length() > 0 ? new Locale(string, string2) : new Locale(string);
        if (!Arrays.asList(Locale.getAvailableLocales()).contains(locale)) {
            locale = Locale.getDefault();
        }
    }

    static class ExportStreamGobbler
    extends Thread {
        InputStream is;
        boolean isErrorStream;
        String name;
        String outputFile;

        ExportStreamGobbler(InputStream inputStream, boolean bl, String string, String string2) {
            this.is = inputStream;
            this.isErrorStream = bl;
            this.name = string;
            this.outputFile = string2;
        }

        ExportStreamGobbler(InputStream inputStream, boolean bl, String string) {
            this(inputStream, bl, string, null);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                InputStreamReader inputStreamReader = new InputStreamReader(this.is);
                BufferedReader bufferedReader = new BufferedReader(inputStreamReader);
                String string = null;
                boolean bl = false;
                while ((string = bufferedReader.readLine()) != null) {
                    if (this.isErrorStream) {
                        Logger.write(Logger.ERROR, "ReportFormatter", "ExportStreamGobbler", string);
                        continue;
                    }
                    if (string.equals("filebytes")) {
                        bl = true;
                        continue;
                    }
                    if (bl) {
                        byte[] byArray = Base64.decode((String)string);
                        FileOutputStream fileOutputStream = new FileOutputStream(this.outputFile);
                        fileOutputStream.write(byArray);
                        fileOutputStream.close();
                        bl = false;
                        continue;
                    }
                    Logger.write(Logger.INFO, "ReportFormatter", "ExportStreamGobbler", string);
                }
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
            finally {
                try {
                    if (this.is != null) {
                        this.is.close();
                    }
                }
                catch (Exception exception) {
                    Logger.write(Logger.ERROR, "ExportStreamGobbler", "", "Error while closing out/error streams of child process");
                    Logger.write(Logger.ERROR, "ExportStreamGobbler", "", exception);
                }
            }
        }
    }

    static final class StringSource
    implements DataSource {
        private final String contentType;
        private final String name;
        private final byte[] data;

        public StringSource(String string, String string2, String string3) {
            this.contentType = string;
            this.data = string3.getBytes();
            this.name = string2;
        }

        public String getContentType() {
            return this.contentType;
        }

        public OutputStream getOutputStream() throws IOException {
            throw new IOException();
        }

        public InputStream getInputStream() throws IOException {
            return new ByteArrayInputStream(this.data);
        }

        public String getName() {
            return this.name;
        }
    }
}

