/*
 * Decompiled with CFR 0.152.
 */
package commvault.cte.db;

import commvault.cte.db.CTEDBColumn;
import commvault.cte.db.CTEDBConnection;
import commvault.cte.db.CTEDBException;
import commvault.cte.db.CTEDBReservation;
import commvault.cte.db.CTEDBStorage;
import commvault.cte.db.CTEDBStorageType;
import java.sql.CallableStatement;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;

public abstract class CTEDBProcedure {
    protected List<CTEDBColumn> m_params = new ArrayList<CTEDBColumn>();
    protected final CTEDBConnection m_conn;

    public CTEDBProcedure(CTEDBConnection cTEDBConnection) {
        this.m_conn = cTEDBConnection;
    }

    public CTEDBConnection getConnection() {
        return this.m_conn;
    }

    public abstract String getName();

    public abstract CTEDBStorageType getType();

    protected List executeList(CTEDBStorage cTEDBStorage) {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected CTEDBStorage executeQuery(CTEDBStorage cTEDBStorage) throws CTEDBException {
        CTEDBReservation cTEDBReservation = this.m_conn.createReservation();
        PreparedStatement preparedStatement = null;
        ResultSet resultSet = null;
        try {
            String string = this.buildProcStatement();
            try {
                preparedStatement = cTEDBReservation.createStatement(string);
            }
            catch (CTEDBException cTEDBException) {
                throw new CTEDBException("error creating statement for procedure [" + this.getName() + "]", cTEDBException);
            }
            for (int i = 0; i < this.m_params.size(); ++i) {
                this.m_params.get(i).setParameter(preparedStatement, i + 1);
            }
            try {
                resultSet = preparedStatement.executeQuery();
            }
            catch (SQLException sQLException) {
                throw new CTEDBException("error executing procedure [" + this.getName() + "]", sQLException);
            }
            try {
                if (resultSet.next()) {
                    cTEDBStorage.initialize();
                    cTEDBStorage.populateIndex(resultSet);
                } else {
                    cTEDBStorage = null;
                }
            }
            catch (SQLException sQLException) {
                throw new CTEDBException("error reading resultset from procedure [" + this.getName() + "]", sQLException);
            }
        }
        finally {
            if (resultSet != null) {
                try {
                    resultSet.close();
                }
                catch (SQLException sQLException) {}
            }
            if (preparedStatement != null) {
                try {
                    preparedStatement.close();
                }
                catch (SQLException sQLException) {}
            }
            cTEDBReservation.close();
        }
        return cTEDBStorage;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute() throws CTEDBException {
        CTEDBReservation cTEDBReservation = this.m_conn.createReservation();
        Statement statement = null;
        try {
            String string = this.buildProcStatement();
            try {
                statement = cTEDBReservation.createStatement(string);
            }
            catch (CTEDBException cTEDBException) {
                throw new CTEDBException("error creating statement for procedure [" + this.getName() + "]", cTEDBException);
            }
            for (int i = 0; i < this.m_params.size(); ++i) {
                this.m_params.get(i).setParameter((PreparedStatement)statement, i + 1);
            }
            try {
                statement.execute();
            }
            catch (SQLException sQLException) {
                throw new CTEDBException("error executing procedure [" + this.getName() + "]", sQLException);
            }
        }
        finally {
            if (statement != null) {
                try {
                    statement.close();
                }
                catch (SQLException sQLException) {}
            }
            cTEDBReservation.close();
        }
    }

    public Integer returnInteger() throws CTEDBException {
        return (Integer)this.executeFunction(4);
    }

    protected Object executeFunction(int n) throws CTEDBException {
        CTEDBReservation cTEDBReservation = this.m_conn.createReservation();
        CallableStatement callableStatement = null;
        try {
            block24: {
                try {
                    callableStatement = cTEDBReservation.createCallableStatement(this.buildFunctionStatement());
                }
                catch (CTEDBException cTEDBException) {
                    throw new CTEDBException("error creating callable statement for procedure [" + this.getName() + "]", cTEDBException);
                }
                try {
                    callableStatement.registerOutParameter(1, n);
                }
                catch (SQLException sQLException) {
                    throw new CTEDBException("error registering out parameter in stored procedure [" + this.getName() + "] with sql type [" + n + "]", sQLException);
                }
                for (int i = 0; i < this.m_params.size(); ++i) {
                    this.m_params.get(i).setParameter(callableStatement, i + 1);
                }
                try {
                    callableStatement.execute();
                }
                catch (SQLException sQLException) {
                    throw new CTEDBException("error executing procedure [" + this.getName() + "]", sQLException);
                }
                try {
                    while (callableStatement.getMoreResults()) {
                    }
                }
                catch (SQLException sQLException) {
                    // empty catch block
                }
                try {
                    if (n != 4) break block24;
                    Integer n2 = callableStatement.getInt(1);
                    return n2;
                }
                catch (SQLException sQLException) {
                    throw new CTEDBException("error reading returned object from procedure [" + this.getName() + "], sql type [" + n + "]", sQLException);
                }
            }
            Object object = callableStatement.getObject(1);
            return object;
        }
        finally {
            if (callableStatement != null) {
                try {
                    callableStatement.close();
                }
                catch (SQLException sQLException) {}
            }
            cTEDBReservation.close();
        }
    }

    protected String buildProcStatement() {
        StringBuilder stringBuilder = new StringBuilder();
        if (this.m_params.size() > 0) {
            for (int i = 0; i < this.m_params.size(); ++i) {
                if (i > 0) {
                    stringBuilder.append(",");
                }
                stringBuilder.append("?");
            }
        }
        return String.format("{call %s(%s)}", this.getName(), stringBuilder.toString());
    }

    private String buildFunctionStatement() {
        StringBuilder stringBuilder = new StringBuilder();
        if (this.m_params.size() > 0) {
            for (int i = 0; i < this.m_params.size(); ++i) {
                if (i > 0) {
                    stringBuilder.append(",");
                }
                stringBuilder.append("?");
            }
        }
        return String.format("{? = call %s(%s)}", this.getName(), stringBuilder.toString());
    }

    protected void setParameters(PreparedStatement preparedStatement) throws CTEDBException {
        for (int i = 0; i < this.m_params.size(); ++i) {
            this.m_params.get(i).setParameter(preparedStatement, i + 1);
        }
    }

    protected void populateResult(ResultSet resultSet, CTEDBStorage cTEDBStorage) throws CTEDBException {
        try {
            if (resultSet.next()) {
                cTEDBStorage.initialize();
                cTEDBStorage.populateIndex(resultSet);
            } else {
                cTEDBStorage = null;
            }
        }
        catch (SQLException sQLException) {
            throw new CTEDBException("error reading resultset from procedure [" + this.getName() + "]", sQLException);
        }
    }
}

