/*
 * Decompiled with CFR 0.152.
 */
package commvault.cte.cvsession;

import commvault.cte.cvsession.CvConversionUtils;
import commvault.cte.cvsession.CvPasswordInterface;
import commvault.cte.cvsession.CvPasswordVersionInterface;
import java.io.UnsupportedEncodingException;
import java.math.BigInteger;
import java.security.InvalidKeyException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Calendar;
import java.util.Random;
import java.util.TimeZone;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.spec.SecretKeySpec;

final class CvPassword
implements CvPasswordInterface {
    private byte[] CVPWD_DEFAULT_ENC_KEY_V3_BYTES = null;
    private final int CVPWD_MAXPWD_SZ = 511;

    CvPassword() {
    }

    @Override
    public String encrypt(String string, CvPasswordVersionInterface.version version2) throws Exception {
        String string2;
        block12: {
            string2 = null;
            try {
                if (string == null) {
                    throw new NullPointerException(string);
                }
                if (version2 == CvPasswordVersionInterface.version.valueOf("VERSION_1")) {
                    throw new Exception("Version deprecated \n");
                }
                if (version2 == CvPasswordVersionInterface.version.valueOf("VERSION_2")) {
                    CvEncryptDecryptVersion2 cvEncryptDecryptVersion2 = new CvEncryptDecryptVersion2(string);
                    string2 = cvEncryptDecryptVersion2.encryptionVersion2();
                    cvEncryptDecryptVersion2 = null;
                    break block12;
                }
                if (version2 == CvPasswordVersionInterface.version.valueOf("VERSION_3")) {
                    CvEncryptDecryptVersion3 cvEncryptDecryptVersion3 = new CvEncryptDecryptVersion3(string);
                    string2 = cvEncryptDecryptVersion3.encryptionVersion3();
                    cvEncryptDecryptVersion3 = null;
                    break block12;
                }
                throw new IllegalArgumentException("version number not supported \n");
            }
            catch (Exception exception) {
                if (exception instanceof NoSuchAlgorithmException) {
                    throw new Exception("No such encryption algorithm exists\n");
                }
                if (exception instanceof InvalidKeyException) {
                    throw new Exception("The key supplied for encryption is invalid \n");
                }
                if (exception instanceof UnsupportedEncodingException) {
                    throw new Exception("The encoding key is not supported \n");
                }
                if (exception instanceof NoSuchPaddingException) {
                    throw new Exception("The padding scheme specified does not exist \n");
                }
                if (exception instanceof IllegalBlockSizeException) {
                    throw new Exception("The block size is not a multiple of 64-bits \n");
                }
                if (exception instanceof BadPaddingException) {
                    throw new Exception("The padding is incorrect \n");
                }
                throw exception;
            }
        }
        return string2;
    }

    @Override
    public String decrpyt(String string) throws Exception {
        String string2 = null;
        try {
            if (string == null) {
                throw new NullPointerException(string);
            }
            CvPasswordVersionInterface.version version2 = this.getVersion(string);
            if (version2 == null) {
                throw new Exception("Version number in encrypted password is incorrect \n");
            }
            if (version2 == CvPasswordVersionInterface.version.valueOf("VERSION_1")) {
                throw new Exception("Version not supported anymore \n");
            }
            if (version2 == CvPasswordVersionInterface.version.valueOf("VERSION_2")) {
                CvEncryptDecryptVersion2 cvEncryptDecryptVersion2 = new CvEncryptDecryptVersion2(string);
                string2 = cvEncryptDecryptVersion2.decryptionVersion2();
            } else if (version2 == CvPasswordVersionInterface.version.valueOf("VERSION_3")) {
                CvEncryptDecryptVersion3 cvEncryptDecryptVersion3 = new CvEncryptDecryptVersion3(string);
                string2 = cvEncryptDecryptVersion3.decryptionVersion3();
            }
        }
        catch (Exception exception) {
            if (exception instanceof NoSuchAlgorithmException) {
                throw new Exception("No such encryption algorithm exists\n");
            }
            if (exception instanceof InvalidKeyException) {
                throw new Exception("The key supplied for encryption is invalid \n");
            }
            if (exception instanceof UnsupportedEncodingException) {
                throw new Exception("The encoding key is not supported \n");
            }
            if (exception instanceof NoSuchPaddingException) {
                throw new Exception("The padding scheme specified does not exist \n");
            }
            if (exception instanceof IllegalBlockSizeException) {
                throw new Exception("The block size is not a multiple of 64-bits \n");
            }
            if (exception instanceof BadPaddingException) {
                throw new Exception("The padding is incorrect \n");
            }
            if (exception instanceof ArrayIndexOutOfBoundsException) {
                throw new Exception("Encrypted password is not encrypted by VERSION_2\n");
            }
            throw exception;
        }
        return string2;
    }

    private CvPasswordVersionInterface.version getVersion(String string) throws Exception {
        if (string.length() == 0) {
            throw new Exception("The encryptedPassword has a length equal to zero \n");
        }
        if (string.charAt(0) == '1') {
            return CvPasswordVersionInterface.version.VERSION_1;
        }
        if (string.charAt(0) == '2') {
            return CvPasswordVersionInterface.version.VERSION_2;
        }
        if (string.charAt(0) == '3') {
            return CvPasswordVersionInterface.version.VERSION_3;
        }
        return null;
    }

    static /* synthetic */ byte[] access$002(CvPassword cvPassword, byte[] byArray) {
        cvPassword.CVPWD_DEFAULT_ENC_KEY_V3_BYTES = byArray;
        return byArray;
    }

    private class CvEncryptDecryptVersion3 {
        private String plainTextOrEncryptedPassword;

        private CvEncryptDecryptVersion3(String string) {
            this.plainTextOrEncryptedPassword = string;
        }

        private String encryptionVersion3() throws NoSuchAlgorithmException, UnsupportedEncodingException, NoSuchPaddingException, InvalidKeyException, IllegalBlockSizeException, BadPaddingException {
            MessageDigest messageDigest = MessageDigest.getInstance("SHA-256");
            CvPassword.access$002(CvPassword.this, "{483afb5d-70df-4e16-abdc-a1de4d015a3e}".getBytes("UTF-8"));
            messageDigest.update(CvPassword.this.CVPWD_DEFAULT_ENC_KEY_V3_BYTES);
            byte[] byArray = messageDigest.digest();
            CvPassword.access$002(CvPassword.this, null);
            SecretKeySpec secretKeySpec = new SecretKeySpec(byArray, "AES");
            Cipher cipher = Cipher.getInstance("AES/ECB/NoPadding");
            cipher.init(1, secretKeySpec);
            byte[] byArray2 = this.plainTextOrEncryptedPassword.getBytes("UTF-8");
            this.plainTextOrEncryptedPassword = null;
            String string = this.cvWrapVersion3(cipher, byArray2);
            if (string == null) {
                return null;
            }
            return '3' + string;
        }

        private String cvWrapVersion3(Cipher cipher, byte[] byArray) throws IllegalBlockSizeException, BadPaddingException {
            int n;
            int n2;
            int n3;
            int n4 = cipher.getBlockSize();
            int n5 = n4 / 2;
            byte[] byArray2 = new byte[n5 * 2];
            byte[] byArray3 = new byte[(byArray.length / n5 + 2) * n5];
            for (n3 = 0; n3 < byArray.length; ++n3) {
                byArray3[n3 + n5] = byArray[n3];
            }
            n3 = byArray3.length - n5 - byArray.length;
            for (n2 = n5 + byArray.length; n2 < byArray3.length; ++n2) {
                byArray3[n2] = (byte)n3;
            }
            for (n2 = 0; n2 < n5; ++n2) {
                byArray2[n2] = -90;
            }
            n2 = byArray3.length / n5 - 1;
            int n6 = 1;
            for (n = 0; n < 6; ++n) {
                int n7 = n5;
                int n8 = 0;
                while (n8 < n2) {
                    int n9;
                    int n10;
                    int n11 = n7;
                    for (int i = n5; i < byArray2.length; ++i) {
                        byArray2[i] = byArray3[n11++];
                    }
                    byte[] byArray4 = cipher.doFinal(byArray2);
                    for (n10 = 0; n10 < n5; ++n10) {
                        byArray2[n10] = byArray4[n10];
                    }
                    n10 = n5 - 1;
                    for (n9 = n6; n9 > 0; n9 >>= 8) {
                        int n12 = n10--;
                        byArray2[n12] = (byte)(byArray2[n12] ^ n9 & 0xFF);
                    }
                    n11 = n7;
                    for (n9 = n5; n9 < byArray4.length; ++n9) {
                        byArray3[n11++] = byArray4[n9];
                    }
                    ++n8;
                    ++n6;
                    n7 += n5;
                }
            }
            for (n = 0; n < n5; ++n) {
                byArray3[n] = byArray2[n];
            }
            String string = CvConversionUtils.bytesToHexadecimalString(byArray3);
            return string;
        }

        private String decryptionVersion3() throws NoSuchAlgorithmException, UnsupportedEncodingException, NoSuchPaddingException, InvalidKeyException, IllegalBlockSizeException, BadPaddingException {
            MessageDigest messageDigest = MessageDigest.getInstance("SHA-256");
            CvPassword.access$002(CvPassword.this, "{483afb5d-70df-4e16-abdc-a1de4d015a3e}".getBytes("UTF-8"));
            messageDigest.update(CvPassword.this.CVPWD_DEFAULT_ENC_KEY_V3_BYTES);
            byte[] byArray = messageDigest.digest();
            CvPassword.access$002(CvPassword.this, null);
            SecretKeySpec secretKeySpec = new SecretKeySpec(byArray, "AES");
            Cipher cipher = Cipher.getInstance("AES/ECB/NoPadding");
            cipher.init(2, secretKeySpec);
            String string = this.cvUnWrap(cipher, CvConversionUtils.hexadecimalStringToByteArray(this.plainTextOrEncryptedPassword.substring(1)));
            if (string == null) {
                return null;
            }
            return CvConversionUtils.convertHexToString(string);
        }

        private String extractTextPasswordFromByteArray(byte[] byArray, int n) throws BadPaddingException {
            int n2 = byArray.length - 1;
            int n3 = n2;
            if (byArray[n3] == 0 || byArray[n3] > n) {
                throw new BadPaddingException("Failed to unwrap key data, padding check failed \n");
            }
            for (int i = 0; i < byArray[n3]; ++i) {
                if (byArray[n2--] == byArray[n3]) continue;
                throw new BadPaddingException("Failed to unwrap key data: padding check failed \n");
            }
            byte[] byArray2 = new byte[++n2 - n];
            for (int i = n; i < n2; ++i) {
                byArray2[i - n] = byArray[i];
            }
            return CvConversionUtils.bytesToHexadecimalString(byArray2);
        }

        private String cvUnWrap(Cipher cipher, byte[] byArray) throws IllegalBlockSizeException, BadPaddingException, InvalidKeyException, NoSuchAlgorithmException {
            int n;
            int n2 = cipher.getBlockSize();
            int n3 = n2 / 2;
            byte[] byArray2 = new byte[n3 * 2];
            byte[] byArray3 = byArray;
            int n4 = byArray3.length / n3 - 1;
            int n5 = 6 * n4;
            for (n = 0; n < n3; ++n) {
                byArray2[n] = byArray3[n];
            }
            for (n = 5; n >= 0; --n) {
                int n6 = byArray3.length - n3;
                int n7 = n4;
                while (n7 > 0) {
                    int n8;
                    int n9;
                    int n10 = n3 - 1;
                    for (n9 = n5; n9 > 0; n9 >>= 8) {
                        int n11 = n10--;
                        byArray2[n11] = (byte)(byArray2[n11] ^ n9 & 0xFF);
                    }
                    n9 = n6;
                    for (int i = n3; i < byArray2.length; ++i) {
                        byArray2[i] = byArray3[n9++];
                    }
                    byte[] byArray4 = new byte[byArray2.length];
                    for (int i = 0; i < byArray2.length; ++i) {
                        byArray4[i] = byArray2[i];
                    }
                    byte[] byArray5 = cipher.doFinal(byArray4);
                    for (n8 = 0; n8 < n3; ++n8) {
                        byArray2[n8] = byArray5[n8];
                    }
                    n9 = n6;
                    for (n8 = n3; n8 < byArray5.length; ++n8) {
                        byArray3[n9++] = byArray5[n8];
                    }
                    --n7;
                    --n5;
                    n6 -= n3;
                }
                n6 = byArray3.length - n3;
            }
            return this.extractTextPasswordFromByteArray(byArray3, n3);
        }
    }

    private class CvEncryptDecryptVersion2 {
        private final int CDR_NP = 0;
        private final int CDR_NL = 10;
        private final int CDR_NV = 0;
        private final int CDR_AP = 20;
        private final int CDR_AV = 10;
        private final int CDR_LAP = 30;
        private final int CDR_LAV = 20;
        private final int CDR_AL = 6;
        private final int CDR_DP = 40;
        private final int CDR_DL = 1;
        private final int CDR_CP = 41;
        private final int CDR_CL = 1;
        private final int CDR_SCP = 42;
        private final int CDR_SCL = 1;
        private final int CTAB_MAX = 61;
        private final int CDR_CMASK = 255;
        private final int CDR_KLEN = 2;
        private final int CDR_A = 65;
        private final char CDR_DASH = (char)45;
        private final char CDR_COLON = (char)58;
        private final char CDR_SCOLON = (char)59;
        private String plainTextOrEncryptedPassword;
        private char[] buf = new char[512];
        private char[] encryptedPassword = null;
        private int rc = 0;
        private char[] hexRepresentationOfPwd = new char[512];
        private final long[] ctab = new long[]{1361763137L, 1089673317L, 1615938408L, -1403196601L, -997353930L, 260898671L, 526265154L, 1271040337L, 642318668L, 1805866097L, -1880240328L, -997606571L, -1961319346L, 460414038L, 1328201048L, -1301411017L, 1313629015L, 2121906275L, -607710358L, 1405220953L, -1190967221L, -1298133906L, -1325053598L, 1513838182L, -155453324L, 71401268L, -1601519755L, 94976073L, 1854626376L, 944806706L, 2104975683L, -1969159631L, -608068039L, -340347536L, 98191460L, 1962148429L, 1790230352L, 284682105L, -2067664828L, 1621801075L, 1142207083L, -373179088L, 149117816L, 1805631027L, 1564692789L, 1315283575L, -1402125962L, 903217266L, 165922668L, 1470736722L, -473731259L, 1459954535L, 317676922L, 1399602529L, -2010906771L, -676153495L, 1686808148L, 1670559306L, 842075974L, 1750637395L, -1175707046L};
        private Random random = null;

        private CvEncryptDecryptVersion2(String string) {
            this.plainTextOrEncryptedPassword = string;
        }

        private String encryptionVersion2() throws UnsupportedEncodingException {
            if (this.plainTextOrEncryptedPassword == null) {
                throw new NullPointerException(this.plainTextOrEncryptedPassword);
            }
            if (this.plainTextOrEncryptedPassword.length() == 0) {
                return "2";
            }
            Seed seed = this.getSeedParameters(this.plainTextOrEncryptedPassword);
            String string = new String(this.hexRepresentationOfPwd);
            string = string.substring(0, seed.getHexRepIterator());
            this.encryptedPassword = new char[512];
            this.hexRepresentationOfPwd = string.toCharArray();
            Calendar calendar = Calendar.getInstance(TimeZone.getTimeZone("UTC"));
            long l = calendar.getTimeInMillis() * 1000L;
            this.CDR_RSEED(l, l % (long)seed.getpTotal() * (l % (long)seed.gethTotal()) * (long)(seed.gethTotal() % seed.getpTotal()));
            this.rc = this.CDR_ENCODER(false);
            this.encryptedPassword[0] = 50;
            if (this.rc == 0) {
                return new String(this.encryptedPassword).trim();
            }
            return null;
        }

        private long CDR_RNUM(long l) {
            return l <= 0L ? 0L : (long)((double)l * (this.random.nextDouble() / 32768.0));
        }

        private void CDR_RSEED(long l, long l2) {
            this.random = new Random(l + l2);
            this.random.setSeed(this.ctab[(int)(this.CDR_RNUM(61L) / (this.CDR_RNUM(16L) + 1L))]);
        }

        private Seed getSeedParameters(String string) throws UnsupportedEncodingException {
            if (string == null) {
                return null;
            }
            byte[] byArray = string.getBytes("UTF-8");
            int n = 0;
            int n2 = 0;
            int n3 = 0;
            int n4 = 0;
            for (int i = 0; i < byArray.length; ++i) {
                String string2 = String.format("%02X", string.charAt(n4));
                char[] cArray = string2.toCharArray();
                for (int j = 0; j < cArray.length; ++j) {
                    this.hexRepresentationOfPwd[n3 + j] = cArray[j];
                }
                n += (char)byArray[i];
                n2 += this.hexRepresentationOfPwd[n3] + this.hexRepresentationOfPwd[n3 + 1];
                ++n4;
                n3 += 2;
            }
            return new Seed(n, n2, n3);
        }

        private String decryptionVersion2() {
            this.rc = this.CDR_DECODER(this.plainTextOrEncryptedPassword.substring(1));
            if (this.rc == 0) {
                return CvConversionUtils.convertHexToString(new String(this.buf).replace("00", "").trim());
            }
            return null;
        }

        private int CDR_ENCODER(boolean bl) {
            char[] cArray = new char[3];
            int n = 0;
            int n2 = (int)this.CDR_RNUM(61L);
            String string = String.format("%02X", n2);
            char[] cArray2 = string.toCharArray();
            for (int i = 0; i < cArray2.length; ++i) {
                cArray[i] = cArray2[i];
            }
            int n3 = 0;
            int n4 = 1;
            n = this.CDR_GETP(0, cArray[n3], n);
            this.encryptedPassword[n4++] = (char)(this.ctab[n] & 0xFFL);
            n = this.CDR_GETP(0, cArray[++n3], n);
            this.encryptedPassword[n4++] = (char)(this.ctab[n] & 0xFFL);
            int n5 = 2;
            for (n3 = 0; n3 < this.hexRepresentationOfPwd.length; ++n3) {
                n = this.CDR_GETP(n2, this.hexRepresentationOfPwd[n3], n);
                this.encryptedPassword[n4++] = (char)(this.ctab[n] & 0xFFL);
                if (bl && n5 % 8 == 0) {
                    this.encryptedPassword[n4++] = 45;
                }
                ++n5;
            }
            if (this.encryptedPassword[n4 - 1] == '-') {
                --n4;
            }
            this.rc = this.rc == 0 ? 0 : this.rc;
            return this.rc;
        }

        private int CDR_GETP(int n, int n2, int n3) {
            int n4 = this.CDR_RAND_UCASE(n2);
            if (this.rc == 0) {
                if (n2 >= 48 && n2 <= 57) {
                    n3 = this.CDR_GETI(n + (n2 - 48));
                } else if (n4 >= 65 && n4 <= 70) {
                    n3 = this.CDR_GETI(n + (n4 - 65) + 20);
                } else if (n4 >= 97 && n4 <= 102) {
                    n3 = this.CDR_GETI(n + (n4 - 97 + 30));
                } else if (n2 == 45) {
                    n3 = this.CDR_GETI(n + 40);
                } else if (n2 == 58) {
                    n3 = this.CDR_GETI(n + 41);
                } else if (n2 == 59) {
                    n3 = this.CDR_GETI(n + 42);
                } else {
                    this.rc = this.rc == 0 ? 1 : this.rc;
                }
            }
            return n3;
        }

        private int CDR_GETI(int n) {
            return n >= 61 ? n - 61 : n;
        }

        private int CDR_RAND_UCASE(int n) {
            return n >= 65 && n <= 70 ? (this.CDR_RNUM(100L) % 2L == 0L ? n : n + 32) : n;
        }

        private int CDR_DECODER(String string) {
            int n;
            for (n = 0; n < this.buf.length; ++n) {
                this.buf[n] = '\u0000';
            }
            if (string.equals("")) {
                this.buf[0] = 50;
                return this.rc;
            }
            n = 0;
            int n2 = 0;
            long l = 0L;
            this.CDR_SEARCH(0L, string.charAt(n), n2);
            this.CDR_SEARCH(0L, string.charAt(++n), ++n2);
            ++n;
            String string2 = "";
            int n3 = 0;
            while (this.buf[n3] != '\u0000') {
                string2 = string2 + this.buf[n3];
                ++n3;
            }
            l = new BigInteger(string2, 16).longValue();
            n2 = 0;
            while (n < string.length()) {
                if (string.charAt(n) != '-') {
                    this.CDR_SEARCH(l, string.charAt(n), n2);
                    ++n2;
                }
                ++n;
            }
            this.rc = this.rc == 0 ? 0 : this.rc;
            return this.rc;
        }

        private void CDR_SEARCH(long l, int n, int n2) {
            int n3 = 0;
            if (this.rc == 0 && (n3 = this.CDR_FINDC(n3, l, 0, 10, n, n2)) == 0 && (n3 = this.CDR_FINDC(n3, l, 20, 6, n, n2)) == 0 && (n3 = this.CDR_FINDC(n3, l, 30, 6, n, n2)) == 0 && (n3 = this.CDR_FINDC(n3, l, 40, 1, n, n2)) == 0 && (n3 = this.CDR_FINDC(n3, l, 41, 1, n, n2)) == 0 && (n3 = this.CDR_FINDC(n3, l, 42, 1, n, n2)) == 0) {
                this.rc = this.rc == 0 ? 1 : this.rc;
            }
        }

        private int CDR_FINDC(int n, long l, int n2, int n3, int n4, int n5) throws ArrayIndexOutOfBoundsException {
            long l2 = l + (long)n2;
            long l3 = l2 + (long)n3;
            long l4 = 0L;
            long l5 = 0L;
            if (this.rc == 0) {
                for (long i = l2; i < l3 && this.rc == 0; ++i) {
                    long l6 = l4 = i >= 61L ? i - 61L : i;
                    if ((long)n4 != (0xFFL & this.ctab[(int)l4])) continue;
                    ++n;
                    if (n2 == 0) {
                        l5 = 0L;
                    } else if (n2 == 20) {
                        l5 = 10L;
                    } else if (n2 == 30) {
                        l5 = 20L;
                    } else {
                        if (n2 == 40) {
                            this.buf[n5] = 45;
                            this.buf[n5 + 1] = '\u0000';
                            i = l3;
                            continue;
                        }
                        if (n2 == 41) {
                            this.buf[n5] = 58;
                            this.buf[n5 + 1] = '\u0000';
                            i = l3;
                            continue;
                        }
                        if (n2 == 42) {
                            this.buf[n5] = 59;
                            this.buf[n5 + 1] = '\u0000';
                            i = l3;
                            continue;
                        }
                        this.rc = this.rc == 0 ? 1 : this.rc;
                    }
                    String string = String.format("%01X", l4 - l - l5 < 0L ? i - l - l5 : l4 - l - l5);
                    char[] cArray = string.toCharArray();
                    for (int j = 0; j < cArray.length; ++j) {
                        this.buf[n5 + j] = cArray[j];
                    }
                    break;
                }
            }
            return n;
        }

        private class Seed {
            private int pTotal = 0;
            private int hTotal = 0;
            private int hexRepIterator = 0;

            public Seed(int n, int n2, int n3) {
                this.pTotal = n;
                this.hTotal = n2;
                this.hexRepIterator = n3;
            }

            int getHexRepIterator() {
                return this.hexRepIterator;
            }

            int getpTotal() {
                return this.pTotal;
            }

            int gethTotal() {
                return this.hTotal;
            }
        }
    }
}

