/*
 * Decompiled with CFR 0.152.
 */
package commvault.cte.component.tooolbar;

import commvault.cte.component.tooolbar.CustomizedToolbar;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.Window;
import java.awt.geom.GeneralPath;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.JComponent;
import javax.swing.RootPaneContainer;
import javax.swing.SwingUtilities;

class SpaceComponent
extends JComponent {
    private static final long serialVersionUID = 1L;
    public static final int SPACE_COMPONENT_WIDTH = 32;
    CustomizedToolbar toolbar;
    boolean showBorder = false;
    boolean paintArrows = false;
    PropertyChangeListener propertyListener = new PropertyChangeListener(){

        @Override
        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            SpaceComponent.this.updateBorder();
        }
    };

    public SpaceComponent(CustomizedToolbar customizedToolbar, boolean bl) {
        this.toolbar = customizedToolbar;
        this.setPreferredSize(new Dimension(32, this.toolbar.minimumHeight));
        this.setSize(this.getPreferredSize());
        this.updateBorder();
        customizedToolbar.addPropertyChangeListener("customizeDialogActive", this.propertyListener);
        this.paintArrows = bl;
    }

    private void updateBorder() {
        Boolean bl = (Boolean)this.toolbar.getClientProperty("customizeDialogActive");
        if (bl == null) {
            bl = Boolean.FALSE;
        }
        this.showBorder = bl;
        this.repaint();
    }

    @Override
    protected void paintComponent(Graphics graphics) {
        super.paintComponent(graphics);
        if (this.showBorder) {
            boolean bl;
            Boolean bl2;
            boolean bl3 = false;
            Window window = SwingUtilities.getWindowAncestor(this);
            if (window instanceof RootPaneContainer && (bl2 = (Boolean)((RootPaneContainer)((Object)window)).getRootPane().getClientProperty("apple.awt.brushMetalLook")) != null && bl2.booleanValue()) {
                bl3 = true;
            }
            boolean bl4 = (bl = this.contains((Container)((Object)this.toolbar), this)) && bl3;
            SpaceComponent.paintSpace(graphics, bl4, this.paintArrows, this.getWidth(), this.getHeight());
        }
    }

    protected static void paintSpace(Graphics graphics, boolean bl, boolean bl2, int n, int n2) {
        Graphics2D graphics2D = (Graphics2D)graphics;
        if (bl) {
            graphics2D.setColor(new Color(255, 255, 255, 80));
        } else {
            graphics2D.setColor(new Color(0, 0, 0, 80));
        }
        graphics2D.setStroke(new BasicStroke(1.0f));
        graphics2D.drawRect(0, 0, n - 1, n2 - 1);
        GeneralPath generalPath = new GeneralPath();
        if (bl2) {
            graphics2D.setColor(new Color(0, 0, 0, 180));
            graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            generalPath.reset();
            generalPath.moveTo(0.0f, (float)(n2 / 2) + 0.5f);
            generalPath.lineTo(6.0f, n2 / 2 - 2);
            generalPath.lineTo(6.0f, n2 / 2 + 3);
            generalPath.lineTo(0.0f, (float)(n2 / 2) + 0.5f);
            graphics2D.fill(generalPath);
            generalPath.reset();
            generalPath.moveTo(n - 1, (float)(n2 / 2) + 0.5f);
            generalPath.lineTo(n - 7, n2 / 2 - 2);
            generalPath.lineTo(n - 7, n2 / 2 + 3);
            generalPath.lineTo(n - 1, (float)(n2 / 2) + 0.5f);
            graphics2D.fill(generalPath);
            graphics2D.setStroke(new BasicStroke(1.0f, 0, 2, 10.0f, new float[]{1.0f, 2.0f}, 0.0f));
            generalPath.reset();
            generalPath.moveTo(7.0f, n2 / 2);
            generalPath.lineTo(n - 8, n2 / 2);
            graphics2D.draw(generalPath);
            graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
        }
    }

    private boolean contains(Container container, Component component) {
        for (int i = 0; i < container.getComponentCount(); ++i) {
            Component component2 = container.getComponent(i);
            if (component2 == component) {
                return true;
            }
            if (!(component2 instanceof Container) || !this.contains((Container)component2, component)) continue;
            return true;
        }
        return false;
    }
}

