/*
 * Decompiled with CFR 0.152.
 */
package commvault.cte.component.tooolbar;

import commvault.cte.component.tooolbar.CustomizedToolbar;
import commvault.cte.component.tooolbar.MacToolbarSeparatorUI;
import commvault.cte.component.tooolbar.MockComponent;
import commvault.cte.component.tooolbar.SpaceComponent;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.image.BufferedImage;
import javax.swing.JComponent;
import javax.swing.JSeparator;

class MockDefaultToolbar
extends MockComponent {
    private static final long serialVersionUID = 1L;

    public MockDefaultToolbar(CustomizedToolbar customizedToolbar) {
        super(MockDefaultToolbar.createImage(customizedToolbar));
    }

    private static BufferedImage createImage(CustomizedToolbar customizedToolbar) {
        String[] stringArray = customizedToolbar.getDefaultContents();
        Insets insets = customizedToolbar.getComponentInsets();
        Dimension[] dimensionArray = new Dimension[stringArray.length];
        JComponent[] jComponentArray = new JComponent[stringArray.length];
        int n = 0;
        for (int i = 0; i < stringArray.length; ++i) {
            n += insets.left + insets.right;
            jComponentArray[i] = customizedToolbar.getComponent(stringArray[i]);
            dimensionArray[i] = jComponentArray[i].getPreferredSize();
            if (jComponentArray[i] instanceof JSeparator) {
                dimensionArray[i].height = customizedToolbar.minimumHeight;
            }
            if (stringArray[i].length() > 0 && stringArray[i].charAt(0) == '\t') {
                dimensionArray[i].width = 32;
            }
            n += dimensionArray[i].width;
        }
        BufferedImage bufferedImage = new BufferedImage(n, customizedToolbar.minimumHeight + insets.top + insets.bottom, 2);
        Graphics2D graphics2D = bufferedImage.createGraphics();
        graphics2D.setColor(new Color(0, 0, 0, 80));
        graphics2D.drawRect(0, 0, bufferedImage.getWidth() - 1, bufferedImage.getHeight() - 1);
        graphics2D.translate(0, insets.top);
        for (int i = 0; i < stringArray.length; ++i) {
            graphics2D.translate(insets.left, 0);
            int n2 = customizedToolbar.minimumHeight / 2 - dimensionArray[i].height / 2;
            graphics2D.translate(0, n2);
            if (stringArray[i].length() > 0 && stringArray[i].charAt(0) == '\t') {
                SpaceComponent.paintSpace(graphics2D, false, true, dimensionArray[i].width, dimensionArray[i].height);
            } else if (stringArray[i].length() > 0 && stringArray[i].charAt(0) == '-') {
                MacToolbarSeparatorUI.paintSeparator(graphics2D, dimensionArray[i].width, dimensionArray[i].height);
            } else {
                jComponentArray[i].paint(graphics2D);
            }
            graphics2D.translate(dimensionArray[i].width, 0);
            graphics2D.translate(insets.right, 0);
            graphics2D.translate(0, -n2);
        }
        graphics2D.dispose();
        return bufferedImage;
    }
}

