/*
 * Decompiled with CFR 0.152.
 */
package commvault.cte.component.tooolbar;

import java.awt.AlphaComposite;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import javax.swing.AbstractButton;
import javax.swing.JComponent;

public class MockComponent
extends JComponent {
    BufferedImage image;
    private static String WAS_SELECTED = "MockComponent.wasSelected";
    private static String WAS_FOCUS_PAINTED = "MockComponent.wasFocusPainted";
    private static String WAS_ENABLED = "MockComponent.wasEnabled";
    private static String WAS_VISIBLE = "MockComponent.wasVisible";

    public MockComponent(BufferedImage bufferedImage) {
        this.image = bufferedImage;
        Dimension dimension = new Dimension(bufferedImage.getWidth(), bufferedImage.getHeight());
        this.setSize(dimension);
        this.setPreferredSize(dimension);
    }

    public MockComponent(JComponent jComponent) {
        Dimension dimension = jComponent.getPreferredSize();
        Dimension dimension2 = jComponent.getSize();
        Dimension dimension3 = new Dimension(Math.max(dimension.width, dimension2.width), Math.max(dimension.height, dimension2.height));
        if (dimension2.width == 0 || dimension2.height == 0) {
            jComponent.setSize(dimension3);
            jComponent.doLayout();
        }
        this.storeState(jComponent);
        this.image = new BufferedImage(dimension3.width, dimension3.height, 2);
        Graphics2D graphics2D = this.image.createGraphics();
        graphics2D.setComposite(AlphaComposite.Clear);
        graphics2D.fillRect(0, 0, dimension3.width, dimension3.height);
        graphics2D.setComposite(AlphaComposite.SrcOver);
        jComponent.paint(graphics2D);
        graphics2D.dispose();
        this.setPreferredSize(dimension3);
        this.setMinimumSize(dimension3);
        this.setMaximumSize(dimension3);
        this.setOpaque(jComponent.isOpaque());
        this.setName(jComponent.getName());
        this.setToolTipText(jComponent.getToolTipText());
        this.restoreState(jComponent);
    }

    public BufferedImage getBufferedImage() {
        return this.image;
    }

    private void storeState(JComponent jComponent) {
        if (jComponent instanceof AbstractButton) {
            AbstractButton abstractButton = (AbstractButton)jComponent;
            abstractButton.putClientProperty(WAS_SELECTED, new Boolean(abstractButton.isSelected()));
            abstractButton.putClientProperty(WAS_FOCUS_PAINTED, new Boolean(abstractButton.isSelected()));
            abstractButton.setSelected(false);
            abstractButton.setFocusPainted(false);
        }
        if (!jComponent.isEnabled()) {
            jComponent.putClientProperty(WAS_ENABLED, new Boolean(jComponent.isEnabled()));
            jComponent.setEnabled(true);
        }
        if (!jComponent.isVisible()) {
            jComponent.putClientProperty(WAS_VISIBLE, new Boolean(jComponent.isVisible()));
            jComponent.setVisible(true);
        }
        for (int i = 0; i < jComponent.getComponentCount(); ++i) {
            if (!(jComponent.getComponent(i) instanceof JComponent)) continue;
            this.storeState((JComponent)jComponent.getComponent(i));
        }
    }

    private void restoreState(JComponent jComponent) {
        if (jComponent instanceof AbstractButton) {
            AbstractButton abstractButton = (AbstractButton)jComponent;
            if (abstractButton.getClientProperty(WAS_SELECTED) != null) {
                abstractButton.setSelected((Boolean)abstractButton.getClientProperty(WAS_SELECTED));
                abstractButton.putClientProperty(WAS_SELECTED, null);
            }
            if (abstractButton.getClientProperty(WAS_FOCUS_PAINTED) != null) {
                abstractButton.setFocusPainted((Boolean)abstractButton.getClientProperty(WAS_FOCUS_PAINTED));
                abstractButton.putClientProperty(WAS_FOCUS_PAINTED, null);
            }
        }
        if (jComponent.getClientProperty(WAS_ENABLED) != null) {
            jComponent.setEnabled((Boolean)jComponent.getClientProperty(WAS_ENABLED));
            jComponent.putClientProperty(WAS_ENABLED, null);
        }
        if (jComponent.getClientProperty(WAS_VISIBLE) != null) {
            jComponent.setVisible((Boolean)jComponent.getClientProperty(WAS_VISIBLE));
            jComponent.putClientProperty(WAS_VISIBLE, null);
        }
        for (int i = 0; i < jComponent.getComponentCount(); ++i) {
            if (!(jComponent.getComponent(i) instanceof JComponent)) continue;
            this.restoreState((JComponent)jComponent.getComponent(i));
        }
    }

    @Override
    protected void paintComponent(Graphics graphics) {
        graphics.drawImage(this.image, this.getWidth() / 2 - this.image.getWidth() / 2, this.getHeight() / 2 - this.image.getHeight() / 2, null);
    }
}

