/*
 * Decompiled with CFR 0.152.
 */
package commvault.cte.component.table;

import commvault.cte.common.PDFInfo;
import commvault.cte.component.Utilities;
import commvault.cte.component.table.ContentExtractor;
import commvault.cte.component.table.NTable;
import java.awt.Component;
import javax.swing.JTable;

public class DefaultContentExtractor
implements ContentExtractor {
    public static final char DELIMITER = ',';
    private static DefaultContentExtractor defaultContentExtractor;
    private String fileName;

    public static synchronized DefaultContentExtractor getInstance() {
        if (defaultContentExtractor == null) {
            defaultContentExtractor = new DefaultContentExtractor();
        }
        return defaultContentExtractor;
    }

    @Override
    public String getContent(Component component) {
        if (component instanceof JTable) {
            return Utilities.buildCSVDataFromTableModel(((JTable)component).getModel(), ',');
        }
        if (component instanceof NTable) {
            return Utilities.buildCSVDataFromTableModel(((NTable)component).getModel(), ',');
        }
        return null;
    }

    @Override
    public PDFInfo getPdfInfo(Component component) {
        return null;
    }

    @Override
    public Component getPrintableComponent(Component component) {
        if (component instanceof NTable) {
            return ((NTable)component).getActualTable();
        }
        return null;
    }

    @Override
    public String getFileName() {
        if (this.fileName == null) {
            return "data";
        }
        return this.fileName;
    }

    public void setFileName(String string) {
        this.fileName = string;
    }
}

