/*
 * Decompiled with CFR 0.152.
 */
package commvault.cte.component.ribbon.api.ribbon;

import commvault.cte.component.ribbon.api.common.AbstractCommandButton;
import commvault.cte.component.ribbon.api.common.CommandButtonDisplayState;
import commvault.cte.component.ribbon.api.common.RichTooltip;
import commvault.cte.component.ribbon.api.common.icon.ResizableIcon;
import commvault.cte.component.ribbon.api.ribbon.AbstractRibbonBand;
import commvault.cte.component.ribbon.api.ribbon.RibbonApplicationMenu;
import commvault.cte.component.ribbon.api.ribbon.RibbonContextualTaskGroup;
import commvault.cte.component.ribbon.api.ribbon.RibbonTask;
import commvault.cte.component.ribbon.internal.ui.ribbon.BasicRibbonUI;
import commvault.cte.component.ribbon.internal.ui.ribbon.RibbonUI;
import commvault.cte.util.Application;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class JRibbon
extends JComponent {
    private ArrayList<RibbonTask> tasks;
    private ArrayList<RibbonContextualTaskGroup> contextualTaskGroups;
    private ArrayList<Component> taskbarComponents;
    private ArrayList<AbstractRibbonBand> bands;
    private RibbonTask currentlySelectedTask;
    private ResizableIcon helpIcon;
    private ActionListener helpActionListener;
    private ActionListener minimizeActionListener;
    private Map<RibbonContextualTaskGroup, Boolean> groupVisibilityMap;
    private RibbonApplicationMenu applicationMenu;
    private RichTooltip applicationMenuRichTooltip;
    private String applicationMenuKeyTip;
    private boolean isMinimized;
    private JFrame ribbonFrame;
    public static final String uiClassID = "RibbonUI";
    private ImageIcon icon;
    private static final int IMAGE_WIDTH = 200;
    private Color imageColor;

    public JRibbon() {
        try {
            this.icon = Application.instance().getIconSource().getIcon("quinetixGuiBarIconPNG");
        }
        catch (Exception exception) {
            this.icon = null;
        }
        this.imageColor = Color.black;
        this.tasks = new ArrayList();
        this.contextualTaskGroups = new ArrayList();
        this.taskbarComponents = new ArrayList();
        this.bands = new ArrayList();
        this.currentlySelectedTask = null;
        this.groupVisibilityMap = new HashMap<RibbonContextualTaskGroup, Boolean>();
        this.updateUI();
    }

    public JRibbon(JFrame jFrame) {
        this();
        this.ribbonFrame = jFrame;
    }

    public synchronized void addTaskbarComponent(Component component) {
        if (component instanceof AbstractCommandButton) {
            AbstractCommandButton abstractCommandButton = (AbstractCommandButton)component;
            abstractCommandButton.setDisplayState(CommandButtonDisplayState.SMALL);
            abstractCommandButton.setGapScaleFactor(0.5);
            abstractCommandButton.setFocusable(false);
        }
        this.taskbarComponents.add(component);
        this.fireStateChanged();
    }

    public synchronized void removeTaskbarComponent(Component component) {
        this.taskbarComponents.remove(component);
        this.fireStateChanged();
    }

    public synchronized void addTask(RibbonTask ribbonTask) {
        ribbonTask.setRibbon(this);
        this.tasks.add(ribbonTask);
        if (this.tasks.size() == 1) {
            this.setSelectedTask(ribbonTask);
        }
        this.fireStateChanged();
    }

    public synchronized void configureHelp(ResizableIcon resizableIcon, ActionListener actionListener) {
        this.helpIcon = resizableIcon;
        this.helpActionListener = actionListener;
        this.fireStateChanged();
    }

    public synchronized void addMinimizeListener(ActionListener actionListener) {
        this.minimizeActionListener = actionListener;
        this.fireStateChanged();
    }

    public ResizableIcon getHelpIcon() {
        return this.helpIcon;
    }

    public ActionListener getHelpActionListener() {
        return this.helpActionListener;
    }

    public ActionListener getMinimizeActionListener() {
        return this.minimizeActionListener;
    }

    public synchronized void addContextualTaskGroup(RibbonContextualTaskGroup ribbonContextualTaskGroup) {
        ribbonContextualTaskGroup.setRibbon(this);
        this.contextualTaskGroups.add(ribbonContextualTaskGroup);
        this.groupVisibilityMap.put(ribbonContextualTaskGroup, false);
        this.fireStateChanged();
    }

    public synchronized int getTaskCount() {
        return this.tasks.size();
    }

    public synchronized RibbonTask getTask(int n) {
        return this.tasks.get(n);
    }

    public synchronized int getContextualTaskGroupCount() {
        return this.contextualTaskGroups.size();
    }

    public synchronized RibbonContextualTaskGroup getContextualTaskGroup(int n) {
        return this.contextualTaskGroups.get(n);
    }

    public synchronized void setSelectedTask(RibbonTask ribbonTask) {
        boolean bl = this.tasks.contains(ribbonTask);
        if (!bl) {
            for (int i = 0; i < this.getContextualTaskGroupCount(); ++i) {
                RibbonContextualTaskGroup object2 = this.getContextualTaskGroup(i);
                if (!this.isVisible(object2)) continue;
                for (int j = 0; j < object2.getTaskCount(); ++j) {
                    if (object2.getTask(j) != ribbonTask) continue;
                    bl = true;
                    break;
                }
                if (bl) break;
            }
        }
        if (!bl) {
            throw new IllegalArgumentException("The specified task to be selected is either not part of this ribbon or not marked as visible");
        }
        for (AbstractRibbonBand abstractRibbonBand : this.bands) {
            abstractRibbonBand.setVisible(false);
        }
        this.bands.clear();
        for (int i = 0; i < ribbonTask.getBandCount(); ++i) {
            AbstractRibbonBand<?> abstractRibbonBand = ribbonTask.getBand(i);
            abstractRibbonBand.setVisible(true);
            this.bands.add(abstractRibbonBand);
        }
        RibbonTask ribbonTask2 = this.currentlySelectedTask;
        this.currentlySelectedTask = ribbonTask;
        this.revalidate();
        this.repaint();
        this.firePropertyChange("selectedTask", ribbonTask2, this.currentlySelectedTask);
    }

    public synchronized RibbonTask getSelectedTask() {
        return this.currentlySelectedTask;
    }

    @Override
    public void updateUI() {
        if (UIManager.get(this.getUIClassID()) != null) {
            this.setUI(UIManager.getUI(this));
        } else {
            this.setUI(new BasicRibbonUI());
        }
        for (Component component : this.taskbarComponents) {
            SwingUtilities.updateComponentTreeUI(component);
        }
    }

    @Override
    public RibbonUI getUI() {
        return (RibbonUI)this.ui;
    }

    @Override
    public String getUIClassID() {
        return uiClassID;
    }

    public synchronized List<Component> getTaskbarComponents() {
        return Collections.unmodifiableList(this.taskbarComponents);
    }

    public void addChangeListener(ChangeListener changeListener) {
        this.listenerList.add(ChangeListener.class, changeListener);
    }

    public void removeChangeListener(ChangeListener changeListener) {
        this.listenerList.remove(ChangeListener.class, changeListener);
    }

    protected void fireStateChanged() {
        Object[] objectArray = this.listenerList.getListenerList();
        ChangeEvent changeEvent = new ChangeEvent(this);
        for (int i = objectArray.length - 2; i >= 0; i -= 2) {
            if (objectArray[i] != ChangeListener.class) continue;
            ((ChangeListener)objectArray[i + 1]).stateChanged(changeEvent);
        }
    }

    public synchronized void setVisible(RibbonContextualTaskGroup ribbonContextualTaskGroup, boolean bl) {
        this.groupVisibilityMap.put(ribbonContextualTaskGroup, bl);
        if (!bl) {
            boolean bl2 = false;
            for (int i = 0; i < ribbonContextualTaskGroup.getTaskCount(); ++i) {
                if (this.getSelectedTask() != ribbonContextualTaskGroup.getTask(i)) continue;
                bl2 = true;
                break;
            }
            if (bl2) {
                this.setSelectedTask(this.getTask(0));
            }
        }
        this.fireStateChanged();
        this.revalidate();
        SwingUtilities.getWindowAncestor(this).repaint();
    }

    public synchronized boolean isVisible(RibbonContextualTaskGroup ribbonContextualTaskGroup) {
        return this.groupVisibilityMap.get(ribbonContextualTaskGroup);
    }

    public synchronized void setApplicationMenu(RibbonApplicationMenu ribbonApplicationMenu) {
        RibbonApplicationMenu ribbonApplicationMenu2 = this.applicationMenu;
        if (ribbonApplicationMenu2 != ribbonApplicationMenu) {
            this.applicationMenu = ribbonApplicationMenu;
            if (this.applicationMenu != null) {
                this.applicationMenu.setFrozen();
            }
            this.firePropertyChange("applicationMenu", ribbonApplicationMenu2, this.applicationMenu);
        }
    }

    public synchronized RibbonApplicationMenu getApplicationMenu() {
        return this.applicationMenu;
    }

    public synchronized void setApplicationMenuRichTooltip(RichTooltip richTooltip) {
        RichTooltip richTooltip2 = this.applicationMenuRichTooltip;
        this.applicationMenuRichTooltip = richTooltip;
        this.firePropertyChange("applicationMenuRichTooltip", richTooltip2, this.applicationMenuRichTooltip);
    }

    public synchronized RichTooltip getApplicationMenuRichTooltip() {
        return this.applicationMenuRichTooltip;
    }

    public synchronized void setApplicationMenuKeyTip(String string) {
        String string2 = this.applicationMenuKeyTip;
        this.applicationMenuKeyTip = string;
        this.firePropertyChange("applicationMenuKeyTip", string2, this.applicationMenuKeyTip);
    }

    public synchronized String getApplicationMenuKeyTip() {
        return this.applicationMenuKeyTip;
    }

    public synchronized boolean isMinimized() {
        return this.isMinimized;
    }

    public synchronized void setMinimized(boolean bl) {
        boolean bl2 = this.isMinimized;
        if (bl2 != bl) {
            this.isMinimized = bl;
            this.firePropertyChange("minimized", bl2, this.isMinimized);
        }
    }

    public JFrame getRibbonFrame() {
        return this.ribbonFrame;
    }

    @Override
    public void setVisible(boolean bl) {
        if (!bl && this.getRibbonFrame() != null) {
            throw new IllegalArgumentException("Can't hide ribbon on JRibbonFrame");
        }
        super.setVisible(bl);
    }

    @Override
    protected void paintComponent(Graphics graphics) {
        graphics.setColor(Color.CYAN);
        graphics.fillRect(0, 0, this.getWidth(), this.getHeight());
        super.paintComponent(graphics);
    }
}

