/*
 * Decompiled with CFR 0.152.
 */
package commvault.cte.component.htmleditor.ui.text.dialogs;

import commvault.cte.component.htmleditor.HtmleditorStringBank;
import commvault.cte.component.htmleditor.ui.text.dialogs.AlignmentAttributesPanel;
import commvault.cte.component.htmleditor.ui.text.dialogs.BGColorPanel;
import commvault.cte.component.htmleditor.ui.text.dialogs.HTMLAttributeEditorPanel;
import commvault.cte.component.htmleditor.ui.text.dialogs.SizeAttributesPanel;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.Hashtable;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;

public class CellAttributesPanel
extends HTMLAttributeEditorPanel {
    private static final long serialVersionUID = 1L;
    private AlignmentAttributesPanel alignPanel = null;
    private SizeAttributesPanel sizePanel = null;
    private JCheckBox dontWrapCB = null;
    private BGColorPanel bgColorPanel = null;
    private JPanel spanPanel = null;
    private JCheckBox colSpanCB = null;
    private JCheckBox rowSpanCB = null;
    private JSpinner colSpanField = null;
    private JSpinner rowSpanField = null;
    private JPanel expansionPanel = null;

    public CellAttributesPanel() {
        this(new Hashtable());
    }

    public CellAttributesPanel(Hashtable hashtable) {
        super(hashtable);
        this.initialize();
        this.alignPanel.setAttributes(this.getAttributes());
        this.sizePanel.setAttributes(this.getAttributes());
        this.updateComponentsFromAttribs();
    }

    @Override
    public void updateComponentsFromAttribs() {
        this.alignPanel.updateComponentsFromAttribs();
        this.sizePanel.updateComponentsFromAttribs();
        if (this.attribs.containsKey("colspan")) {
            this.colSpanCB.setSelected(true);
            this.colSpanField.setEnabled(true);
            try {
                this.colSpanField.getModel().setValue(new Integer(this.attribs.get("colspan").toString()));
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        } else {
            this.colSpanCB.setSelected(false);
            this.colSpanField.setEnabled(false);
        }
        if (this.attribs.containsKey("rowspan")) {
            this.rowSpanCB.setSelected(true);
            this.rowSpanField.setEnabled(true);
            try {
                this.rowSpanField.getModel().setValue(new Integer(this.attribs.get("rowspan").toString()));
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        } else {
            this.rowSpanCB.setSelected(false);
            this.rowSpanField.setEnabled(false);
        }
        if (this.attribs.containsKey("bgcolor")) {
            this.bgColorPanel.setSelected(true);
            this.bgColorPanel.setColor(this.attribs.get("bgcolor").toString());
        } else {
            this.bgColorPanel.setSelected(false);
        }
        this.dontWrapCB.setSelected(this.attribs.containsKey("nowrap"));
    }

    @Override
    public void updateAttribsFromComponents() {
        this.alignPanel.updateAttribsFromComponents();
        this.sizePanel.updateAttribsFromComponents();
        if (this.dontWrapCB.isSelected()) {
            this.attribs.put("nowrap", "nowrap");
        } else {
            this.attribs.remove("nowrap");
        }
        if (this.bgColorPanel.isSelected()) {
            this.attribs.put("bgcolor", this.bgColorPanel.getColor());
        } else {
            this.attribs.remove("bgcolor");
        }
        if (this.colSpanCB.isSelected()) {
            this.attribs.put("colspan", this.colSpanField.getModel().getValue().toString());
        } else {
            this.attribs.remove("colspan");
        }
        if (this.rowSpanCB.isSelected()) {
            this.attribs.put("rowspan", this.rowSpanField.getModel().getValue().toString());
        } else {
            this.attribs.remove("rowspan");
        }
    }

    @Override
    public void setAttributes(Map map) {
        this.alignPanel.setAttributes(map);
        this.sizePanel.setAttributes(map);
        super.setAttributes(map);
    }

    private void initialize() {
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.gridy = 3;
        GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
        gridBagConstraints2.gridx = 0;
        gridBagConstraints2.gridheight = 2;
        gridBagConstraints2.anchor = 17;
        gridBagConstraints2.fill = 2;
        gridBagConstraints2.insets = new Insets(0, 0, 0, 5);
        gridBagConstraints2.gridy = 1;
        GridBagConstraints gridBagConstraints3 = new GridBagConstraints();
        gridBagConstraints3.gridx = 1;
        gridBagConstraints3.gridwidth = 2;
        gridBagConstraints3.anchor = 18;
        gridBagConstraints3.gridy = 2;
        GridBagConstraints gridBagConstraints4 = new GridBagConstraints();
        gridBagConstraints4.gridx = 1;
        gridBagConstraints4.anchor = 16;
        gridBagConstraints4.insets = new Insets(0, 0, 5, 0);
        gridBagConstraints4.gridwidth = 2;
        gridBagConstraints4.gridy = 1;
        GridBagConstraints gridBagConstraints5 = new GridBagConstraints();
        gridBagConstraints5.gridx = 1;
        gridBagConstraints5.anchor = 17;
        gridBagConstraints5.weightx = 1.0;
        gridBagConstraints5.insets = new Insets(0, 0, 5, 0);
        gridBagConstraints5.gridy = 0;
        GridBagConstraints gridBagConstraints6 = new GridBagConstraints();
        gridBagConstraints6.gridx = 0;
        gridBagConstraints6.anchor = 17;
        gridBagConstraints6.insets = new Insets(0, 0, 5, 5);
        gridBagConstraints6.gridwidth = 1;
        gridBagConstraints6.gridy = 0;
        this.setLayout(new GridBagLayout());
        this.setSize(420, 200);
        this.setPreferredSize(new Dimension(410, 200));
        this.add((Component)this.getAlignPanel(), gridBagConstraints6);
        this.add((Component)this.getSizePanel(), gridBagConstraints5);
        this.add((Component)this.getDontWrapCB(), gridBagConstraints4);
        this.add((Component)this.getBgColorPanel(), gridBagConstraints3);
        this.add((Component)this.getSpanPanel(), gridBagConstraints2);
        this.add((Component)this.getExpansionPanel(), gridBagConstraints);
    }

    private AlignmentAttributesPanel getAlignPanel() {
        if (this.alignPanel == null) {
            this.alignPanel = new AlignmentAttributesPanel();
            this.alignPanel.setPreferredSize(new Dimension(180, 95));
        }
        return this.alignPanel;
    }

    private JPanel getSizePanel() {
        if (this.sizePanel == null) {
            this.sizePanel = new SizeAttributesPanel();
        }
        return this.sizePanel;
    }

    private JCheckBox getDontWrapCB() {
        if (this.dontWrapCB == null) {
            this.dontWrapCB = new JCheckBox();
            this.dontWrapCB.setText(HtmleditorStringBank.dont_wrap_text.getI18n());
        }
        return this.dontWrapCB;
    }

    private BGColorPanel getBgColorPanel() {
        if (this.bgColorPanel == null) {
            this.bgColorPanel = new BGColorPanel();
        }
        return this.bgColorPanel;
    }

    private JPanel getSpanPanel() {
        if (this.spanPanel == null) {
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.fill = 0;
            gridBagConstraints.gridy = 1;
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.anchor = 17;
            gridBagConstraints.gridx = 1;
            GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
            gridBagConstraints2.fill = 0;
            gridBagConstraints2.gridy = 0;
            gridBagConstraints2.weightx = 0.0;
            gridBagConstraints2.anchor = 17;
            gridBagConstraints2.gridx = 1;
            GridBagConstraints gridBagConstraints3 = new GridBagConstraints();
            gridBagConstraints3.gridx = 0;
            gridBagConstraints3.anchor = 17;
            gridBagConstraints3.gridheight = 1;
            gridBagConstraints3.insets = new Insets(0, 0, 0, 0);
            gridBagConstraints3.gridy = 1;
            GridBagConstraints gridBagConstraints4 = new GridBagConstraints();
            gridBagConstraints4.gridx = 0;
            gridBagConstraints4.anchor = 17;
            gridBagConstraints4.insets = new Insets(0, 0, 5, 0);
            gridBagConstraints4.gridy = 0;
            this.spanPanel = new JPanel();
            this.spanPanel.setLayout(new GridBagLayout());
            this.spanPanel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder(null, HtmleditorStringBank.span.getI18n(), 0, 0, null, null), BorderFactory.createEmptyBorder(2, 2, 2, 2)));
            this.spanPanel.add((Component)this.getColSpanCB(), gridBagConstraints4);
            this.spanPanel.add((Component)this.getRowSpanCB(), gridBagConstraints3);
            this.spanPanel.add((Component)this.getColSpanField(), gridBagConstraints2);
            this.spanPanel.add((Component)this.getRowSpanField(), gridBagConstraints);
        }
        return this.spanPanel;
    }

    private JCheckBox getColSpanCB() {
        if (this.colSpanCB == null) {
            this.colSpanCB = new JCheckBox();
            this.colSpanCB.setText(HtmleditorStringBank.cellspacing.getI18n());
            this.colSpanCB.setPreferredSize(new Dimension(85, 25));
            this.colSpanCB.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent itemEvent) {
                    CellAttributesPanel.this.colSpanField.setEnabled(CellAttributesPanel.this.colSpanCB.isSelected());
                }
            });
        }
        return this.colSpanCB;
    }

    private JCheckBox getRowSpanCB() {
        if (this.rowSpanCB == null) {
            this.rowSpanCB = new JCheckBox();
            this.rowSpanCB.setText(HtmleditorStringBank.rowspan.getI18n());
            this.rowSpanCB.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent itemEvent) {
                    CellAttributesPanel.this.rowSpanField.setEnabled(CellAttributesPanel.this.rowSpanCB.isSelected());
                }
            });
        }
        return this.rowSpanCB;
    }

    private JSpinner getColSpanField() {
        if (this.colSpanField == null) {
            this.colSpanField = new JSpinner(new SpinnerNumberModel(1, 1, 999, 1));
        }
        return this.colSpanField;
    }

    private JSpinner getRowSpanField() {
        if (this.rowSpanField == null) {
            this.rowSpanField = new JSpinner(new SpinnerNumberModel(1, 1, 999, 1));
        }
        return this.rowSpanField;
    }

    private JPanel getExpansionPanel() {
        if (this.expansionPanel == null) {
            this.expansionPanel = new JPanel();
        }
        return this.expansionPanel;
    }
}

