/*
 * Decompiled with CFR 0.152.
 */
package commvault.cte.component.htmleditor.ui.text.actions;

import commvault.cte.component.htmleditor.HtmleditorStringBank;
import commvault.cte.component.htmleditor.ui.UIUtils;
import commvault.cte.component.htmleditor.ui.text.CompoundUndoManager;
import commvault.cte.component.htmleditor.ui.text.actions.HTMLTextEditAction;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.event.ActionEvent;
import javax.swing.Action;
import javax.swing.JEditorPane;
import javax.swing.KeyStroke;
import javax.swing.text.html.HTMLDocument;
import javax.swing.text.html.HTMLEditorKit;
import org.bushe.swing.action.ShouldBeEnabledDelegate;

public class PasteAction
extends HTMLTextEditAction {
    private static final long serialVersionUID = 1L;

    public PasteAction() {
        super(HtmleditorStringBank.paste.getI18n());
        this.putValue("MnemonicKey", new Integer(80));
        this.putValue("SmallIcon", UIUtils.getIcon("images/x16/", "paste.png"));
        this.putValue("LARGE_ICON", UIUtils.getIcon("images/x24/", "paste.png"));
        this.putValue("AcceleratorKey", KeyStroke.getKeyStroke(86, 2));
        this.addShouldBeEnabledDelegate(new ShouldBeEnabledDelegate(){

            public boolean shouldBeEnabled(Action action) {
                return true;
            }
        });
        this.putValue("ShortDescription", this.getValue("Name"));
    }

    @Override
    protected void updateWysiwygContextState(JEditorPane jEditorPane) {
        this.updateEnabledState();
    }

    @Override
    protected void updateSourceContextState(JEditorPane jEditorPane) {
        this.updateEnabledState();
    }

    @Override
    protected void sourceEditPerformed(ActionEvent actionEvent, JEditorPane jEditorPane) {
        jEditorPane.paste();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void wysiwygEditPerformed(ActionEvent actionEvent, JEditorPane jEditorPane) {
        HTMLEditorKit hTMLEditorKit = (HTMLEditorKit)jEditorPane.getEditorKit();
        HTMLDocument hTMLDocument = (HTMLDocument)jEditorPane.getDocument();
        Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
        try {
            CompoundUndoManager.beginCompoundEdit(hTMLDocument);
            Transferable transferable = clipboard.getContents((Object)this);
            String string = transferable.getTransferData(new DataFlavor(String.class, "String")).toString();
            hTMLDocument.replace(jEditorPane.getSelectionStart(), jEditorPane.getSelectionEnd() - jEditorPane.getSelectionStart(), string, hTMLEditorKit.getInputAttributes());
        }
        catch (Exception exception) {
        }
        finally {
            CompoundUndoManager.endCompoundEdit(hTMLDocument);
        }
    }
}

