/*
 * Decompiled with CFR 0.152.
 */
package commvault.cte.component.htmleditor.ui.text.actions;

import commvault.cte.component.htmleditor.HtmleditorStringBank;
import commvault.cte.component.htmleditor.ui.UIUtils;
import commvault.cte.component.htmleditor.ui.text.CompoundUndoManager;
import commvault.cte.component.htmleditor.ui.text.ElementWriter;
import commvault.cte.component.htmleditor.ui.text.HTMLUtils;
import commvault.cte.component.htmleditor.ui.text.actions.HTMLTextEditAction;
import java.awt.event.ActionEvent;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import javax.swing.JEditorPane;
import javax.swing.KeyStroke;
import javax.swing.text.BadLocationException;
import javax.swing.text.Element;
import javax.swing.text.html.HTML;
import javax.swing.text.html.HTMLDocument;
import javax.swing.text.html.HTMLEditorKit;

public class HTMLBlockAction
extends HTMLTextEditAction {
    private static final long serialVersionUID = 1L;
    public static final int DIV = 0;
    public static final int P = 1;
    public static final int H1 = 2;
    public static final int H2 = 3;
    public static final int H3 = 4;
    public static final int H4 = 5;
    public static final int H5 = 6;
    public static final int H6 = 7;
    public static final int PRE = 8;
    public static final int BLOCKQUOTE = 9;
    public static final int OL = 10;
    public static final int UL = 11;
    private static final int[] KEYS = new int[]{68, 10, 49, 50, 51, 52, 53, 54, 82, 81, 78, 85};
    public static final String[] ELEMENT_TYPES = new String[]{HtmleditorStringBank.bodyText.getI18n(), HtmleditorStringBank.paragraph.getI18n(), HtmleditorStringBank.heading.getI18n() + " 1", HtmleditorStringBank.heading.getI18n() + " 2", HtmleditorStringBank.heading.getI18n() + " 3", HtmleditorStringBank.heading.getI18n() + " 4", HtmleditorStringBank.heading.getI18n() + " 5", HtmleditorStringBank.heading.getI18n() + " 6", HtmleditorStringBank.preformatted.getI18n(), HtmleditorStringBank.blockquote.getI18n(), HtmleditorStringBank.orderedList.getI18n(), HtmleditorStringBank.unorderedList.getI18n()};
    private int type;

    public HTMLBlockAction(int n) throws IllegalArgumentException {
        super("");
        if (n < 0 || n >= ELEMENT_TYPES.length) {
            throw new IllegalArgumentException("Illegal argument");
        }
        this.type = n;
        this.putValue("Name", ELEMENT_TYPES[n]);
        this.putValue("AcceleratorKey", KeyStroke.getKeyStroke(KEYS[n], 8));
        if (n == 1) {
            this.putValue("MnemonicKey", new Integer(80));
        } else if (n == 8) {
            this.putValue("MnemonicKey", new Integer(70));
        } else if (n == 9) {
            this.putValue("MnemonicKey", new Integer(113));
        } else if (n == 10) {
            this.putValue("SmallIcon", UIUtils.getIcon("images/x16/", "listordered.png"));
            this.putValue("MnemonicKey", new Integer(79));
        } else if (n == 11) {
            this.putValue("SmallIcon", UIUtils.getIcon("images/x16/", "listunordered.png"));
            this.putValue("MnemonicKey", new Integer(117));
        } else {
            String string = n + "";
            this.putValue("MnemonicKey", new Integer(string.charAt(0)));
        }
        this.putValue("BUTTON_TYPE", "radio");
        this.putValue("ShortDescription", this.getValue("Name"));
    }

    @Override
    protected void updateWysiwygContextState(JEditorPane jEditorPane) {
        HTMLDocument hTMLDocument = (HTMLDocument)jEditorPane.getDocument();
        Element element = hTMLDocument.getParagraphElement(jEditorPane.getCaretPosition());
        String string = element.getName();
        if (string.equals("p-implied")) {
            string = element.getParentElement().getName();
        }
        if (this.type == 0 && (string.equals("div") || string.equals("body") || string.equals("td"))) {
            this.setSelected(true);
        } else if (this.type == 11) {
            Element element2 = HTMLUtils.getListParent(element);
            this.setSelected(element2 != null && element2.getName().equals("ul"));
        } else if (this.type == 10) {
            Element element3 = HTMLUtils.getListParent(element);
            this.setSelected(element3 != null && element3.getName().equals("ol"));
        } else if (string.equals(this.getTag().toString().toLowerCase())) {
            this.setSelected(true);
        } else {
            this.setSelected(false);
        }
    }

    @Override
    protected void updateSourceContextState(JEditorPane jEditorPane) {
        this.setSelected(false);
    }

    @Override
    protected void sourceEditPerformed(ActionEvent actionEvent, JEditorPane jEditorPane) {
        String string;
        String string2 = this.getTag().toString();
        String string3 = "\n<" + string2 + ">\n\t";
        String string4 = "\n</" + string2 + ">\n";
        if (this.type == 10 || this.type == 11) {
            string3 = string3 + "<li>";
            string4 = "</li>" + string4;
        }
        if ((string = jEditorPane.getSelectedText()) == null) {
            jEditorPane.replaceSelection(string3 + string4);
            int n = jEditorPane.getCaretPosition() - string4.length();
            if (n >= 0) {
                jEditorPane.setCaretPosition(n);
            }
        } else {
            string = string3 + string + string4;
            jEditorPane.replaceSelection(string);
        }
    }

    @Override
    protected void wysiwygEditPerformed(ActionEvent actionEvent, JEditorPane jEditorPane) {
        HTMLDocument hTMLDocument = (HTMLDocument)jEditorPane.getDocument();
        int n = jEditorPane.getCaretPosition();
        CompoundUndoManager.beginCompoundEdit(hTMLDocument);
        try {
            if (this.type == 10 || this.type == 11) {
                this.insertList(jEditorPane, actionEvent);
            } else {
                this.changeBlockType(jEditorPane, actionEvent);
            }
            jEditorPane.setCaretPosition(n);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        CompoundUndoManager.endCompoundEdit(hTMLDocument);
    }

    private HTML.Tag getRootTag(Element element) {
        HTML.Tag tag = HTML.Tag.BODY;
        if (HTMLUtils.getParent(element, HTML.Tag.TD) != null) {
            tag = HTML.Tag.TD;
        }
        return tag;
    }

    private void insertHTML(String string, HTML.Tag tag, HTML.Tag tag2, ActionEvent actionEvent) {
        HTMLEditorKit.InsertHTMLTextAction insertHTMLTextAction = new HTMLEditorKit.InsertHTMLTextAction("insertHTML", string, tag2, tag);
        insertHTMLTextAction.actionPerformed(actionEvent);
    }

    private void changeListType(Element element, HTML.Tag tag, HTMLDocument hTMLDocument) {
        StringWriter stringWriter = new StringWriter();
        ElementWriter elementWriter = new ElementWriter((Writer)stringWriter, element);
        try {
            elementWriter.write();
            String string = stringWriter.toString();
            string = string.substring(string.indexOf(62) + 1, string.length());
            string = string.substring(0, string.lastIndexOf(60));
            string = '<' + tag.toString() + '>' + string + "</" + tag.toString() + '>';
            hTMLDocument.setOuterHTML(element, string);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void insertList(JEditorPane jEditorPane, ActionEvent actionEvent) throws BadLocationException {
        HTML.Tag tag;
        HTMLDocument hTMLDocument = (HTMLDocument)jEditorPane.getDocument();
        int n = jEditorPane.getCaretPosition();
        Element element = hTMLDocument.getParagraphElement(n);
        HTML.Tag tag2 = HTML.getTag(element.getParentElement().getName());
        Element element2 = element.getParentElement().getParentElement();
        HTML.Tag tag3 = HTML.getTag(element2.getName());
        if (tag3.equals(HTML.Tag.UL) || tag3.equals(HTML.Tag.OL)) {
            tag = HTML.getTag(element2.getName());
            if (this.type == 10 && tag.equals(HTML.Tag.UL)) {
                this.changeListType(element2, HTML.Tag.OL, hTMLDocument);
                return;
            }
            if (this.type == 11 && tag3.equals(HTML.Tag.OL)) {
                this.changeListType(element2, HTML.Tag.UL, hTMLDocument);
                return;
            }
        }
        if (!tag2.equals(HTML.Tag.LI)) {
            this.changeBlockType(jEditorPane, actionEvent);
        } else {
            tag = this.getRootTag(element);
            String string = HTMLUtils.getElementHTML(element, false);
            jEditorPane.setCaretPosition(element.getEndOffset());
            this.insertHTML("<p>" + string + "</p>", HTML.Tag.P, tag, actionEvent);
            HTMLUtils.removeElement(element);
        }
    }

    private void changeBlockType(JEditorPane jEditorPane, ActionEvent actionEvent) throws BadLocationException {
        Object object;
        HTMLDocument hTMLDocument = (HTMLDocument)jEditorPane.getDocument();
        Element element = hTMLDocument.getParagraphElement(jEditorPane.getSelectionStart());
        Element element2 = hTMLDocument.getParagraphElement(jEditorPane.getSelectionEnd());
        Element element3 = HTMLUtils.getParent(element, HTML.Tag.TD);
        HTML.Tag tag = this.getTag();
        HTML.Tag tag2 = this.getRootTag(element);
        String string = "";
        if (this.isListType()) {
            string = "<" + this.getTag() + ">";
            tag = HTML.Tag.LI;
        }
        ArrayList<Element> arrayList = new ArrayList<Element>();
        arrayList.add(element);
        do {
            string = string + HTMLUtils.createTag(tag, element.getAttributes(), HTMLUtils.getElementHTML(element, false));
            if (element.getEndOffset() >= element2.getEndOffset() || element.getEndOffset() >= hTMLDocument.getLength()) break;
            element = hTMLDocument.getParagraphElement(element.getEndOffset() + 1);
            arrayList.add(element);
        } while ((object = HTMLUtils.getParent(element, HTML.Tag.TD)) == null || object.equals(element3));
        if (this.isListType()) {
            string = string + "</" + this.getTag() + ">";
        }
        jEditorPane.setCaretPosition(element.getStartOffset());
        this.insertHTML(string, this.getTag(), tag2, actionEvent);
        for (Element element4 : arrayList) {
            HTMLUtils.removeElement(element4);
        }
    }

    private boolean isListType() {
        return this.type == 10 || this.type == 11;
    }

    public HTML.Tag getTag() {
        HTML.Tag tag = HTML.Tag.DIV;
        switch (this.type) {
            case 1: {
                tag = HTML.Tag.P;
                break;
            }
            case 2: {
                tag = HTML.Tag.H1;
                break;
            }
            case 3: {
                tag = HTML.Tag.H2;
                break;
            }
            case 4: {
                tag = HTML.Tag.H3;
                break;
            }
            case 5: {
                tag = HTML.Tag.H4;
                break;
            }
            case 6: {
                tag = HTML.Tag.H5;
                break;
            }
            case 7: {
                tag = HTML.Tag.H6;
                break;
            }
            case 8: {
                tag = HTML.Tag.PRE;
                break;
            }
            case 11: {
                tag = HTML.Tag.UL;
                break;
            }
            case 10: {
                tag = HTML.Tag.OL;
                break;
            }
            case 9: {
                tag = HTML.Tag.BLOCKQUOTE;
                break;
            }
            case 0: {
                tag = HTML.Tag.DIV;
            }
        }
        return tag;
    }
}

