/*
 * Decompiled with CFR 0.152.
 */
package commvault.cte.component.htmleditor.ui;

import commvault.cte.component.htmleditor.ui.ExceptionDialog;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Insets;
import java.awt.Window;
import java.net.URL;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPopupMenu;
import javax.swing.JToolBar;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import org.bushe.swing.action.ActionUIFactory;

public class UIUtils {
    public static final String X16 = "images/x16/";
    public static final String X24 = "images/x24/";
    public static final String X32 = "images/x32/";
    public static final String X48 = "images/x32/";
    public static final String MISC = "images/misc/";

    public static ImageIcon getIcon(String string, String string2) {
        if (!string.endsWith("/")) {
            string = string + "/";
        }
        return UIUtils.getIcon(string + string2);
    }

    public static ImageIcon getIcon(String string) {
        return UIUtils.createImageIcon(string);
    }

    public static ImageIcon createImageIcon(String string) {
        URL uRL = Thread.currentThread().getContextClassLoader().getResource(string);
        if (uRL == null) {
            return null;
        }
        return new ImageIcon(uRL);
    }

    public static void showError(String string) {
        UIUtils.showError(null, string);
    }

    public static void showError(Component component, Throwable throwable) {
        Window window = SwingUtilities.getWindowAncestor(component);
        if (window instanceof Frame) {
            UIUtils.showError((Frame)window, throwable);
        } else if (window instanceof Dialog) {
            UIUtils.showError((Dialog)window, throwable);
        } else {
            UIUtils.showError(component, throwable.getLocalizedMessage());
        }
    }

    public static void showError(Component component, String string) {
        UIUtils.showError(component, "Error", string);
    }

    public static void showError(Component component, String string, String string2) {
        JOptionPane.showMessageDialog(component, string2, string, 0);
    }

    public static void showError(Frame frame, String string, Throwable throwable) {
        ExceptionDialog exceptionDialog = new ExceptionDialog(frame, throwable);
        if (string != null) {
            exceptionDialog.setTitle(string);
        }
        exceptionDialog.setLocationRelativeTo(frame);
        exceptionDialog.setVisible(true);
        throwable.printStackTrace();
    }

    public static void showError(Frame frame, Throwable throwable) {
        UIUtils.showError(frame, null, throwable);
    }

    public static void showError(Dialog dialog, String string, Throwable throwable) {
        ExceptionDialog exceptionDialog = new ExceptionDialog(dialog, throwable);
        if (string != null) {
            exceptionDialog.setTitle(string);
        }
        exceptionDialog.setLocationRelativeTo(dialog);
        exceptionDialog.setVisible(true);
        throwable.printStackTrace();
    }

    public static void showError(Dialog dialog, Throwable throwable) {
        UIUtils.showError(dialog, null, throwable);
    }

    public static void showWarning(Component component, String string, String string2) {
        JOptionPane.showMessageDialog(component, string2, string, 2);
    }

    public static void showWarning(Component component, String string) {
        UIUtils.showWarning(component, "Warning", string);
    }

    public static void showWarning(String string) {
        UIUtils.showWarning(null, string);
    }

    public static void showInfo(Component component, String string, String string2) {
        JOptionPane.showMessageDialog(component, string2, string, 1);
    }

    public static void showInfo(Component component, String string) {
        UIUtils.showInfo(component, "Information", string);
    }

    public static void showInfo(String string) {
        UIUtils.showInfo(null, string);
    }

    public static AbstractButton addToolBarButton(JToolBar jToolBar, Action action) {
        return UIUtils.addToolBarButton(jToolBar, ActionUIFactory.getInstance().createButton(action));
    }

    public static AbstractButton addToolBarButton(JToolBar jToolBar, Action action, boolean bl, boolean bl2) {
        return UIUtils.addToolBarButton(jToolBar, ActionUIFactory.getInstance().createButton(action), false, true);
    }

    public static AbstractButton addToolBarButton(JToolBar jToolBar, AbstractButton abstractButton) {
        return UIUtils.addToolBarButton(jToolBar, abstractButton, false, true);
    }

    public static AbstractButton addToolBarButton(JToolBar jToolBar, AbstractButton abstractButton, boolean bl, boolean bl2) {
        Icon icon;
        if (abstractButton.getAction() != null) {
            abstractButton.setToolTipText((String)abstractButton.getAction().getValue("Name"));
            if (abstractButton.getAction().getValue("LARGE_ICON") != null) {
                try {
                    abstractButton.setIcon((Icon)abstractButton.getAction().getValue("LARGE_ICON"));
                }
                catch (ClassCastException classCastException) {
                    // empty catch block
                }
            }
        }
        if ((icon = abstractButton.getIcon()) != null && bl2) {
            abstractButton.setText(null);
            abstractButton.setMnemonic(0);
            abstractButton.putClientProperty("hideActionText", Boolean.TRUE);
            int n = Math.max(icon.getIconWidth(), icon.getIconHeight()) + 6;
            Dimension dimension = new Dimension(n, n);
            abstractButton.setPreferredSize(dimension);
        }
        if (!bl) {
            abstractButton.setFocusable(false);
            abstractButton.setFocusPainted(false);
        }
        abstractButton.setMargin(new Insets(1, 1, 1, 1));
        jToolBar.add(abstractButton);
        return abstractButton;
    }

    public static JMenuItem addMenuItem(JMenu jMenu, Action action) {
        JMenuItem jMenuItem = jMenu.add(action);
        UIUtils.configureMenuItem(jMenuItem, action);
        return jMenuItem;
    }

    public static JMenuItem addMenuItem(JPopupMenu jPopupMenu, Action action) {
        JMenuItem jMenuItem = jPopupMenu.add(action);
        UIUtils.configureMenuItem(jMenuItem, action);
        return jMenuItem;
    }

    private static void configureMenuItem(JMenuItem jMenuItem, Action action) {
        KeyStroke keyStroke = (KeyStroke)action.getValue("AcceleratorKey");
        if (keyStroke != null) {
            jMenuItem.setAccelerator(keyStroke);
        }
        jMenuItem.setIcon(null);
        jMenuItem.setToolTipText(null);
    }
}

