/*
 * Decompiled with CFR 0.152.
 */
package commvault.cte.component.filechooser;

import commvault.cte.component.LayoutUtils;
import commvault.cte.component.filechooser.ServerFile;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import javax.swing.Box;
import javax.swing.DefaultListCellRenderer;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.UIManager;

public class OpenFileLookInRenderer
extends DefaultListCellRenderer {
    JPanel jpanel = new JPanel();
    Component trailingStrut = Box.createHorizontalGlue();
    LeadingStrut leftPadding = new LeadingStrut();
    GridBagConstraints constraints = new GridBagConstraints();
    Icon directoryIcon = UIManager.getIcon("FileView.directoryIcon");
    Icon hardDriveIcon = UIManager.getIcon("FileView.hardDriveIcon");

    public OpenFileLookInRenderer() {
        this.jpanel.setLayout(new GridBagLayout());
    }

    @Override
    public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
        Component component = super.getListCellRendererComponent((JList<?>)jList, object, n, bl, bl2);
        if (object == null) {
            this.setIcon(null);
            this.setText("");
            return component;
        }
        ServerFile serverFile = (ServerFile)object;
        if (serverFile.isRoot()) {
            this.setIcon(this.hardDriveIcon);
        } else {
            this.setIcon(this.directoryIcon);
        }
        String string = serverFile.getName();
        if (string.length() == 0) {
            this.setText(serverFile.getPath());
        } else {
            this.setText(string);
        }
        if (n == -1) {
            return this;
        }
        this.jpanel.removeAll();
        int n2 = this.getPathSize(serverFile);
        this.jpanel.setOpaque(false);
        this.leftPadding.width = 16 * n2;
        this.jpanel.add((Component)this.leftPadding, LayoutUtils.getConstraints(this.constraints, 0, 0, 1, 1, 0.0, 1.0, 13, 0));
        this.jpanel.add((Component)this, LayoutUtils.getConstraints(this.constraints, 1, 0, 1, 1, 0.0, 1.0, 13, 0));
        this.jpanel.add(this.trailingStrut, LayoutUtils.getConstraints(this.constraints, 2, 0, 1, 1, 1.0, 1.0, 13, 1));
        return this.jpanel;
    }

    public int getPathSize(ServerFile serverFile) {
        int n = 0;
        ServerFile serverFile2 = (ServerFile)serverFile.getParentFile();
        while (serverFile2 != null) {
            serverFile2 = (ServerFile)serverFile2.getParentFile();
            ++n;
        }
        return n;
    }

    class LeadingStrut
    extends JComponent {
        public int width = 0;
        public int height = 0;
        Dimension dim = new Dimension(0, 0);

        LeadingStrut() {
        }

        @Override
        public Dimension getPreferredSize() {
            this.dim.width = this.width;
            return this.dim;
        }
    }
}

