/*
 * Decompiled with CFR 0.152.
 */
package commvault.cte.component.explorer;

import commvault.cte.CteStringBank;
import commvault.cte.component.StatusMessage;
import commvault.cte.component.explorer.BrowserObserverParams;
import commvault.cte.component.explorer.CommNetBrowseTreeNode;
import commvault.cte.component.explorer.CommNetBrowseTreeRootNode;
import commvault.cte.component.explorer.ExplorerTable;
import commvault.cte.component.explorer.Refreshable;
import commvault.cte.component.table.SortedTableModel;
import commvault.cte.component.tree.DynamicTree;
import commvault.cte.component.tree.TreeUtils;
import commvault.cte.util.ThreadPoolManager;
import java.awt.Dimension;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.text.MessageFormat;
import java.util.Observable;
import java.util.Observer;
import javax.swing.BorderFactory;
import javax.swing.JSplitPane;
import javax.swing.JTree;
import javax.swing.ListSelectionModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.event.TreeWillExpandListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;

public class JExplorer
extends JSplitPane
implements Observer,
TreeSelectionListener,
TreeWillExpandListener,
ListSelectionListener {
    public static final int NOTIFY_FIRE_TABLE_DATA_CHANGED = -1;
    public static final int NOTIFY_UPDATE_TABLE_BUT_KEEP_MAP = -2;
    public static final int NOTIFY_EXPLORE = -4;
    public static final int NOTIFY_REPAINT = -7;
    public static final int NOTIFY_TABLE_DATA_RELOAD = -15;
    public static final int NOTIFY_UPDATE_COL_SIZES = -10;
    public static final int NOTIFY_EXTENDED_MODE_UPDATE = -20;
    public static final int NOTIFY_STATUS_FLAG_CHANGED = -30;
    public static final int NOTIFY_CHANGE_SELECTION = -40;
    CommNetBrowseTreeNode rootNode;
    DynamicTree tree;
    ExplorerTable table;

    public JExplorer(CommNetBrowseTreeNode commNetBrowseTreeNode) {
        this.rootNode = commNetBrowseTreeNode;
        this.table = new ExplorerTable(this.rootNode);
        DefaultTreeModel defaultTreeModel = new DefaultTreeModel(this.rootNode, true);
        this.tree = new DynamicTree(defaultTreeModel);
        this.tree.getTree().setSelectionPath(new TreePath(this.rootNode));
        this.tree.getTree().addTreeSelectionListener(this);
        this.tree.getTree().addTreeWillExpandListener(this);
        ((CommNetBrowseTreeRootNode)this.rootNode.getRoot()).addObserver(this);
        Dimension dimension = new Dimension(0, 0);
        this.tree.setMinimumSize(dimension);
        this.table.setMinimumSize(dimension);
        this.setLeftComponent(this.tree);
        this.setRightComponent(this.table);
        final ListSelectionModel listSelectionModel = this.table.getTable().getSelectionModel();
        listSelectionModel.addListSelectionListener(this);
        this.table.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.table.getTable().setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.setBorder(BorderFactory.createEmptyBorder(1, 1, 1, 1));
        this.setSelectedNode(this.rootNode);
        this.table.setModel(this.rootNode);
        this.tree.getTree().addFocusListener(new FocusListener(){

            @Override
            public void focusGained(FocusEvent focusEvent) {
                listSelectionModel.clearSelection();
                JExplorer.this.setSelectedNodeOnTree();
            }

            @Override
            public void focusLost(FocusEvent focusEvent) {
            }
        });
    }

    public void setSelectionMode(int n) {
        this.table.setSelectionMode(n);
    }

    public JExplorer() {
    }

    public void clearup() {
        this.table.getTable().getSelectionModel().removeListSelectionListener(this);
        this.tree.getTree().removeTreeWillExpandListener(this);
        this.tree.getTree().removeTreeSelectionListener(this);
        super.removeAll();
        super.setLeftComponent(null);
        super.setRightComponent(null);
        this.table.saveTablePreference();
        this.table.clearup();
        this.tree.clearup();
        this.tree = null;
        this.table = null;
        this.rootNode = null;
    }

    public void setRootNode(CommNetBrowseTreeNode commNetBrowseTreeNode) {
        ((CommNetBrowseTreeNode)this.rootNode.getRoot()).nodeCleanup();
        ThreadPoolManager.gc();
        this.rootNode = commNetBrowseTreeNode;
        this.table = new ExplorerTable(this.rootNode);
        DefaultTreeModel defaultTreeModel = new DefaultTreeModel(this.rootNode, true);
        this.tree = new DynamicTree(defaultTreeModel);
        this.tree.getTree().setSelectionPath(new TreePath(this.rootNode));
        this.tree.getTree().addTreeSelectionListener(this);
        this.tree.getTree().addTreeWillExpandListener(this);
        ((CommNetBrowseTreeRootNode)this.rootNode.getRoot()).addObserver(this);
        Dimension dimension = new Dimension(0, 0);
        this.tree.setMinimumSize(dimension);
        this.table.setMinimumSize(dimension);
        this.setLeftComponent(this.tree);
        this.setRightComponent(this.table);
        ListSelectionModel listSelectionModel = this.table.getTable().getSelectionModel();
        listSelectionModel = this.table.getTable().getSelectionModel();
        listSelectionModel.addListSelectionListener(this);
    }

    public ExplorerTable getTable() {
        return this.table;
    }

    public DynamicTree getTree() {
        return this.tree;
    }

    public void exit() {
        ((CommNetBrowseTreeRootNode)this.rootNode.getRoot()).deleteObserver(this);
    }

    public CommNetBrowseTreeNode getTreeSelectedNode() {
        return (CommNetBrowseTreeNode)this.tree.getSelectedNode();
    }

    @Override
    public void update(Observable observable, Object object) {
        CommNetBrowseTreeNode commNetBrowseTreeNode = this.getTreeSelectedNode();
        BrowserObserverParams browserObserverParams = (BrowserObserverParams)object;
        CommNetBrowseTreeNode commNetBrowseTreeNode2 = (CommNetBrowseTreeNode)browserObserverParams.treeNode;
        int n = browserObserverParams.updateRow;
        if (n == -4 && commNetBrowseTreeNode2 == this.getSelectedNode()) {
            this.explore(this.getSelectedNode());
            this.setDisplayString(commNetBrowseTreeNode);
            return;
        }
        if (n == -40) {
            this.explore(commNetBrowseTreeNode2);
        } else {
            if (n == -7) {
                this.tree.getTree().repaint();
                this.table.getTable().repaint();
                return;
            }
            if (n == -30) {
                this.setDisplayString(commNetBrowseTreeNode);
                return;
            }
            if (n == -15 && commNetBrowseTreeNode2 == this.getSelectedNode()) {
                this.table.tableChanged(new TableModelEvent(this.table.getTable().getModel()));
            } else if (n == -10) {
                this.table.recalculateColSizes();
            }
        }
        if (commNetBrowseTreeNode2 == commNetBrowseTreeNode) {
            SortedTableModel sortedTableModel = (SortedTableModel)this.table.getTable().getModel();
            sortedTableModel.tableChanged(new TableModelEvent(sortedTableModel, n));
            this.table.getTable().repaint();
        }
        ((DefaultTreeModel)this.tree.getTree().getModel()).reload(commNetBrowseTreeNode2);
        this.setDisplayString(commNetBrowseTreeNode);
    }

    private void setDisplayString(CommNetBrowseTreeNode commNetBrowseTreeNode) {
    }

    public void outRepaint() {
        this.tree.getTree().repaint();
        this.table.getTable().repaint();
        this.setDisplayString(this.getSelectedNode());
    }

    @Override
    public void valueChanged(ListSelectionEvent listSelectionEvent) {
        this.whenTableRowSelected();
    }

    private void whenTableRowSelected() {
    }

    void explore(CommNetBrowseTreeNode commNetBrowseTreeNode) {
        this.expandNode(commNetBrowseTreeNode);
    }

    @Override
    public void valueChanged(TreeSelectionEvent treeSelectionEvent) {
        CommNetBrowseTreeNode commNetBrowseTreeNode;
        if (!treeSelectionEvent.isAddedPath()) {
            return;
        }
        TreePath treePath = ((JTree)treeSelectionEvent.getSource()).getSelectionPath();
        if (treePath != null && (commNetBrowseTreeNode = this.getSelectedNode()) != null) {
            this.setSelectedNodeOnTree();
        }
    }

    public void setSelectedNodeOnTree() {
        ListSelectionModel listSelectionModel = this.table.getTable().getSelectionModel();
        listSelectionModel.clearSelection();
        CommNetBrowseTreeNode commNetBrowseTreeNode = this.getSelectedNode();
        commNetBrowseTreeNode.addObserver(false);
        this.table.setModel(commNetBrowseTreeNode);
        this.fireTableModelChangedEvent();
        if (commNetBrowseTreeNode.isHorizontalScrollRequired()) {
            this.table.getTable().setAutoResizeMode(0);
        } else {
            this.table.getTable().setAutoResizeMode(4);
        }
        commNetBrowseTreeNode.addObserver(true);
        commNetBrowseTreeNode.selected();
        this.setDisplayString(commNetBrowseTreeNode);
        int n = commNetBrowseTreeNode.getChildCount();
        int n2 = commNetBrowseTreeNode.getLogicalChildCount();
        if (n > 0) {
            StatusMessage.setStatusMessage(MessageFormat.format(CteStringBank.commvault_qnet_components_JExplorer_key3.getI18n(), new Integer(n)));
        } else if (n2 > 0) {
            StatusMessage.setStatusMessage(MessageFormat.format(CteStringBank.commvault_qnet_components_JExplorer_key3.getI18n(), new Integer(n2)));
        } else {
            StatusMessage.resetStatusMessage();
        }
    }

    @Override
    public void treeWillCollapse(TreeExpansionEvent treeExpansionEvent) {
    }

    @Override
    public void treeWillExpand(TreeExpansionEvent treeExpansionEvent) {
        CommNetBrowseTreeNode commNetBrowseTreeNode = (CommNetBrowseTreeNode)treeExpansionEvent.getPath().getLastPathComponent();
        commNetBrowseTreeNode.expand();
        ((DefaultTreeModel)this.tree.getTree().getModel()).reload(commNetBrowseTreeNode);
    }

    public CommNetBrowseTreeNode getSelectedNode() {
        return (CommNetBrowseTreeNode)this.tree.getSelectedNode();
    }

    public void setSelectedNode(CommNetBrowseTreeNode commNetBrowseTreeNode) {
        CommNetBrowseTreeNode commNetBrowseTreeNode2 = this.getSelectedNode();
        CommNetBrowseTreeNode commNetBrowseTreeNode3 = commNetBrowseTreeNode;
        commNetBrowseTreeNode2.addObserver(false);
        commNetBrowseTreeNode3.addObserver(true);
        this.table.setModel(commNetBrowseTreeNode3);
        this.fireTableModelChangedEvent();
        if (commNetBrowseTreeNode3.isHorizontalScrollRequired()) {
            this.table.getTable().setAutoResizeMode(0);
        } else {
            this.table.getTable().setAutoResizeMode(4);
        }
        ListSelectionModel listSelectionModel = this.table.getTable().getSelectionModel();
        listSelectionModel.clearSelection();
        Object[] objectArray = this.getPathToRootOnly(commNetBrowseTreeNode);
        TreePath treePath = new TreePath(objectArray);
        TreePath treePath2 = TreeUtils.getPathFromRoot((DefaultMutableTreeNode)this.getTree().getTree().getModel().getRoot(), treePath);
        this.tree.getTree().setSelectionPath(treePath2);
        treePath = null;
    }

    public TreeNode[] getPathToRootOnly(CommNetBrowseTreeNode commNetBrowseTreeNode) {
        TreeNode[] treeNodeArray = commNetBrowseTreeNode.getPath();
        int n = treeNodeArray.length;
        int n2 = 0;
        int n3 = 0;
        while (treeNodeArray[n3] != this.rootNode) {
            ++n2;
            ++n3;
        }
        TreeNode[] treeNodeArray2 = new TreeNode[n - n2];
        for (int i = n2; i < n; ++i) {
            treeNodeArray2[i - n2] = treeNodeArray[i];
        }
        return treeNodeArray2;
    }

    public void expandNode(CommNetBrowseTreeNode commNetBrowseTreeNode) {
        if (commNetBrowseTreeNode == this.getSelectedNode()) {
            return;
        }
        CommNetBrowseTreeNode commNetBrowseTreeNode2 = (CommNetBrowseTreeNode)commNetBrowseTreeNode.getParent();
        Object[] objectArray = this.getPathToRootOnly(commNetBrowseTreeNode2);
        TreePath treePath = new TreePath(objectArray);
        TreePath treePath2 = TreeUtils.getPathFromRoot((DefaultMutableTreeNode)this.getTree().getTree().getModel().getRoot(), treePath);
        this.getTree().getTree().expandPath(treePath2);
        treePath = null;
        this.setSelectedNode(commNetBrowseTreeNode);
        commNetBrowseTreeNode.selected();
    }

    public Refreshable getRefreshable() {
        CommNetBrowseTreeNode commNetBrowseTreeNode = this.getSelectedNode();
        if (commNetBrowseTreeNode instanceof Refreshable) {
            return (Refreshable)((Object)commNetBrowseTreeNode);
        }
        return null;
    }

    public synchronized void refresh() {
        TreePath treePath;
        int n;
        Refreshable refreshable = this.getRefreshable();
        CommNetBrowseTreeNode commNetBrowseTreeNode = null;
        String string = null;
        if (refreshable instanceof CommNetBrowseTreeNode) {
            commNetBrowseTreeNode = (CommNetBrowseTreeNode)((CommNetBrowseTreeNode)((Object)refreshable)).getParent();
            string = refreshable.toString();
        }
        boolean bl = false;
        if (commNetBrowseTreeNode != null && string != null) {
            for (n = 0; n < commNetBrowseTreeNode.getChildCount(); ++n) {
                if (!commNetBrowseTreeNode.getChildAt(n).toString().equals(string)) continue;
                treePath = new TreePath(((CommNetBrowseTreeNode)commNetBrowseTreeNode.getChildAt(n)).getPath());
                bl = this.getTree().getTree().isExpanded(treePath);
                break;
            }
        }
        if (refreshable != null) {
            refreshable.refresh(null);
        }
        if (commNetBrowseTreeNode != null && string != null) {
            for (n = 0; n < commNetBrowseTreeNode.getChildCount(); ++n) {
                if (!commNetBrowseTreeNode.getChildAt(n).toString().equals(string)) continue;
                treePath = new TreePath(((CommNetBrowseTreeNode)commNetBrowseTreeNode.getChildAt(n)).getPath());
                TreePath treePath2 = new TreePath(((CommNetBrowseTreeNode)this.getTree().getTree().getModel().getRoot()).getPath());
                Object[] objectArray = new Object[treePath.getPathCount() - treePath2.getPathCount() + 1];
                System.arraycopy(treePath.getPath(), treePath2.getPathCount() - 1, objectArray, 0, objectArray.length);
                TreePath treePath3 = new TreePath(objectArray);
                this.getTree().getTree().setSelectionPath(treePath3);
                if (!bl) break;
                this.getTree().getTree().expandPath(treePath3);
                break;
            }
        }
    }

    protected void fireTableModelChangedEvent() {
    }
}

