/*
 * Decompiled with CFR 0.152.
 */
package commvault.cte.component.dock;

import com.jidesoft.docking.DockableFrame;
import com.jidesoft.docking.event.DockableFrameAdapter;
import com.jidesoft.docking.event.DockableFrameEvent;
import com.jidesoft.docking.event.DockableFrameListener;
import com.jidesoft.pane.CollapsiblePanes;
import com.jidesoft.swing.JideButton;
import commvault.cte.component.CVFrame;
import commvault.cte.component.KeyHandler;
import commvault.cte.component.dock.AbstractFeature;
import commvault.cte.component.dock.Feature;
import commvault.cte.component.events.CTEAction;
import commvault.cte.component.explorer.Refreshable;
import commvault.cte.util.Application;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.KeyEvent;
import java.util.Map;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.border.Border;

public class FeatureFrame
extends DockableFrame
implements Refreshable,
KeyHandler {
    private Feature feature;
    private Feature.FeatureType type;
    private boolean pinned;
    private boolean docking;
    private JPanel buttonPanel = new JPanel(new FlowLayout(2, 0, 0));

    public FeatureFrame(Feature feature) {
        this(feature, false);
    }

    public FeatureFrame(Feature feature, boolean bl) {
        super((String)feature.getValue("Name"), (Icon)feature.getValue("Icon"));
        this.type = feature.getFeatureContext().getType();
        this.docking = bl;
        this.setFeature(feature);
        this.setInitMode(4);
        this.setAvailableButtons((this.getAvailableButtons() | 0x10) & 0xFFFFFFF7);
        this.addDockableFrameListener(Application.instance().getDockTasksListener());
        Action action = this.getCloseAction();
        this.setCloseAction(new CTEAction(action){

            @Override
            protected void performAction(ActionEvent actionEvent) {
                if (FeatureFrame.this.getFeature().featureClosing()) {
                    super.performAction(actionEvent);
                    FeatureFrame.this.getDockingManager().removeFrame(FeatureFrame.this.getKey());
                }
            }
        });
        this.setInitSide(this.type.getDockSide());
        this.setInitIndex(this.type.getIndex());
        this.setPinned(this.type.isPinned());
        this.addDockableFrameListener((DockableFrameListener)new DockableFrameAdapter(){

            public void dockableFrameAdded(DockableFrameEvent dockableFrameEvent) {
                FeatureFrame.this.showButtonPanel(false);
            }

            public void dockableFrameMaximized(DockableFrameEvent dockableFrameEvent) {
                CVFrame.getInstance().getWorkspace().lastFloatingWindowDimension = FeatureFrame.this.getSize();
            }

            public void dockableFrameRemoved(DockableFrameEvent dockableFrameEvent) {
                CVFrame.getInstance().getWorkspace().lastFloatingWindowDimension = FeatureFrame.this.getSize();
            }
        });
    }

    public Feature getFeature() {
        return this.feature;
    }

    public void setFeature(Feature feature) {
        this.feature = feature;
        this.getContentPane().removeAll();
        this.setFrameIcon((Icon)feature.getValue("Icon"));
        String string = (String)feature.getValue("Tab Title");
        if (string == null) {
            string = (String)feature.getValue("Title");
        }
        if (string == null) {
            string = (String)feature.getValue("Name");
        }
        this.setTitle(string);
        this.setTabTitle(string);
        this.updateTitle();
        this.getContentPane().setLayout(new BorderLayout());
        CollapsiblePanes collapsiblePanes = new CollapsiblePanes();
        collapsiblePanes.setBorder((Border)BorderFactory.createCompoundBorder(BorderFactory.createEtchedBorder(), BorderFactory.createEmptyBorder(1, 1, 1, 1)));
        Component component = feature.createFeatureUI();
        if (component != null) {
            this.getContentPane().add(component);
        }
        this.updateUI();
    }

    public void updateTitle() {
        if (this.docking) {
            this.setTitleBarComponent(this.getTitleBar(this.feature.createTitleBarUI()));
        } else {
            this.setTitleLabelComponent(this.getTitleBar(this.feature.createTitleBarUI()));
            this.setTitleBarComponent(null);
        }
    }

    private JPanel getTitleBar(JComponent jComponent) {
        JComponent jComponent2;
        JPanel jPanel = new JPanel(new BorderLayout());
        jPanel.setOpaque(false);
        this.buttonPanel.setOpaque(false);
        JideButton jideButton = new JideButton(CVFrame.instance().getWorkspace().popOutAction);
        jideButton.setText("");
        JideButton jideButton2 = new JideButton(CVFrame.instance().getWorkspace().maximizeAction);
        jideButton2.setText("");
        jideButton2.setOpaque(false);
        JideButton jideButton3 = new JideButton(CVFrame.instance().getWorkspace().minimizeAction);
        jideButton3.setText("");
        jideButton3.setOpaque(false);
        this.buttonPanel.add((Component)jideButton3);
        this.buttonPanel.add((Component)jideButton2);
        this.buttonPanel.add((Component)jideButton);
        if (jComponent != null) {
            jComponent.setOpaque(false);
            jPanel.add(jComponent);
        }
        if (this.feature instanceof AbstractFeature && (jComponent2 = ((AbstractFeature)this.feature).getTitleBarLink()) != null) {
            JPanel jPanel2 = new JPanel(new FlowLayout(0));
            jPanel2.setBorder(BorderFactory.createEmptyBorder());
            jPanel2.setOpaque(false);
            jPanel2.add(jComponent2);
            jPanel2.add(this.buttonPanel);
            jPanel.add((Component)jPanel2, "East");
            jPanel.setBorder(BorderFactory.createEmptyBorder());
            return jPanel;
        }
        jPanel.add((Component)this.buttonPanel, "East");
        return jPanel;
    }

    public Map<String, Action[]> getContextActionMap() {
        return this.feature.getActionGroups();
    }

    public void refresh() {
        this.feature.refresh();
    }

    public boolean isPinned() {
        return this.pinned;
    }

    public void setPinned(boolean bl) {
        this.pinned = bl;
    }

    @Override
    public void refresh(Object object) {
        this.refresh();
    }

    @Override
    public void handleKeyEvent(KeyEvent keyEvent) {
        if (this.feature instanceof KeyHandler) {
            ((KeyHandler)((Object)this.feature)).handleKeyEvent(keyEvent);
        }
    }

    public void showButtonPanel(boolean bl) {
        this.buttonPanel.setVisible(bl);
    }

    public boolean isDocking() {
        return this.docking;
    }

    public void setFeatureToNull() {
        this.feature = null;
    }

    public void setNotified(boolean bl) {
        super.setNotified(false);
    }
}

