/*
 * Decompiled with CFR 0.152.
 */
package commvault.cte.component.dialog;

import commvault.cte.CteStringBank;
import commvault.cte.component.CVFrame;
import commvault.cte.component.SaveFileFilter;
import commvault.cte.component.Utilities;
import commvault.cte.reports.components.ConversionType;
import commvault.cte.util.ReportUtilities;
import java.awt.Component;
import java.io.File;
import java.io.IOException;
import javax.swing.JFileChooser;
import javax.swing.filechooser.FileFilter;

public class ExportFileChooser
extends JFileChooser {
    private ConversionType conversionType = ConversionType.PDF;
    private static final String ILLEGAL_CHAR_PATTERN = "[\\\\/:*?<>|\\\"]";
    private static final String CHAR_TO_REPLACE = "_";
    private String fileName = "";
    private String directoryName = "";
    private boolean isOKSelected = false;
    private String extension = "";

    public ExportFileChooser(String string, String string2, ConversionType conversionType) {
        Object object;
        String string3 = CteStringBank.Export_Options.getI18n();
        if (conversionType != null) {
            object = conversionType.name();
            if (conversionType == ConversionType.EXCEL) {
                object = "Excel";
            }
            string3 = (String)object + " " + CteStringBank.Export_Options.getI18n();
            this.extension = conversionType.getFileExtension();
        }
        this.setDialogType(1);
        this.setDialogTitle(string3);
        this.setAcceptAllFileFilterUsed(false);
        if (string != null && string.length() != 0) {
            this.fileName = string.replaceAll(ILLEGAL_CHAR_PATTERN, CHAR_TO_REPLACE);
        }
        if (string2 != null) {
            this.directoryName = string2;
        } else if (ReportUtilities.getCurrentBrowseDirectory() != null && ReportUtilities.getCurrentBrowseDirectory().isDirectory()) {
            try {
                this.directoryName = ReportUtilities.getCurrentBrowseDirectory().getCanonicalPath();
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
        this.fileName = this.directoryName + (this.directoryName.endsWith(File.separator) ? "" : System.getProperty("file.separator")) + this.fileName;
        object = new SaveFileFilter(ConversionType.PDF.getFileExtension(), ConversionType.PDF.getDisplayName());
        SaveFileFilter saveFileFilter = new SaveFileFilter(ConversionType.MHTML.getFileExtension(), ConversionType.MHTML.getDisplayName());
        SaveFileFilter saveFileFilter2 = new SaveFileFilter(ConversionType.EXCEL.getFileExtension(), ConversionType.EXCEL.getDisplayName());
        this.setApproveButtonText(CteStringBank.OK.getI18n());
        this.setCurrentDirectory(ReportUtilities.getCurrentBrowseDirectory());
        switch (conversionType) {
            case PDF: {
                this.setFileFilter((FileFilter)object);
                break;
            }
            case MHTML: {
                this.setFileFilter(saveFileFilter);
                break;
            }
            case EXCEL: {
                this.setFileFilter(saveFileFilter2);
                break;
            }
            default: {
                this.setFileFilter((FileFilter)object);
            }
        }
        File file = new File(this.fileName);
        if (file != null) {
            this.setSelectedFile(file);
        }
        boolean bl = false;
        while (!bl && this.showDialog((Component)((Object)CVFrame.instance()), CteStringBank.OK.getI18n()) == 0) {
            File file2 = this.getSelectedFile();
            ReportUtilities.setCurrentBrowseDirectory(file2.getParentFile());
            this.directoryName = file2.getParentFile().getAbsolutePath();
            this.fileName = file2.getAbsolutePath();
            this.isOKSelected = true;
            if (file2.exists()) {
                if (Utilities.showYesNoMessage(this, CteStringBank.Do_you_want_to_overwrite_the_existing_file.getI18n(), "", 1) == 0) {
                    bl = true;
                    break;
                }
                this.isOKSelected = false;
                continue;
            }
            bl = true;
        }
    }

    public boolean isOKSelected() {
        return this.isOKSelected;
    }

    public String getFileName() {
        return this.fileName;
    }

    public String getFileExtension() {
        return this.extension;
    }
}

