/*
 * Decompiled with CFR 0.152.
 */
package commvault.cte.component.chart;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;

public class ChartLabelGenerator
implements Serializable {
    private double unit = 1.0;
    private int fractionalDigits = 1;

    public ChartLabelGenerator(int n) {
        this.fractionalDigits = n;
    }

    public void set(double d, int n) {
        this.unit = d;
        this.fractionalDigits = n;
    }

    public float getConvertedValue(double d) {
        float f = (float)(d / this.unit);
        return f;
    }

    public float getConvertedValue(double d, boolean bl) {
        if (bl) {
            return this.getConvertedValueValueInMB(d);
        }
        return this.getConvertedValue(d);
    }

    public float getConvertedValueValueInMB(double d) {
        float f = (float)(d / (this.unit / 1048576.0));
        return f;
    }

    public double getNumberSpacing(double d, int n) {
        d = n == 5 ? (d *= 0.2) : (n == 10 ? (d *= 0.1) : (d /= (double)n));
        if (this.fractionalDigits == 0) {
            double d2 = 0.0;
            if (d < 1.0) {
                d *= 10.0;
                d2 = d = (double)Math.round(d) / 10.0;
            } else {
                long l = 1L;
                while (d >= 10.0) {
                    d /= 10.0;
                    l *= 10L;
                }
                d2 = Math.round(d) * l;
            }
            if (d2 <= 1.0) {
                d2 = 1.0;
            }
            return d2;
        }
        if (d < 1.0) {
            d *= 10.0;
            d = (double)Math.round(d) / 10.0;
            return d;
        }
        long l = 1L;
        while (d >= 10.0) {
            d /= 10.0;
            l *= 10L;
        }
        return Math.round(d) * l;
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.writeDouble(this.unit);
        objectOutputStream.writeInt(this.fractionalDigits);
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        this.unit = objectInputStream.readDouble();
        this.fractionalDigits = objectInputStream.readInt();
    }
}

