/*
 * Decompiled with CFR 0.152.
 */
package commvault.cte.component.calender;

import commvault.cte.CteStringBank;
import java.text.SimpleDateFormat;
import java.util.GregorianCalendar;

public class TimeUtil {
    int m_inputSeconds = 0;
    int m_hours = 0;
    int m_minutes = 0;
    int m_seconds = 0;
    int m_days = 0;
    int m_secondsInMinutes = 60;
    int m_secondsInHour = 3600;
    int m_secondsInDay = 86400;
    SimpleDateFormat dateFormat = new SimpleDateFormat(CteStringBank.HH7mm7ss.getI18n());
    GregorianCalendar date = new GregorianCalendar();

    public TimeUtil(int n) {
        this.m_inputSeconds = n;
    }

    public String getFormatedString() {
        String string = "";
        this.calculateTime();
        if (this.m_days > 0) {
            String string2;
            String string3 = this.m_days == 1 ? CteStringBank._Day_.getI18n() : CteStringBank._Days_.getI18n();
            String string4 = this.m_minutes == 1 ? CteStringBank._Minute_.getI18n() : CteStringBank._Minutes_.getI18n();
            String string5 = this.m_hours == 1 ? CteStringBank._Hour_.getI18n() : " " + CteStringBank._Hours_.getI18n();
            String string6 = string2 = this.m_seconds == 1 ? CteStringBank._Second_.getI18n() : CteStringBank._Seconds.getI18n();
            string = this.m_hours > 0 ? "" + this.m_days + string3 + this.m_hours + string5 : (this.m_minutes > 0 ? "" + this.m_days + string3 + this.m_minutes + string4 : (this.m_seconds > 0 ? "" + this.m_days + string3 + this.m_seconds + string2 : "" + this.m_days + string3));
        } else {
            this.date.set(11, this.m_hours);
            this.date.set(12, this.m_minutes);
            this.date.set(13, this.m_seconds);
            string = this.dateFormat.format(this.date.getTime());
        }
        return string;
    }

    public static void main(String[] stringArray) {
        Integer n = new Integer(stringArray[0]);
        TimeUtil timeUtil = new TimeUtil(n);
        timeUtil.getFormatedString();
    }

    public void calculateTime() {
        if (this.m_inputSeconds >= this.m_secondsInDay) {
            int n = 0;
            this.m_days = this.getDays(this.m_inputSeconds);
            n = this.m_inputSeconds - this.m_days * this.m_secondsInDay;
            if (n >= this.m_secondsInHour) {
                this.m_hours = this.getHours(n);
            } else if (n >= this.m_secondsInMinutes && n < this.m_secondsInHour) {
                this.m_minutes = this.getMinutes(n);
            } else {
                this.m_seconds = n;
            }
        } else {
            int n = 0;
            this.m_hours = this.getHours(this.m_inputSeconds);
            n = this.m_inputSeconds - this.m_hours * this.m_secondsInHour;
            this.m_minutes = this.getMinutes(n);
            this.m_seconds = n -= this.m_minutes * this.m_secondsInMinutes;
        }
    }

    private int getMinutes(int n) {
        return n / this.m_secondsInMinutes;
    }

    private int getHours(int n) {
        return n / this.m_secondsInHour;
    }

    private int getDays(int n) {
        return n / this.m_secondsInDay;
    }

    public int getSec() {
        return this.m_seconds;
    }

    public int getMin() {
        return this.m_minutes;
    }

    public int getHrs() {
        return this.m_hours;
    }

    public int getDys() {
        return this.m_days;
    }
}

