/*
 * Decompiled with CFR 0.152.
 */
package commvault.cte.component.calender;

import commvault.cte.CteStringBank;
import commvault.cte.component.calender.ChangeTimeZoneInterface;
import commvault.cte.component.calender.HourChooser;
import commvault.cte.component.calender.JDateChooser;
import commvault.cte.component.events.TimeListener;
import commvault.cte.util.Application;
import commvault.cte.util.DateUtilities;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Locale;
import java.util.TimeZone;
import java.util.Vector;
import javax.swing.JFormattedTextField;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.event.EventListenerList;

public class TimeChooser
extends JPanel
implements ActionListener,
TimeListener,
ChangeTimeZoneInterface {
    GregorianCalendar gregorianCalendar;
    HourChooser hourChooser;
    JSeparator jSeparator;
    public static final int X_AXIS = 0;
    public static final int Y_AXIS = 1;
    public static final int Z_AXIS = 2;
    EventListenerList listenerList = new EventListenerList();
    ActionEvent actionEvent = null;
    Vector listeners = new Vector();
    JDateChooser datePicker;

    public void addTimeListener(TimeListener timeListener) {
        if (timeListener != null) {
            this.listeners.addElement(timeListener);
        }
    }

    @Override
    public void setTimeZone(TimeZone timeZone) {
        int n = this.getUnixTime();
        GregorianCalendar gregorianCalendar = new GregorianCalendar(timeZone);
        this.setTime(gregorianCalendar);
        this.setTime(n);
    }

    @Override
    public void timeChanged(Calendar calendar) {
        for (int i = 0; i < this.listeners.size(); ++i) {
            ((TimeListener)this.listeners.elementAt(i)).timeChanged(this.gregorianCalendar);
        }
    }

    public void addActionListener(ActionListener actionListener) {
        this.listenerList.add(ActionListener.class, actionListener);
    }

    public void removeActionListener(ActionListener actionListener) {
        this.listenerList.remove(ActionListener.class, actionListener);
    }

    protected void fireActionPerformed() {
        Object[] objectArray = this.listenerList.getListenerList();
        for (int i = objectArray.length - 2; i >= 0; i -= 2) {
            if (objectArray[i] != ActionListener.class) continue;
            if (this.actionEvent == null) {
                this.actionEvent = new ActionEvent(this, 0, CteStringBank.Time_Changed.getI18n());
            }
            ((ActionListener)objectArray[i + 1]).actionPerformed(this.actionEvent);
        }
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        this.fireActionPerformed();
    }

    public TimeChooser(GregorianCalendar gregorianCalendar, int n) {
        this(gregorianCalendar, n, false);
    }

    public TimeChooser(GregorianCalendar gregorianCalendar, int n, boolean bl) {
        this.gregorianCalendar = gregorianCalendar;
        if (!bl) {
            this.gregorianCalendar.set(13, 0);
        }
        this.datePicker = new JDateChooser(this.gregorianCalendar.getTime());
        JFormattedTextField jFormattedTextField = this.datePicker.getEditor();
        jFormattedTextField.setColumns(20);
        this.datePicker.putClientProperty("editor", jFormattedTextField);
        this.hourChooser = new HourChooser(this.gregorianCalendar, bl);
        this.hourChooser.addActionListener(this);
        this.datePicker.addActionListener(this);
        this.hourChooser.addTimeListener(this);
        if (n == 0) {
            int n2;
            this.setLayout(new FlowLayout(0, 2, 0));
            this.add((Component)((Object)this.datePicker));
            this.add((Component)this.hourChooser, "East");
            int n3 = n2 = this.hourChooser.getFont() == null ? 20 : this.hourChooser.getFont().getSize();
            int n4 = n2 == 0 ? 20 : (n2 > 14 && n2 <= 15 ? 22 : (n2 >= 12 && n2 <= 14 ? 20 : 20));
            this.datePicker.setPreferredSize(new Dimension(180, n4));
            this.hourChooser.setPreferredSize(new Dimension(180, n4));
        } else if (n == 2) {
            this.setLayout(new BorderLayout(2, 2));
            this.add((Component)((Object)this.datePicker));
            this.add((Component)this.hourChooser, "East");
        } else if (n == 1) {
            int n5;
            this.setLayout(new GridBagLayout());
            this.add((Component)((Object)this.datePicker), new GridBagConstraints(0, 0, 4, 1, 1.0, 0.1, 10, 1, new Insets(0, 3, 3, 3), 0, 0));
            this.add((Component)this.hourChooser, new GridBagConstraints(0, 1, 4, 1, 1.0, 0.1, 10, 1, new Insets(3, 3, 0, 3), 0, 0));
            int n6 = n5 = this.hourChooser.getFont() == null ? 20 : this.hourChooser.getFont().getSize();
            int n7 = n5 == 0 ? 20 : (n5 > 14 && n5 <= 15 ? 22 : (n5 >= 12 && n5 <= 14 ? 20 : 20));
            this.datePicker.setPreferredSize(new Dimension(180, n7));
            this.hourChooser.setPreferredSize(new Dimension(180, n7));
            this.add((Component)new JLabel(), new GridBagConstraints(0, 2, 4, 0, 1.0, 2.1, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
        } else {
            this.setLayout(new BorderLayout(2, 2));
            this.add((Component)((Object)this.datePicker));
        }
        this.datePicker.getEditor().addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent focusEvent) {
                try {
                    TimeChooser.this.datePicker.commitEdit();
                }
                catch (ParseException parseException) {
                    parseException.printStackTrace();
                }
                TimeChooser.this.firePropertyChange("unixTime", 0, TimeChooser.this.getUnixTime());
            }
        });
        this.datePicker.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                TimeChooser.this.firePropertyChange("unixTime", 0, TimeChooser.this.getUnixTime());
            }
        });
        this.hourChooser.addTimeListener(new TimeListener(){

            @Override
            public void timeChanged(Calendar calendar) {
                TimeChooser.this.firePropertyChange("unixTime", 0, TimeChooser.this.getUnixTime());
            }
        });
    }

    public TimeChooser(GregorianCalendar gregorianCalendar) {
        this(gregorianCalendar, 0);
    }

    public TimeChooser(int n) {
        this(new GregorianCalendar(), n);
    }

    public TimeChooser() {
        this(false);
    }

    public TimeChooser(boolean bl) {
        this(new GregorianCalendar(), 0, bl);
    }

    public GregorianCalendar getTime() {
        Date date = this.datePicker.getDate();
        if (date == null) {
            date = new Date();
        }
        GregorianCalendar gregorianCalendar = new GregorianCalendar();
        gregorianCalendar.setTime(date);
        this.gregorianCalendar.set(1, gregorianCalendar.get(1));
        this.gregorianCalendar.set(2, gregorianCalendar.get(2));
        this.gregorianCalendar.set(5, gregorianCalendar.get(5));
        this.hourChooser.getUserInputTime2();
        return this.gregorianCalendar;
    }

    public int getUnixTime() {
        return (int)(this.getTime().getTime().getTime() / 1000L);
    }

    public long getUnixTimeLong() {
        return this.getTime().getTime().getTime() / 1000L;
    }

    public int getUnixTimeSetToZero() {
        Date date = new Date((long)this.getUnixTime() * 1000L);
        GregorianCalendar gregorianCalendar = new GregorianCalendar();
        gregorianCalendar.setTimeZone(Application.commServerTimeZone);
        gregorianCalendar.setTime(date);
        gregorianCalendar.set(11, 0);
        gregorianCalendar.set(12, 0);
        gregorianCalendar.set(13, 0);
        gregorianCalendar.set(14, 0);
        return (int)(gregorianCalendar.getTime().getTime() / 1000L);
    }

    public int getReportsUnixTime() {
        return (int)(this.getTime().getTime().getTime() / 1000L);
    }

    public GregorianCalendar getReportsGetTime() {
        this.gregorianCalendar.setTimeInMillis(this.datePicker.getDate().getTime());
        this.hourChooser.getUserInputTime2();
        return this.gregorianCalendar;
    }

    public void setTime(GregorianCalendar gregorianCalendar) {
        this.gregorianCalendar = gregorianCalendar;
        this.hourChooser.setTime(gregorianCalendar);
        GregorianCalendar gregorianCalendar2 = new GregorianCalendar(gregorianCalendar.get(1), gregorianCalendar.get(2), gregorianCalendar.get(5));
        Date date = gregorianCalendar2.getTime();
        this.datePicker.setDate(date);
    }

    public void setTime(int n) {
        this.setTime((long)n);
    }

    public void setTime(long l) {
        int n = this.getUnixTime();
        long l2 = l * 1000L;
        if (l == 0L) {
            l2 = System.currentTimeMillis();
        }
        if (l < 0L) {
            l2 += System.currentTimeMillis();
        }
        Date date = new Date(l2);
        GregorianCalendar gregorianCalendar = new GregorianCalendar(this.gregorianCalendar.getTimeZone());
        gregorianCalendar.setTime(date);
        this.setTime(gregorianCalendar);
        this.firePropertyChange("unixTime", (long)n, l);
    }

    public void setTimeForSchedule(int n) {
        long l = (long)n * 1000L;
        if (n == 0) {
            l = System.currentTimeMillis();
        }
        if (n < 0) {
            l += System.currentTimeMillis();
        }
        TimeZone timeZone = TimeZone.getDefault();
        long l2 = timeZone.getOffset(l);
        Date date = new Date(l - l2);
        this.setUnixTime((int)(date.getTime() / 1000L));
    }

    public void setTimeForScheduleWithoutTimeZoneOffset(int n) {
        long l = (long)n * 1000L;
        if (n == 0) {
            l = System.currentTimeMillis();
        }
        if (n < 0) {
            l += System.currentTimeMillis();
        }
        Date date = new Date(l);
        this.setUnixTime((int)(date.getTime() / 1000L));
    }

    public void setUnixTime(int n) {
        int n2 = this.getUnixTime();
        this.setTime(n);
        this.firePropertyChange("unixTime", n2, n);
    }

    private final void setChildState(Container container, boolean bl) {
        if (container == null) {
            return;
        }
        Component[] componentArray = container.getComponents();
        for (int i = componentArray.length - 1; i >= 0; --i) {
            if (componentArray[i] instanceof Container) {
                this.setChildState((Container)componentArray[i], bl);
            }
            componentArray[i].setEnabled(bl);
        }
        container.setEnabled(bl);
    }

    @Override
    public void setEnabled(boolean bl) {
        Component[] componentArray = this.getComponents();
        for (int i = componentArray.length - 1; i >= 0; --i) {
            if (componentArray[i] instanceof JDateChooser) continue;
            if (componentArray[i] instanceof Container) {
                this.setChildState((Container)componentArray[i], bl);
            }
            componentArray[i].setEnabled(bl);
        }
        this.datePicker.setEnabled(bl);
    }

    @Override
    public boolean isEnabled() {
        return this.datePicker.isEnabled();
    }

    public static String formatUnixTimeInHourByApplyingCommserveTimeZone(int n) {
        if (n == 0) {
            return CteStringBank.Unavailable.getI18n();
        }
        long l = n;
        Date date = new Date(l *= 1000L);
        DateFormat dateFormat = DateFormat.getDateTimeInstance(3, 3);
        dateFormat.setTimeZone(Application.commServerTimeZone);
        String string = dateFormat.format(date);
        return string;
    }

    public static String formatUnixTimeInHour(int n) {
        if (n == 0) {
            return CteStringBank.Unavailable.getI18n();
        }
        if (DateUtilities.useUserDateFormat) {
            return DateUtilities.instance().getUserSpecificDateAndTimeFormat(n);
        }
        long l = n;
        Date date = new Date(l *= 1000L);
        DateFormat dateFormat = DateFormat.getDateTimeInstance(3, 3);
        dateFormat.setTimeZone(Application.commServerTimeZone);
        String string = dateFormat.format(date);
        return string;
    }

    public static String formatUnixTimeInHour(int n, TimeZone timeZone) {
        if (n == 0) {
            return CteStringBank.Unavailable.getI18n();
        }
        if (DateUtilities.useUserDateFormat && timeZone == null) {
            return DateUtilities.instance().getUserSpecificDateAndTimeFormat(n);
        }
        DateUtilities.instance();
        return DateUtilities.getFormattedDate(n, DateUtilities.instance().getUserSpecificLongDateAndTimeFormat(), timeZone);
    }

    public static String formatUnixTime(int n) {
        if (n == 0) {
            return CteStringBank.Unavailable.getI18n();
        }
        if (DateUtilities.useUserDateFormat) {
            return DateUtilities.instance().getUserSpecificLongDateFormat(n);
        }
        long l = n;
        Date date = new Date(l *= 1000L);
        DateFormat dateFormat = DateFormat.getDateInstance(0);
        dateFormat.setTimeZone(Application.commServerTimeZone);
        String string = dateFormat.format(date);
        return string;
    }

    public static String formatUnixTimeToSecond(int n, TimeZone timeZone) {
        if (n == 0) {
            return CteStringBank.Unavailable.getI18n();
        }
        if (DateUtilities.useUserDateFormat) {
            return DateUtilities.instance().getUserSpecificLongDateFormat(n);
        }
        long l = n;
        Date date = new Date(l *= 1000L);
        DateFormat dateFormat = DateFormat.getDateTimeInstance(0, 2);
        if (timeZone != null) {
            dateFormat.setTimeZone(timeZone);
        } else {
            dateFormat.setTimeZone(Application.commServerTimeZone);
        }
        String string = dateFormat.format(date);
        return string;
    }

    public static String formatUnixTime(int n, String string) {
        return TimeChooser.formatUnixTime((long)n, string);
    }

    public static String formatUnixTime(long l, String string) {
        if (l == 0L) {
            return CteStringBank.Unavailable.getI18n();
        }
        long l2 = l;
        Date date = new Date(l2 *= 1000L);
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat(string, Locale.getDefault());
        simpleDateFormat.setTimeZone(Application.commServerTimeZone);
        String string2 = simpleDateFormat.format(date);
        return string2;
    }

    public static String formatUnixTimeToSecond(long l) {
        if (l == 0L) {
            return CteStringBank.Unavailable.getI18n();
        }
        Date date = new Date(l);
        DateFormat dateFormat = DateFormat.getDateTimeInstance(0, 2);
        dateFormat.setTimeZone(Application.commServerTimeZone);
        String string = dateFormat.format(date);
        return string;
    }

    public static String formatUnixTimeToSecond(int n) {
        if (n == 0) {
            return CteStringBank.Unavailable.getI18n();
        }
        long l = n;
        return TimeChooser.formatUnixTimeToSecond(l *= 1000L);
    }

    @Override
    public void requestFocus() {
        this.datePicker.requestFocus();
    }

    public void setForceDirectionAdjustment(boolean bl) {
    }

    public boolean getForceDirectionAdjustment() {
        return false;
    }

    public int getCommserverUnixTime() {
        this.hourChooser.getUserInputTime2();
        GregorianCalendar gregorianCalendar = (GregorianCalendar)this.gregorianCalendar.clone();
        gregorianCalendar.setTimeZone(Application.commServerTimeZone);
        return (int)(gregorianCalendar.getTime().getTime() / 1000L);
    }

    public int getOnlyDateTime() {
        GregorianCalendar gregorianCalendar = this.getTime();
        GregorianCalendar gregorianCalendar2 = new GregorianCalendar(gregorianCalendar.get(1), gregorianCalendar.get(2), gregorianCalendar.get(5), 0, 0, 0);
        gregorianCalendar2.setTimeZone(TimeZone.getTimeZone("UTC"));
        return (int)(gregorianCalendar2.getTimeInMillis() / 1000L);
    }

    public int getOnlyTime() {
        GregorianCalendar gregorianCalendar = this.getTime();
        long l = gregorianCalendar.getTime().getTime();
        gregorianCalendar.set(11, 0);
        gregorianCalendar.set(12, 0);
        return (int)((l - gregorianCalendar.getTime().getTime()) / 1000L);
    }

    public void showHours(boolean bl) {
        this.hourChooser.setVisible(bl);
    }

    public void setPreferredSize(Dimension dimension, Dimension dimension2) {
        this.datePicker.setPreferredSize(dimension);
        this.hourChooser.setPreferredSize(dimension2);
    }

    public void setPreferredSize(Dimension dimension, Dimension dimension2, int n) {
        this.datePicker.setPreferredPopupButtonWidth(n);
        this.datePicker.setPreferredSize(dimension);
        this.hourChooser.setPreferredSize(dimension2);
    }

    public static String formatUnixTimeInHourRoundUp(int n) {
        if (n == 0) {
            return CteStringBank.Unavailable.getI18n();
        }
        if (DateUtilities.useUserDateFormat) {
            return DateUtilities.instance().getUserSpecificDateAndTimeFormatRoundUp(n);
        }
        long l = n;
        Date date = new Date(l *= 1000L);
        DateFormat dateFormat = DateFormat.getDateTimeInstance(3, 3);
        dateFormat.setTimeZone(Application.commServerTimeZone);
        String string = dateFormat.format(DateUtilities.toNearestWholeMinute(date));
        return string;
    }

    public static String formatUnixTimeInHourRoundUp(int n, TimeZone timeZone) {
        if (n == 0) {
            return CteStringBank.Unavailable.getI18n();
        }
        if (DateUtilities.useUserDateFormat && timeZone == null) {
            return DateUtilities.instance().getUserSpecificDateAndTimeFormatRoundUp(n);
        }
        DateUtilities.instance();
        return DateUtilities.getFormattedDateRoundUp(n, DateUtilities.instance().getUserSpecificLongDateAndTimeFormat(), timeZone);
    }

    public static String formatUnixTimeInHourByApplyingCommserveTimeZoneRoundUp(int n) {
        if (n == 0) {
            return CteStringBank.Unavailable.getI18n();
        }
        long l = n;
        Date date = new Date(l *= 1000L);
        DateFormat dateFormat = DateFormat.getDateTimeInstance(3, 3);
        dateFormat.setTimeZone(Application.commServerTimeZone);
        String string = dateFormat.format(DateUtilities.toNearestWholeMinute(date));
        return string;
    }
}

