/*
 * Decompiled with CFR 0.152.
 */
package commvault.cte.component.calender;

import com.jidesoft.grid.TableUtils;
import com.jidesoft.plaf.UIDefaultsLookup;
import com.jidesoft.plaf.basic.ThemePainter;
import com.jidesoft.popup.JidePopup;
import com.jidesoft.popup.JidePopupFactory;
import com.jidesoft.swing.DefaultOverlayable;
import com.jidesoft.swing.JideScrollPane;
import com.jidesoft.swing.OverlayableUtils;
import commvault.cte.component.Utilities;
import commvault.cte.component.calender.CalNavigationPanel;
import commvault.cte.component.calender.CalendarUtil;
import commvault.cte.component.calender.CalendarView;
import commvault.cte.component.calender.CalendarViewModel;
import commvault.cte.component.calender.RowHeaderRenderer;
import commvault.cte.util.Application;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Date;
import java.util.EventObject;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JToolTip;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.ToolTipManager;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableCellRenderer;

public abstract class CalView
extends CalNavigationPanel {
    protected JTable table;
    protected JideScrollPane scroll;
    protected JTable label;
    JToolTip tip = null;
    ProcessingThread t = new ProcessingThread();
    private Date[] dateRange = new Date[2];

    public CalView(CalendarViewModel calendarViewModel, CalendarView calendarView) {
        super(calendarView);
        this.table = new JTable(calendarViewModel){
            JidePopup popup;
            {
                this.popup = JidePopupFactory.getSharedInstance().createPopup();
            }

            @Override
            protected void resizeAndRepaint() {
                super.resizeAndRepaint();
                if (CalView.this.label != null) {
                    CalView.this.label.revalidate();
                    CalView.this.label.repaint();
                }
            }

            @Override
            public boolean editCellAt(int n, int n2, EventObject eventObject) {
                boolean bl = super.editCellAt(n, n2, eventObject);
                CalView.this.handleTableEdit(n, n2, eventObject);
                return bl;
            }

            @Override
            protected void processKeyEvent(KeyEvent keyEvent) {
                if (keyEvent.getKeyCode() == 113 && keyEvent.getID() == 401) {
                    keyEvent.consume();
                    int n = this.getSelectedColumn();
                    int n2 = this.getSelectedRow();
                    if (n2 < 0) {
                        return;
                    }
                    if (this.popup != null && this.popup.isVisible()) {
                        this.popup.hidePopup();
                    }
                    Rectangle rectangle = this.getCellRect(n2, n, false);
                    int n3 = ToolTipManager.sharedInstance().getInitialDelay();
                    ToolTipManager.sharedInstance().setInitialDelay(0);
                    ToolTipManager.sharedInstance().mouseMoved(new MouseEvent(this, 0, 0L, 0, rectangle.x + rectangle.width / 2, rectangle.y + rectangle.height / 2, 0, false));
                    try {
                        if (CalView.this.tip != null && CalView.this.tip.isVisible()) {
                            CalView.this.tip.getMouseListeners()[0].mouseEntered(null);
                        }
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                    }
                    ToolTipManager.sharedInstance().setInitialDelay(n3);
                    return;
                }
                super.processKeyEvent(keyEvent);
            }

            @Override
            public JToolTip createToolTip() {
                CalView.this.tip = new JToolTip();
                if (this.popup != null && this.popup.isVisible()) {
                    this.popup.hidePopup();
                }
                CalView.this.tip.addMouseListener(new MouseFocusListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent actionEvent) {
                        Point point = CalView.this.tip.getLocationOnScreen();
                        int n = 0;
                        int n2 = 0;
                        if (popup != null) {
                            n = popup.getHeight();
                            n2 = popup.getWidth();
                        }
                        if (popup != null && popup.isVisible()) {
                            popup.hidePopup();
                        }
                        popup = new JidePopup();
                        popup.setDetached(true);
                        popup.setMovable(false);
                        popup.setResizable(true);
                        popup.setRequestFocusEnabled(true);
                        Rectangle rectangle = CalView.this.tip.getBounds();
                        String string = CalView.this.tip.getTipText();
                        string = string.replaceFirst("<!--hide", "");
                        string = string.replaceFirst("hide-->", "");
                        int n3 = string.lastIndexOf("</table>");
                        if (n3 > 0) {
                            string = string.substring(0, n3) + "</table></body></html>";
                        }
                        JScrollPane jScrollPane = new JScrollPane(new JLabel(string), 22, 32);
                        jScrollPane.setBackground(CalView.this.tip.getBackground());
                        jScrollPane.getViewport().setBackground(CalView.this.tip.getBackground());
                        jScrollPane.getViewport().getView().setBackground(CalView.this.tip.getBackground());
                        if (popup.isVisible()) {
                            popup.hidePopup();
                        }
                        Dimension dimension = rectangle.getSize();
                        dimension.width = Math.max(rectangle.width + 10, n2);
                        dimension.height = Math.max(rectangle.height, n);
                        jScrollPane.setPreferredSize(dimension);
                        popup.getContentPane().removeAll();
                        popup.getContentPane().add(jScrollPane);
                        CalView.this.tip.setVisible(false);
                        popup.showPopup(point.x, point.y);
                    }
                }));
                CalView.this.tip.setComponent(this);
                return CalView.this.tip;
            }
        };
        this.table.setRowSelectionAllowed(true);
        this.table.setColumnSelectionAllowed(true);
        this.table.getSelectionModel().setSelectionMode(0);
        this.table.getColumnModel().getSelectionModel().setSelectionMode(0);
        this.table.getTableHeader().setResizingAllowed(false);
        this.table.getTableHeader().setReorderingAllowed(false);
        this.table.setShowGrid(true);
        ThemePainter themePainter = (ThemePainter)UIDefaultsLookup.get((Object)"Theme.painter");
        this.table.getTableHeader().setBackground(themePainter.getControlLt());
        this.table.setGridColor(themePainter.getBackgroundDk());
        final TableCellRenderer tableCellRenderer = this.table.getTableHeader().getDefaultRenderer();
        this.table.getTableHeader().setDefaultRenderer(new TableCellRenderer(){

            @Override
            public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
                Component component = tableCellRenderer.getTableCellRendererComponent(jTable, object, bl, bl2, n, n2);
                ThemePainter themePainter = (ThemePainter)UIDefaultsLookup.get((Object)"Theme.painter");
                component.setBackground(themePainter.getControlLt());
                jTable.setGridColor(themePainter.getBackgroundDk());
                return component;
            }
        });
        this.scroll = new JideScrollPane((Component)this.table, 22, 31);
        this.label = this.createRowLabel(this.table, calendarViewModel);
        this.scroll.setRowHeaderView((Component)this.label);
        this.scroll.setOpaque(false);
        DefaultOverlayable defaultOverlayable = new DefaultOverlayable((JComponent)this.scroll);
        defaultOverlayable.addOverlayComponent((JComponent)new JLabel(Application.instance().getIconSource().getIcon("Progress-Blue")));
        defaultOverlayable.setOverlayVisible(true);
        this.add((Component)defaultOverlayable);
    }

    protected void handleTableEdit(int n, int n2, EventObject eventObject) {
    }

    @Override
    public Date getFocusTime() {
        if (this.table.getSelectedRow() < 0) {
            this.table.setColumnSelectionInterval(this.table.getColumnCount() / 2, this.table.getColumnCount() / 2);
            this.table.setRowSelectionInterval(this.table.getRowCount() / 2, this.table.getRowCount() / 2);
        }
        return (Date)this.table.getValueAt(this.table.getSelectedRow(), this.table.getSelectedColumn());
    }

    protected Date getToTime() {
        Date date = (Date)this.table.getValueAt(this.table.getRowCount(), this.table.getColumnCount() - 1);
        return new Date(date.getTime() + (long)this.getModel().getCellTimeWidth() * 1000L);
    }

    protected Date getFromTime() {
        return (Date)this.table.getValueAt(0, 0);
    }

    protected JTable createRowLabel(final JTable jTable, final CalendarViewModel calendarViewModel) {
        JTable jTable2 = new JTable(new AbstractTableModel(){

            @Override
            public int getColumnCount() {
                return 1;
            }

            @Override
            public Object getValueAt(int n, int n2) {
                return calendarViewModel.getValueAt(n, 0);
            }

            @Override
            public int getRowCount() {
                return calendarViewModel.getRowCount();
            }
        }){

            @Override
            public int getRowHeight() {
                int n = jTable.getRowHeight();
                if (CalView.this.outlookView.getCalType() != CalendarViewModel.CalendarType.MONTHLY) {
                    return 2 * n;
                }
                return n;
            }

            @Override
            public int getRowHeight(int n) {
                int n2 = jTable.getRowHeight(n);
                if (CalView.this.outlookView.getCalType() != CalendarViewModel.CalendarType.MONTHLY) {
                    return 2 * n2;
                }
                return n2;
            }
        };
        RowHeaderRenderer rowHeaderRenderer = new RowHeaderRenderer(calendarViewModel.getCalType());
        jTable2.setDefaultRenderer(Object.class, rowHeaderRenderer);
        jTable2.setDefaultEditor(Object.class, rowHeaderRenderer);
        return jTable2;
    }

    protected CalendarViewModel getModel() {
        return (CalendarViewModel)this.table.getModel();
    }

    protected abstract Date createStartTime(Date var1);

    protected abstract void loadData(Date var1, Date var2) throws Exception;

    @Override
    public void setFocusTime(Date date) {
        this.getModel().setStartTime(this.createStartTime(date));
        int n = this.getModel().getCellIndex(CalendarUtil.getStartDayOfMonth(date).getTime());
        int n2 = n / this.getModel().getColumnCount();
        int n3 = n % this.getModel().getColumnCount();
        Rectangle rectangle = this.table.getCellRect(n2, n3, false);
        n = this.getModel().getCellIndex(CalendarUtil.getEndTimeOfNextMonth(date).getTime()) - 1;
        n2 = n / this.getModel().getColumnCount();
        n3 = n % this.getModel().getColumnCount();
        Rectangle rectangle2 = this.table.getCellRect(n2, n3, false);
        rectangle.height = rectangle2.height + rectangle2.y - rectangle.y;
        this.table.scrollRectToVisible(rectangle);
        n = this.getModel().getCellIndex(date) + 1;
        n2 = n / this.getModel().getColumnCount();
        n3 = n % this.getModel().getColumnCount();
        this.table.setRowSelectionInterval(n2, n2);
        this.table.setColumnSelectionInterval(n3, n3);
        this.ensureTasksLoaded();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void ensureTasksLoaded() {
        Date[] dateArray = this.dateRange;
        synchronized (this.dateRange) {
            this.dateRange[0] = this.getFromTime();
            this.dateRange[1] = this.getToTime();
            if (this.t.getState() == Thread.State.NEW) {
                this.t.start();
            }
            this.dateRange.notify();
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    protected void makeGlasspaneInvisible() {
        OverlayableUtils.getOverlayable((JComponent)this.scroll).setOverlayVisible(false);
    }

    protected void makeGlasspaneVisible() {
        OverlayableUtils.getOverlayable((JComponent)this.scroll).setOverlayVisible(true);
    }

    @Override
    public void applyFilter() {
        this.getModel().fireTableDataChanged();
    }

    private static class MouseFocusListener
    extends MouseAdapter {
        Timer t = null;
        ActionListener listener = null;

        public MouseFocusListener(ActionListener actionListener) {
            this.listener = actionListener;
        }

        @Override
        public void mouseEntered(MouseEvent mouseEvent) {
            if (this.t == null) {
                this.t = new Timer(750, this.listener);
            }
            this.t.start();
        }

        @Override
        public void mouseExited(MouseEvent mouseEvent) {
            if (this.t != null) {
                this.t.stop();
            }
            this.t = null;
        }
    }

    class ProcessingThread
    extends Thread {
        ProcessingThread() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            boolean bl = false;
            while (!bl) {
                try {
                    Object object = CalView.this.dateRange;
                    synchronized (object) {
                        CalView.this.dateRange.wait(1000L);
                    }
                    CalView.this.makeGlasspaneVisible();
                    object = CalView.this.dateRange[0];
                    Date date = CalView.this.dateRange[1];
                    CalView.this.loadData(CalView.this.dateRange[0], CalView.this.dateRange[1]);
                    Date[] dateArray = CalView.this.dateRange;
                    synchronized (dateArray) {
                        if (object == CalView.this.dateRange[0] && date == CalView.this.dateRange[1]) {
                            ((CalView)CalView.this).dateRange[0] = null;
                            ((CalView)CalView.this).dateRange[1] = null;
                            CalView.this.t = new ProcessingThread();
                            bl = true;
                        }
                    }
                }
                catch (Exception exception) {
                    try {
                        SwingUtilities.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                exception.printStackTrace();
                                Utilities.showErrorMessage(exception.getMessage() == null ? "null" : exception.getMessage());
                            }
                        });
                    }
                    catch (Throwable throwable) {
                        SwingUtilities.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                int[] nArray = TableUtils.saveSelection((JTable)CalView.this.table);
                                CalView.this.getModel().fireTableDataChanged();
                                TableUtils.loadSelection((JTable)CalView.this.table, (int[])nArray);
                                CalView.this.makeGlasspaneInvisible();
                                CalView.this.setDataLoaded();
                            }
                        });
                        throw throwable;
                    }
                    SwingUtilities.invokeLater(new /* invalid duplicate definition of identical inner class */);
                    continue;
                }
                SwingUtilities.invokeLater(new /* invalid duplicate definition of identical inner class */);
            }
        }
    }
}

