/*
 * Decompiled with CFR 0.152.
 */
package commvault.cte.component;

import commvault.cte.CteStringBank;
import commvault.cte.common.xml.UI;
import commvault.cte.component.CVFrame;
import commvault.cte.component.HelpErrorPanel;
import commvault.cte.component.LayoutUtils;
import commvault.cte.component.MailParamsDialog;
import commvault.cte.component.PropertyDialog;
import commvault.cte.component.UIConstants;
import commvault.cte.component.table.TableUtils;
import commvault.cte.util.Application;
import commvault.cte.util.DateUtilities;
import commvault.cte.util.Logger;
import commvault.cte.util.ResourceBundleManager;
import commvault.cte.util.RuntimeContext;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Frame;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.FileFilter;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.PrintWriter;
import java.io.Serializable;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.net.URL;
import java.text.StringCharacterIterator;
import java.util.Calendar;
import java.util.Date;
import java.util.Enumeration;
import java.util.Locale;
import java.util.ResourceBundle;
import java.util.TimeZone;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JMenuBar;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.JTree;
import javax.swing.LayoutFocusTraversalPolicy;
import javax.swing.RootPaneContainer;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.plaf.FontUIResource;
import javax.swing.plaf.basic.BasicOptionPaneUI;
import javax.swing.plaf.metal.MetalMenuBarUI;
import javax.swing.table.TableModel;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;

public class Utilities
extends LayoutUtils {
    static Boolean RTM_FLAG = null;
    public static ResourceBundleManager bundleMgr = new ResourceBundleManager("cte_interactive_ui");
    public static final Dimension STANDARD_BUTTON_DIMENSION = new Dimension(80, 24);
    public static int userDefinedFont = 0;
    public static final Cursor WAIT_CURSOR = new Cursor(3);
    private static final JLabel fontMetricsLabel = new JLabel();
    private static final StringBuffer fontMetricsBuffer = new StringBuffer();
    static final String LF = System.getProperty("line.separator");

    public static String getDateTime() {
        Date date = new Date();
        return Utilities.getDateTime(date.getTime() / 1000L);
    }

    public static String getDateTime(long l) {
        return Utilities.getDateTime(l, Application.commServerTimeZone);
    }

    public static String getDateTime(long l, TimeZone timeZone) {
        if (l == 0L) {
            return "";
        }
        if (DateUtilities.useUserDateFormat) {
            return DateUtilities.instance().getUserSpecificDateAndTimeFormat(l);
        }
        long l2 = l * 1000L;
        Date date = new Date();
        date.setTime(l2);
        Calendar calendar = Calendar.getInstance();
        if (timeZone != null) {
            calendar.setTimeZone(timeZone);
        }
        calendar.setTime(date);
        String string = "";
        string = string + calendar.get(1) + "/" + Utilities.formatNum(calendar.get(2) + 1) + "/" + Utilities.formatNum(calendar.get(5)) + " ";
        string = string + Utilities.formatNum(calendar.get(11)) + ":" + Utilities.formatNum(calendar.get(12)) + ":" + Utilities.formatNum(calendar.get(13));
        return string;
    }

    public static String formatNum(int n) {
        String string = "";
        string = n < 10 ? string + "0" + n : string + n;
        return string;
    }

    public static String getFormattedText(String string, boolean bl, boolean bl2, Color color) {
        String string2 = "<html>";
        if (bl) {
            string2 = string2 + "<b>";
        }
        if (bl2) {
            string2 = color != null ? string2 + "<u><font color=#" + Integer.toHexString(color.getRGB()) + ">" : string2 + "<u>";
        }
        string2 = string2 + string;
        if (bl2) {
            string2 = color != null ? string2 + "</u></font>" : string2 + "</u>";
        }
        if (bl) {
            string2 = string2 + "</b>";
        }
        string2 = string2 + "</html>";
        return string2;
    }

    public static ImageIcon getIcon(String string) {
        try {
            return new ImageIcon(((Object)((Object)CVFrame.instance())).getClass().getClassLoader().getResource("images/" + string));
        }
        catch (Exception exception) {
            Logger.write(Logger.INFO, "", "getIcon", "images/" + string);
            return null;
        }
    }

    public static boolean isRTMBuild() {
        if (RTM_FLAG == null) {
            try {
                Enumeration<URL> enumeration = Utilities.class.getClassLoader().getResources("META-INF/MANIFEST.MF");
                while (enumeration.hasMoreElements()) {
                    URL uRL = enumeration.nextElement();
                    if (!uRL.toString().contains("cv.jar")) continue;
                    Manifest manifest = new Manifest(uRL.openStream());
                    Attributes attributes = manifest.getMainAttributes();
                    String string = attributes.getValue("RTM_BUILD");
                    RTM_FLAG = Boolean.parseBoolean(string);
                    break;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (RTM_FLAG == null) {
                RTM_FLAG = false;
            }
        }
        return RTM_FLAG;
    }

    public static ResourceBundle getBundle(Enum enum_) {
        return ResourceBundle.getBundle(enum_.getClass().getCanonicalName());
    }

    public static ResourceBundle getBundle(Enum enum_, Locale locale) {
        return ResourceBundle.getBundle(enum_.getClass().getCanonicalName(), locale);
    }

    public static String insertSharpInString(String string) {
        if (Utilities.excludeFromSharpInsertion(string)) {
            return string;
        }
        String string2 = "";
        string2 = string.startsWith("<html>") ? Utilities.insertSharpInHtmlString(string) : "$" + string + "$";
        return string2;
    }

    private static String insertSharpInHtmlString(String string) {
        String string2 = string;
        int n = "<html>".length();
        string.indexOf("<p>", n);
        if (n >= 0) {
            string2 = string.replaceFirst("<html>", "<html>\\$");
            string2 = string2.replaceAll("</html>", "\\$</html>");
        }
        return string2;
    }

    private static boolean excludeFromSharpInsertion(String string) {
        boolean bl = false;
        if (string.startsWith("http")) {
            bl = true;
        }
        return bl;
    }

    public static Cursor createWaitPointCusrsor() {
        return Toolkit.getDefaultToolkit().createCustomCursor(Utilities.getIcon("busy.GIF").getImage(), new Point(0, 0), "Busy");
    }

    private static String getErrorTitle() {
        return CteStringBank.Error.getI18n();
    }

    public static void showErrorMessage(String string) {
        Utilities.showErrorMessage((Component)null, string, Utilities.getErrorTitle());
    }

    public static void showErrorMessage(String string, boolean bl) {
        Utilities.showErrorMessage(null, string, Utilities.getErrorTitle(), bl);
    }

    public static void showErrorMessage(String string, String string2) {
        Utilities.showErrorMessage((Component)null, string, string2);
    }

    public static void showErrorMessage(String string, String string2, boolean bl) {
        Utilities.showErrorMessage(null, string, string2, bl);
    }

    public static void showErrorMessage(Component component, String string) {
        Utilities.showErrorMessage(component, string, Utilities.getErrorTitle());
    }

    public static void showErrorMessage(Component component, String string, boolean bl) {
        Utilities.showErrorMessage(component, string, Utilities.getErrorTitle(), bl);
    }

    public static void showErrorMessage(Component component, String string, String string2) {
        Utilities.showMessage(component, string, string2, 0);
    }

    public static void showErrorMessage(Component component, String string, String string2, boolean bl) {
        Utilities.showMessage(component, string, string2, 0, bl);
    }

    public static void showInfoMessage(Component component, String string, String string2) {
        Utilities.showMessage(component, string, string2, 1);
    }

    public static void showInfoMessage(Component component, String string, String string2, boolean bl) {
        Utilities.showMessage(component, string, string2, 1, bl);
    }

    public static void showInfoMessage(String string, String string2) {
        Utilities.showMessage(null, string, string2, 1);
    }

    public static void showInfoMessage(String string, String string2, boolean bl) {
        Utilities.showMessage(null, string, string2, 1, bl);
    }

    public static void showMessage(Component component, String string, String string2, int n) {
        Utilities.showMessage(component, string, string2, n, true);
    }

    public static void showMessage(Component component, String string, String string2, int n, boolean bl) {
        if (!RuntimeContext.isNonGUIVersion()) {
            JOptionPane jOptionPane = new JOptionPane(Utilities.wrapStringInHtml(string, true), n);
            JDialog jDialog = jOptionPane.createDialog(component, string2);
            jDialog.setFocusTraversalPolicy(new LayoutFocusTraversalPolicy());
            jDialog.setResizable(false);
            jDialog.setModal(bl);
            jDialog.setVisible(true);
        }
    }

    public static void disposeAllDialogs() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                Window[] windowArray;
                for (Window window : windowArray = JDialog.getWindows()) {
                    if (!(window instanceof Dialog) || !((Dialog)window).isModal() || !((Dialog)window).isVisible()) continue;
                    window.dispose();
                }
            }
        });
    }

    public static int showHighPriorityMessage(String string, String string2, String string3, boolean bl, int n, int n2) {
        if (RuntimeContext.isNonGUIVersion()) {
            return -1;
        }
        JOptionPane jOptionPane = new JOptionPane(string, n, n2);
        JDialog jDialog = jOptionPane.createDialog((Component)((Object)CVFrame.instance()), string2);
        jDialog.setFocusTraversalPolicy(new LayoutFocusTraversalPolicy());
        jDialog.setResizable(false);
        jDialog.setModal(true);
        jDialog.setModalExclusionType(Dialog.ModalExclusionType.APPLICATION_EXCLUDE);
        jDialog.setVisible(true);
        jDialog.toFront();
        Object object = jOptionPane.getValue();
        if (bl) {
            Utilities.disposeAllDialogs();
        }
        if (object != null && object instanceof Integer) {
            return (Integer)object;
        }
        return 1;
    }

    public static int showOKCancelMessage(String string, String string2, int n) {
        return Utilities.showConfirmMessage(null, string, string2, n, 2);
    }

    public static int showOKCancelMessage(Component component, String string, String string2, int n) {
        return Utilities.showConfirmMessage(component, string, string2, n, 2);
    }

    public static int showOKCancelMessage(Component component, String string, String string2, int n, int n2, int n3) {
        Object object;
        if (RuntimeContext.isNonGUIVersion()) {
            return 2;
        }
        Object[] objectArray = new String[]{UIConstants.OK, UIConstants.CANCEL};
        JOptionPane jOptionPane = new JOptionPane(string, n, -1, null, new String[0]);
        MyConfirmOptionDialog myConfirmOptionDialog = new MyConfirmOptionDialog(jOptionPane, objectArray, n2);
        myConfirmOptionDialog.setFocusTraversalPolicy(new LayoutFocusTraversalPolicy());
        myConfirmOptionDialog.setTitle(string2);
        myConfirmOptionDialog.setResizable(false);
        myConfirmOptionDialog.setModal(true);
        if (n3 != -1) {
            object = myConfirmOptionDialog.getSize();
            ((Dimension)object).height = n3;
            RuntimeContext.instance();
            if (RuntimeContext.isApplet()) {
                ((Dimension)object).height += 30;
            }
            myConfirmOptionDialog.setSize((Dimension)object);
        }
        myConfirmOptionDialog.setVisible(true);
        object = myConfirmOptionDialog.getSelection();
        if (((String)object).equals(UIConstants.OK)) {
            return 0;
        }
        return 2;
    }

    public static String showInputDialog(String string, String string2) {
        if (RuntimeContext.isNonGUIVersion()) {
            return "isNonGUIVersion";
        }
        JOptionPane jOptionPane = new JOptionPane(string, 3, 2, null, null, null);
        JDialog jDialog = jOptionPane.createDialog((Component)((Object)CVFrame.getInstance()), string2);
        jDialog.setFocusTraversalPolicy(new LayoutFocusTraversalPolicy());
        jOptionPane.setWantsInput(true);
        jOptionPane.selectInitialValue();
        jDialog.setResizable(false);
        jDialog.setModal(true);
        jDialog.show();
        Object object = jOptionPane.getInputValue();
        if (object == JOptionPane.UNINITIALIZED_VALUE) {
            return null;
        }
        return object.toString();
    }

    public static String showInputDialog(Component component, String string, String string2, int n, int n2) {
        if (RuntimeContext.isNonGUIVersion()) {
            return "isNonGUIVersion";
        }
        Object[] objectArray = new String[]{UIConstants.OK, UIConstants.CANCEL};
        JOptionPane jOptionPane = new JOptionPane(string, n, -1, null, new String[0]);
        MyOptionPaneUI myOptionPaneUI = new MyOptionPaneUI();
        jOptionPane.setUI(myOptionPaneUI);
        jOptionPane.setWantsInput(true);
        MyConfirmOptionDialog myConfirmOptionDialog = null;
        myConfirmOptionDialog = component instanceof JDialog ? new MyConfirmOptionDialog((JDialog)component, jOptionPane, objectArray, n2) : new MyConfirmOptionDialog(jOptionPane, objectArray, n2);
        myConfirmOptionDialog.setFocusTraversalPolicy(new LayoutFocusTraversalPolicy());
        myConfirmOptionDialog.setTitle(string2);
        myConfirmOptionDialog.setResizable(false);
        myConfirmOptionDialog.setModal(true);
        myConfirmOptionDialog.setVisible(true);
        myOptionPaneUI.resetInputValue();
        String string3 = myConfirmOptionDialog.getSelection();
        if (string3 != null && string3.equals(UIConstants.OK)) {
            Object object = jOptionPane.getInputValue();
            return object.toString();
        }
        return null;
    }

    public static int showYesNoMessage(String string, String string2, int n) {
        return Utilities.showConfirmMessage(null, string, string2, n, 0);
    }

    public static int showYesNoMessage(String string, String string2) {
        return Utilities.showConfirmMessage(null, string, string2, 3, 0);
    }

    public static int showYesNoMessage(Component component, String string, String string2, int n) {
        return Utilities.showConfirmMessage(component, string, string2, n, 0);
    }

    public static int showYesNoMessage(Component component, String string, String string2) {
        return Utilities.showConfirmMessage(component, string, string2, 3, 0);
    }

    public static int showYesNoCancelMessage(String string, String string2, int n) {
        return Utilities.showConfirmMessage(null, string, string2, n, 1);
    }

    public static int showYesNoCancelMessage(Component component, String string, String string2, int n) {
        return Utilities.showConfirmMessage(component, string, string2, n, 1);
    }

    public static int showConfirmMessage(String string, String string2, int n, int n2) {
        return Utilities.showConfirmMessage(null, string, string2, n, n2);
    }

    public static int showConfirmMessage(Component component, String string, String string2, int n, int n2) {
        if (RuntimeContext.isNonGUIVersion()) {
            return -1;
        }
        JOptionPane jOptionPane = new JOptionPane(string, n, n2);
        JDialog jDialog = jOptionPane.createDialog(component, string2);
        jDialog.setFocusTraversalPolicy(new LayoutFocusTraversalPolicy());
        jDialog.setResizable(false);
        jDialog.setModal(true);
        jDialog.setVisible(true);
        Object object = jOptionPane.getValue();
        if (object != null && object instanceof Integer) {
            return (Integer)object;
        }
        if (n2 == 1 || n2 == 2) {
            return 2;
        }
        if (n2 == 0) {
            return 1;
        }
        return -1;
    }

    public static FontMetrics getFontMetrics(Component component) {
        return component.getFontMetrics(component.getFont());
    }

    public static int getLineWidth(String string, Component component) {
        return Utilities.getFontMetrics(component).stringWidth(string);
    }

    public static int getLineWidth(String string) {
        return Utilities.getFontMetrics(fontMetricsLabel).stringWidth(string);
    }

    public static int getLineWidth(int n) {
        fontMetricsBuffer.setLength(0);
        for (int i = 0; i < n; ++i) {
            fontMetricsBuffer.append('m');
        }
        return Utilities.getLineWidth(fontMetricsBuffer.toString());
    }

    public static int getLineWidth(Font font, String string) {
        fontMetricsLabel.setFont(font);
        return Utilities.getFontMetrics(fontMetricsLabel).stringWidth(string);
    }

    public static final void disableComponent(Component component, boolean bl) {
        Component[] componentArray;
        if (component == null) {
            return;
        }
        component.setEnabled(!bl);
        if (component instanceof JTable) {
            componentArray = ((JTable)component).getTableHeader();
            if (componentArray != null) {
                componentArray.setEnabled(!bl);
            }
            ((JTable)component).setEnabled(!bl);
        }
        if (component instanceof Container) {
            componentArray = ((Container)component).getComponents();
            for (int i = 0; i < componentArray.length; ++i) {
                Utilities.disableComponent(componentArray[i], bl);
            }
        }
    }

    public static void showHelpErrorDialog(JDialog jDialog, String string) {
        JDialog.setDefaultLookAndFeelDecorated(true);
        JDialog jDialog2 = new JDialog((Dialog)jDialog, true);
        jDialog2.setTitle("Help Error Dialog");
        jDialog2.setDefaultCloseOperation(2);
        HelpErrorPanel helpErrorPanel = new HelpErrorPanel(string);
        helpErrorPanel.setOpaque(true);
        helpErrorPanel.setDialog(jDialog2);
        jDialog2.setContentPane(helpErrorPanel);
        jDialog2.pack();
        jDialog2.setSize(new Dimension(750, 250));
        jDialog2.setLocationRelativeTo(jDialog);
        jDialog2.setVisible(true);
    }

    public static void showHelpErrorDialog(String string) {
        JDialog.setDefaultLookAndFeelDecorated(true);
        JDialog jDialog = new JDialog((Frame)null, "Help Error", true);
        jDialog.setDefaultCloseOperation(2);
        HelpErrorPanel helpErrorPanel = new HelpErrorPanel(string);
        helpErrorPanel.setOpaque(true);
        helpErrorPanel.setDialog(jDialog);
        jDialog.setContentPane(helpErrorPanel);
        jDialog.pack();
        jDialog.setSize(new Dimension(545, 231));
        jDialog.setVisible(true);
    }

    public static String getXMLFormattedString(String string) throws Exception {
        return Utilities.getXMLFormattedString(string, true);
    }

    public static String getXMLFormattedString(String string, boolean bl) throws Exception {
        TransformerFactory transformerFactory = TransformerFactory.newInstance();
        Transformer transformer = transformerFactory.newTransformer();
        if (bl) {
            transformer.setOutputProperty("omit-xml-declaration", "yes");
        }
        transformer.setOutputProperty("method", "xml");
        transformer.setOutputProperty("encoding", "ISO-8859-1");
        transformer.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "4");
        transformer.setOutputProperty("indent", "yes");
        StringWriter stringWriter = new StringWriter();
        StreamResult streamResult = new StreamResult(stringWriter);
        transformer.transform(new StreamSource(new StringReader(string)), streamResult);
        return stringWriter.toString();
    }

    public static String getXMLFormattedStringForSharepoint(String string, boolean bl) throws Exception {
        TransformerFactory transformerFactory = TransformerFactory.newInstance();
        Transformer transformer = transformerFactory.newTransformer();
        if (bl) {
            transformer.setOutputProperty("omit-xml-declaration", "yes");
        }
        transformer.setOutputProperty("method", "xml");
        StringWriter stringWriter = new StringWriter();
        StreamResult streamResult = new StreamResult(stringWriter);
        transformer.transform(new StreamSource(new StringReader(string)), streamResult);
        return stringWriter.toString();
    }

    public static String buildCSVDataFromTableModel(TableModel tableModel, char c) {
        return TableUtils.convertToString(tableModel, c, 0, tableModel.getRowCount());
    }

    public static void showSaveDialogAndSave(Component component, String string, FileFilter fileFilter) {
    }

    public static void writeToFile(String string, String string2) throws Exception {
        PrintWriter printWriter = new PrintWriter((Writer)new FileWriter(string2, true), true);
        printWriter.print(string);
        printWriter.close();
    }

    public static String getFileContent(String string) throws Exception {
        String string2;
        BufferedReader bufferedReader = new BufferedReader(new FileReader(string));
        StringBuilder stringBuilder = new StringBuilder();
        while ((string2 = bufferedReader.readLine()) != null) {
            stringBuilder.append(string2 + LF);
        }
        bufferedReader.close();
        return stringBuilder.toString();
    }

    public static String join(String[] stringArray, String string) {
        if (stringArray == null) {
            return "";
        }
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < stringArray.length; ++i) {
            if (i != 0) {
                stringBuilder.append(string);
            }
            stringBuilder.append(stringArray[i]);
        }
        return stringBuilder.toString();
    }

    public static String toCapitalCase(String string) {
        StringBuilder stringBuilder = new StringBuilder();
        char[] cArray = string.toCharArray();
        boolean bl = true;
        for (char c : cArray) {
            if (Character.isSpaceChar(c)) {
                bl = true;
                continue;
            }
            if (bl) {
                stringBuilder.append(Character.toUpperCase(c));
                bl = false;
                continue;
            }
            stringBuilder.append(c);
        }
        return stringBuilder.toString();
    }

    public static void sendEmail(String string, String string2) {
        MailParamsDialog mailParamsDialog = new MailParamsDialog();
        mailParamsDialog.setData(string);
        mailParamsDialog.setFileName(string2);
        mailParamsDialog.setVisible(true);
    }

    public static void print(String string) {
    }

    public static String wrapStringInHtml(String string) {
        return Utilities.wrapStringInHtml(string, false);
    }

    public static String wrapStringInHtml(String string, boolean bl) {
        String string2 = string;
        String string3 = ".\n";
        if ((string = string.indexOf(string3) > 0 && bl ? string.replace(string3, ".<BR>") : string.replace(string3, " ")).indexOf("\n") > 0) {
            string = string.replace("\n", " ");
        }
        if (!string.toLowerCase().startsWith("<html>")) {
            string2 = "<html>" + string + "</html>";
        }
        return string2;
    }

    public static int showYesNoMessage(String string, String string2, String string3) {
        return Utilities.showYesNoMessage(string, string2);
    }

    public static boolean isUIField(Class clazz, String string) {
        boolean bl = true;
        for (Field field : clazz.getDeclaredFields()) {
            if (!field.getName().equals(string)) continue;
            UI uI = field.getAnnotation(UI.class);
            if (uI == null) break;
            return uI.visible();
        }
        return bl;
    }

    public static String createInClause(String string, String string2, String string3, boolean bl) {
        String[] stringArray;
        String string4 = bl ? " in " : " not in ";
        String string5 = " " + string + string4 + "(";
        if (string2.trim().length() == 0) {
            return string5 + "'')";
        }
        for (String string6 : stringArray = string2.split(string3)) {
            string5 = string5 + "'" + string6.trim() + "',";
        }
        string5 = string5.substring(0, string5.length() - 1);
        string5 = string5 + ")";
        return string5;
    }

    public static Object deepCopy(Serializable serializable) {
        Object object = null;
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            ObjectOutputStream objectOutputStream = new ObjectOutputStream(byteArrayOutputStream);
            objectOutputStream.writeObject(serializable);
            objectOutputStream.close();
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byteArrayOutputStream.toByteArray());
            ObjectInputStream objectInputStream = new ObjectInputStream(byteArrayInputStream);
            object = objectInputStream.readObject();
            objectInputStream.close();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            object = null;
        }
        return object;
    }

    public static void setUIFont(int n, Component component) {
        if (n <= 11) {
            return;
        }
        userDefinedFont = n;
        Enumeration enumeration = UIManager.getDefaults().keys();
        while (enumeration.hasMoreElements()) {
            Object k = enumeration.nextElement();
            Object object = UIManager.get(k);
            if (!(object instanceof Font)) continue;
            Font font = (Font)object;
            int n2 = font.getSize();
            boolean bl = n == 12 && n == n2;
            Font font2 = font.deriveFont(font.getStyle(), bl ? (float)(userDefinedFont + 1) : (float)userDefinedFont);
            if (object instanceof FontUIResource) {
                UIManager.put(k, new FontUIResource(font2.getName(), font2.getStyle(), font2.getSize()));
                continue;
            }
            UIManager.put(k, new Font(font2.getName(), font2.getStyle(), font2.getSize()));
        }
        if (component != null) {
            SwingUtilities.updateComponentTreeUI(component);
        }
    }

    public static void resetRowHeight(JTree jTree) {
        if (jTree != null) {
            jTree.setRowHeight(userDefinedFont == 0 ? jTree.getRowHeight() : (userDefinedFont > 14 && userDefinedFont <= 15 ? 22 : (userDefinedFont >= 12 && userDefinedFont <= 14 ? 20 : jTree.getRowHeight())));
        }
    }

    public static final boolean isGUIRunningOnMacOS() {
        return System.getProperty("os.name").indexOf("Mac") > -1;
    }

    public static JMenuBar getMenuBar() {
        JMenuBar jMenuBar = new JMenuBar();
        if (Utilities.isGUIRunningOnMacOS()) {
            jMenuBar.setUI(new MetalMenuBarUI());
        }
        return jMenuBar;
    }

    public static String escapeXml(String string) {
        StringBuilder stringBuilder = new StringBuilder();
        StringCharacterIterator stringCharacterIterator = new StringCharacterIterator(string);
        char c = stringCharacterIterator.current();
        while (c != '\uffff') {
            if (c == '<') {
                stringBuilder.append("&lt;");
            } else if (c == '>') {
                stringBuilder.append("&gt;");
            } else if (c == '\"') {
                stringBuilder.append("&quot;");
            } else if (c == '\'') {
                stringBuilder.append("&#039;");
            } else if (c == '&') {
                stringBuilder.append("&amp;");
            } else {
                stringBuilder.append(c);
            }
            c = stringCharacterIterator.next();
        }
        return stringBuilder.toString();
    }

    public static void disableAccessWarnings() {
        try {
            Class<?> clazz = Class.forName("sun.misc.Unsafe");
            Field field = clazz.getDeclaredField("theUnsafe");
            field.setAccessible(true);
            Object object = field.get(null);
            Method method = clazz.getDeclaredMethod("putObjectVolatile", Object.class, Long.TYPE, Object.class);
            Method method2 = clazz.getDeclaredMethod("staticFieldOffset", Field.class);
            Class<?> clazz2 = Class.forName("jdk.internal.module.IllegalAccessLogger");
            Field field2 = clazz2.getDeclaredField("logger");
            Long l = (Long)method2.invoke(object, field2);
            method.invoke(object, clazz2, l, null);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private static class MyOptionPaneUI
    extends BasicOptionPaneUI {
        private MyOptionPaneUI() {
        }

        @Override
        public void resetInputValue() {
            super.resetInputValue();
        }
    }

    private static class MyConfirmOptionDialog
    extends PropertyDialog {
        private JButton defaultButton;
        private String returnValue = null;

        public MyConfirmOptionDialog(JOptionPane jOptionPane, Object[] objectArray, int n) {
            this.contentPane.removeAll();
            this.contentPane.setLayout(new BorderLayout());
            JPanel jPanel = new JPanel(new FlowLayout());
            jPanel.add(this.okButton);
            jPanel.add(this.cancelButton);
            jPanel.add(this.helpButton);
            this.okButton.setPreferredSize(STANDARD_BUTTON_DIMENSION);
            this.cancelButton.setPreferredSize(STANDARD_BUTTON_DIMENSION);
            this.helpButton.setPreferredSize(STANDARD_BUTTON_DIMENSION);
            this.contentPane.add((Component)jPanel, "South");
            this.contentPane.add((Component)jOptionPane, "Center");
            Dimension dimension = jOptionPane.getPreferredSize();
            dimension.height += 50;
            dimension.width += 15;
            this.setSize(dimension);
            int n2 = 0;
            if (objectArray != null) {
                n2 = objectArray.length;
            }
            if (n2 > 0) {
                this.okButton.setText(objectArray[0].toString());
                if (objectArray[0].toString().equalsIgnoreCase("Continue")) {
                    this.okButton.setPreferredSize(new Dimension(90, 24));
                }
            } else {
                this.okButton.setVisible(false);
            }
            if (n2 > 1) {
                this.cancelButton.setText(objectArray[1].toString());
            } else {
                this.cancelButton.setVisible(false);
            }
            if (n2 > 2) {
                this.helpButton.setText(objectArray[2].toString());
            } else {
                this.helpButton.setVisible(false);
            }
            this.setLocationRelativeTo((Component)((Object)CVFrame.getInstance()));
            if (n == 0) {
                this.okButton.setDefaultOn(true);
                this.defaultButton = this.okButton;
            } else if (n == 2) {
                this.cancelButton.setDefaultOn(true);
                this.defaultButton = this.cancelButton;
            }
        }

        public MyConfirmOptionDialog(JDialog jDialog, JOptionPane jOptionPane, Object[] objectArray, int n) {
            super(jDialog);
            this.contentPane.removeAll();
            this.contentPane.setLayout(new BorderLayout());
            JPanel jPanel = new JPanel(new FlowLayout());
            jPanel.add(this.okButton);
            jPanel.add(this.cancelButton);
            jPanel.add(this.helpButton);
            this.okButton.setPreferredSize(STANDARD_BUTTON_DIMENSION);
            this.cancelButton.setPreferredSize(STANDARD_BUTTON_DIMENSION);
            this.helpButton.setPreferredSize(STANDARD_BUTTON_DIMENSION);
            this.contentPane.add((Component)jPanel, "South");
            this.contentPane.add((Component)jOptionPane, "Center");
            Dimension dimension = jOptionPane.getPreferredSize();
            dimension.height += 50;
            dimension.width += 15;
            this.setSize(dimension);
            int n2 = 0;
            if (objectArray != null) {
                n2 = objectArray.length;
            }
            if (n2 > 0) {
                this.okButton.setText(objectArray[0].toString());
                if (objectArray[0].toString().equalsIgnoreCase("Continue")) {
                    this.okButton.setPreferredSize(new Dimension(90, 24));
                }
            } else {
                this.okButton.setVisible(false);
            }
            if (n2 > 1) {
                this.cancelButton.setText(objectArray[1].toString());
            } else {
                this.cancelButton.setVisible(false);
            }
            if (n2 > 2) {
                this.helpButton.setText(objectArray[2].toString());
            } else {
                this.helpButton.setVisible(false);
            }
            this.setLocationRelativeTo((Component)((Object)CVFrame.getInstance()));
            if (n == 0) {
                this.okButton.setDefaultOn(true);
                this.defaultButton = this.okButton;
            } else if (n == 2) {
                this.cancelButton.setDefaultOn(true);
                this.defaultButton = this.cancelButton;
            }
        }

        @Override
        public void setFirstFocus() {
            if (this.defaultButton != null) {
                this.defaultButton.requestFocus();
            }
        }

        public String getSelection() {
            return this.returnValue;
        }

        @Override
        public void okButtonActionPerformed(ActionEvent actionEvent) {
            this.returnValue = this.okButton.getText();
            super.okButtonActionPerformed(actionEvent);
        }

        @Override
        public void cancelButtonActionPerformed(ActionEvent actionEvent) {
            this.returnValue = this.cancelButton.getText();
            super.cancelButtonActionPerformed(actionEvent);
        }

        @Override
        public boolean acceptChanges(Component component) {
            return false;
        }
    }

    public static class NonDefaultButton
    extends JButton {
        public NonDefaultButton() {
        }

        public NonDefaultButton(Icon icon) {
            super(icon);
        }

        public NonDefaultButton(String string) {
            super(string);
        }

        public NonDefaultButton(String string, Icon icon) {
            super(string, icon);
        }

        @Override
        public void setDefaultCapable(boolean bl) {
            super.setDefaultCapable(true);
        }
    }

    public static class DefaultCapableButton
    extends JButton {
        boolean performingAClick = false;
        private boolean defaultOn = true;

        public DefaultCapableButton() {
        }

        public DefaultCapableButton(Icon icon) {
            super(icon);
        }

        public DefaultCapableButton(String string) {
            super(string);
        }

        public DefaultCapableButton(String string, Icon icon) {
            super(string, icon);
        }

        public void setDefaultOn(boolean bl) {
            Component component;
            this.defaultOn = bl;
            if (this.defaultOn && (component = SwingUtilities.getRoot(this)) instanceof RootPaneContainer) {
                ((RootPaneContainer)((Object)component)).getRootPane().setDefaultButton(this);
            }
        }

        @Override
        public void setDefaultCapable(boolean bl) {
            super.setDefaultCapable(true);
        }

        public boolean isDefaultOn() {
            return this.defaultOn;
        }
    }
}

