/*
 * Decompiled with CFR 0.152.
 */
package commvault.cte.component;

import commvault.cte.component.SComboBox;
import java.awt.Component;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.Vector;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.ToolTipManager;

public class ToolTipComboBox
extends SComboBox {
    private int defaultLength = 10;

    public ToolTipComboBox() {
        this.setToolTipRenderer();
    }

    public ToolTipComboBox(ComboBoxModel comboBoxModel) {
        super(comboBoxModel);
        this.setToolTipRenderer();
    }

    public ToolTipComboBox(Object[] objectArray) {
        super(objectArray);
        this.setToolTipRenderer();
    }

    public ToolTipComboBox(Vector vector) {
        super(vector);
        this.setToolTipRenderer();
    }

    private void setToolTipRenderer() {
        ToolTipManager toolTipManager = ToolTipManager.sharedInstance();
        toolTipManager.setDismissDelay(10000);
        this.setRenderer(new ToolTipComboRenderer());
        this.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent itemEvent) {
                Object object = ToolTipComboBox.this.getSelectedItem();
                if (object != null) {
                    ToolTipComboBox.this.setToolTipText(object.toString());
                }
            }
        });
    }

    public int getDefaultLength() {
        return this.defaultLength;
    }

    public void setDefaultLength(int n) {
        this.defaultLength = n;
    }

    private class ToolTipComboRenderer
    extends DefaultListCellRenderer {
        private ToolTipComboRenderer() {
        }

        @Override
        public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
            Component component = super.getListCellRendererComponent((JList<?>)jList, object, n, bl, bl2);
            if (component != null && component instanceof JComponent) {
                JComponent jComponent = (JComponent)component;
                if (object != null && object.toString().length() > ToolTipComboBox.this.defaultLength) {
                    jComponent.setToolTipText(object.toString());
                }
            }
            return component;
        }
    }
}

