/*
 * Decompiled with CFR 0.152.
 */
package commvault.cte.component;

import commvault.cte.component.CVListModel;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Vector;

public class SortedListModel
extends CVListModel<Object>
implements Comparator {
    private boolean doSort = true;

    public SortedListModel(Vector vector) {
        this(vector, true);
    }

    public SortedListModel(Vector vector, boolean bl) {
        if (vector == null) {
            return;
        }
        this.doSort = bl;
        if (bl) {
            Collections.sort(vector, this);
        }
        super.addAll(vector);
    }

    public SortedListModel() {
        this.doSort = true;
    }

    public SortedListModel(boolean bl) {
        this.doSort = bl;
    }

    public SortedListModel(Object[] objectArray) {
        this(objectArray, true);
    }

    public SortedListModel(Object[] objectArray, boolean bl) {
        if (objectArray == null) {
            return;
        }
        this.doSort = bl;
        if (bl) {
            Arrays.sort(objectArray, this);
        }
        Vector<Object> vector = new Vector<Object>(Arrays.asList(objectArray));
        super.addAll(vector);
    }

    @Override
    public void addElement(Object object) {
        if (!this.doSort) {
            super.addElement(object);
            return;
        }
        int n = Collections.binarySearch(this.listData, object, this);
        if (n < 0) {
            n = -n - 1;
            super.add(n, object);
        } else {
            super.addElement(object);
        }
    }

    @Override
    public boolean removeElement(Object object) {
        boolean bl;
        if (!this.doSort) {
            return super.removeElement(object);
        }
        int n = Collections.binarySearch(this.listData, object, this);
        boolean bl2 = bl = n >= 0;
        if (bl) {
            this.listData.removeElementAt(n);
            this.fireIntervalRemoved(this, n, n);
        }
        return bl;
    }

    public int compare(Object object, Object object2) {
        if (object == null || object2 == null) {
            return 0;
        }
        if (object instanceof Comparable) {
            return ((Comparable)object).compareTo(object2);
        }
        return object.toString().compareToIgnoreCase(object2.toString());
    }

    @Override
    public void addAll(Vector vector) {
        if (vector == null) {
            return;
        }
        if (this.doSort) {
            Collections.sort(vector, this);
        }
        super.addAll(vector);
    }

    public void addAll(Object[] objectArray) {
        if (objectArray == null) {
            return;
        }
        if (this.doSort) {
            Arrays.sort(objectArray, this);
        }
        for (Object object : objectArray) {
            super.addElement(object);
        }
    }
}

