/*
 * Decompiled with CFR 0.152.
 */
package commvault.cte.component;

import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Vector;
import javax.swing.DefaultComboBoxModel;

public class SortedComboBoxModel
extends DefaultComboBoxModel {
    private boolean doSort = true;

    public SortedComboBoxModel() {
        this.doSort = true;
    }

    public SortedComboBoxModel(boolean bl) {
        this.doSort = bl;
    }

    private static Object[] sort(Object[] objectArray) {
        if (objectArray == null) {
            return null;
        }
        Arrays.sort(objectArray, new Comparator(){

            public int compare(Object object, Object object2) {
                if (object == null || object2 == null) {
                    return 0;
                }
                return object.toString().compareToIgnoreCase(object2.toString());
            }
        });
        return objectArray;
    }

    private static Vector sort(Vector vector) {
        if (vector == null) {
            return null;
        }
        Collections.sort(vector, new Comparator(){

            public int compare(Object object, Object object2) {
                if (object == null || object2 == null) {
                    return 0;
                }
                return object.toString().compareToIgnoreCase(object2.toString());
            }
        });
        return vector;
    }

    public SortedComboBoxModel(Object[] objectArray) {
        this(objectArray, true);
    }

    public SortedComboBoxModel(Object[] objectArray, boolean bl) {
        super(bl ? SortedComboBoxModel.sort(objectArray) : objectArray);
        this.doSort = bl;
    }

    public SortedComboBoxModel(Vector vector) {
        this(vector, true);
    }

    public SortedComboBoxModel(Vector vector, boolean bl) {
        super(bl ? SortedComboBoxModel.sort(vector) : vector);
        this.doSort = bl;
    }

    @Override
    public void addElement(Object object) {
        if (!this.doSort) {
            super.addElement(object);
            return;
        }
        int n = -1;
        for (int i = 0; i < super.getSize(); ++i) {
            if (this.compare(object, super.getElementAt(i)) > 0) continue;
            n = i;
            break;
        }
        if (n == -1) {
            super.addElement(object);
        } else {
            super.insertElementAt(object, n);
        }
    }

    public void setSortFlag(boolean bl) {
        this.doSort = bl;
    }

    public int compare(Object object, Object object2) {
        if (object == null || object2 == null) {
            return 0;
        }
        return object.toString().compareToIgnoreCase(object2.toString());
    }

    public void addAll(Object[] objectArray) {
        if (this.doSort) {
            objectArray = SortedComboBoxModel.sort(objectArray);
        }
        for (int i = 0; i < objectArray.length; ++i) {
            super.addElement(objectArray[i]);
        }
    }

    public void addAll(Vector vector) {
        if (this.doSort) {
            vector = SortedComboBoxModel.sort(vector);
        }
        for (int i = 0; i < vector.size(); ++i) {
            super.addElement(vector.get(i));
        }
    }
}

