/*
 * Decompiled with CFR 0.152.
 */
package commvault.cte.component;

import com.jidesoft.list.GroupList;
import commvault.cte.component.GroupListModel;
import commvault.cte.component.GroupListSelectionPanel;
import commvault.cte.component.MyTransferable;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import javax.swing.JComponent;
import javax.swing.TransferHandler;

class MyTransferHandler<T, E>
extends TransferHandler {
    private GroupListModel<T, E> availableModel;

    public MyTransferHandler(GroupListModel<T, E> groupListModel) {
        this.availableModel = groupListModel;
    }

    @Override
    public int getSourceActions(JComponent jComponent) {
        if (jComponent instanceof GroupList) {
            return 2;
        }
        return 0;
    }

    @Override
    protected Transferable createTransferable(JComponent jComponent) {
        if (jComponent instanceof GroupList) {
            GroupList groupList = (GroupList)jComponent;
            Map<T, List<E>> map = this.availableModel.getElementsAt(groupList.getSelectedIndices());
            return new MyTransferable<T, E>(map);
        }
        return null;
    }

    @Override
    protected void exportDone(JComponent jComponent, Transferable transferable, int n) {
        if (n == 2 && jComponent instanceof GroupList) {
            try {
                this.availableModel.removeElements((Map)transferable.getTransferData(GroupListSelectionPanel.getDataFlavor()));
            }
            catch (UnsupportedFlavorException unsupportedFlavorException) {
                unsupportedFlavorException.printStackTrace();
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
    }

    @Override
    public boolean canImport(JComponent jComponent, DataFlavor[] dataFlavorArray) {
        for (DataFlavor dataFlavor : dataFlavorArray) {
            if (!dataFlavor.equals(GroupListSelectionPanel.getDataFlavor())) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean importData(JComponent jComponent, Transferable transferable) {
        if (jComponent instanceof GroupList) {
            try {
                Map map = (Map)transferable.getTransferData(GroupListSelectionPanel.getDataFlavor());
                return this.availableModel.addElements(map);
            }
            catch (UnsupportedFlavorException unsupportedFlavorException) {
                unsupportedFlavorException.printStackTrace();
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
            return true;
        }
        return false;
    }
}

