/*
 * Decompiled with CFR 0.152.
 */
package commvault.cte.component;

import commvault.cte.component.Utilities;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.util.ArrayList;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSeparator;

public class LayoutUtils {
    private static final String _HORIZONATAL_FILL = "_HorizonatalFill";
    private static final String _TOP_INSET = "_TopInset";
    private static final String MARGIN = "_Margin";
    private static GridBagConstraints gridBagConstraints = new GridBagConstraints();
    private static Insets zeroInsets = new Insets(0, 0, 0, 0);
    private static final GridBagConstraints commonConstraints = new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 0, zeroInsets, 0, 0);

    public static void addComponent(JComponent jComponent, Component component, GridBagConstraints gridBagConstraints) {
        jComponent.add(component, gridBagConstraints);
    }

    public static void fillRemaining(Container container) {
        LayoutUtils.fillRemaining(container, new JPanel());
    }

    public static void fillRemaining(Container container, JComponent jComponent) {
        GridBagConstraints gridBagConstraints = LayoutUtils.fillRemainingConstr();
        if (!LayoutUtils.isMarginOn(container)) {
            gridBagConstraints.insets.left = 0;
        }
        container.add((Component)jComponent, gridBagConstraints);
    }

    public static GridBagConstraints fillRemainingConstr() {
        return LayoutUtils.getConstraints(gridBagConstraints, -1, -1, 0, 1, 1.0, 1.0, 17, 1, new Insets(10, 15, 0, 10));
    }

    public static void fillRemainingRows(Container container) {
        LayoutUtils.fillRemaining(container, new JPanel());
    }

    public static void fillRemainingRows(Container container, JComponent jComponent) {
        container.add((Component)jComponent, LayoutUtils.getConstraints(gridBagConstraints, 0, -1, 0, 1, 1.0, 1.0, 17, 1, new Insets(10, 15, 0, 10)));
    }

    public static void addRow(Container container, JComponent jComponent, JComponent jComponent2) {
        LayoutUtils.addRow(container, jComponent, jComponent2, 17, false, 0, 10);
    }

    public static void addRowNoFillLeftAligned(Container container, JComponent jComponent, JComponent jComponent2) {
        LayoutUtils.addRowLeftAlign(container, jComponent, jComponent2, 17, false, 0, 10);
    }

    public static void addRowNoFillLeftAlignedWithNoLeftInset(Container container, JComponent jComponent, JComponent jComponent2) {
        if (container == null || jComponent == null || jComponent2 == null) {
            return;
        }
        GridBagConstraints gridBagConstraints = new GridBagConstraints(-1, -1, 1, 1, 0.0, 0.0, 18, 0, new Insets(10, 0, 0, 0), 0, 0);
        container.add((Component)jComponent, gridBagConstraints);
        container.add((Component)jComponent2, LayoutUtils.getRightConstraintsLeftAlign(17, false, 0, 10));
    }

    public static void addRow(Container container, JComponent jComponent, JComponent jComponent2, boolean bl, int n) {
        LayoutUtils.addRow(container, jComponent, jComponent2, 17, bl, n, 0);
    }

    public static void addRow(Container container, JComponent jComponent, JComponent jComponent2, boolean bl) {
        LayoutUtils.addRow(container, jComponent, jComponent2, 17, bl, 0, 10);
    }

    public static void addRowRightAlign(Container container, JComponent jComponent, JComponent jComponent2, boolean bl) {
        LayoutUtils.addRow(container, jComponent, jComponent2, 13, bl, 0, 10);
    }

    public static void addRow(Container container, JComponent jComponent) {
        LayoutUtils.addRow(container, null, jComponent, true);
    }

    public static void addRow(Container container, JComponent jComponent, boolean bl) {
        LayoutUtils.addRow(container, null, jComponent, bl);
    }

    public static void addRow(Container container, JComponent jComponent, boolean bl, boolean bl2) {
        LayoutUtils.addRow(container, null, jComponent, bl, bl2);
    }

    public static void addRow(Container container, JComponent jComponent, JComponent jComponent2, boolean bl, boolean bl2) {
        LayoutUtils.addRow(container, jComponent, jComponent2, 17, bl, bl2, 0, 10);
    }

    public static void addRow(Container container, JComponent jComponent, JComponent jComponent2, int n, boolean bl, boolean bl2, int n2, int n3) {
        GridBagConstraints gridBagConstraints;
        if (jComponent == null && jComponent2 == null) {
            return;
        }
        if (jComponent != null) {
            gridBagConstraints = LayoutUtils.getLeftConstraints(n3);
            if (LayoutUtils.isHorizontalFill(jComponent)) {
                gridBagConstraints.weightx = 1.0;
                gridBagConstraints.fill = 2;
            }
            if (!LayoutUtils.isMarginOn(container)) {
                gridBagConstraints.insets = new Insets(n3 == 0 ? 10 : n3, 0, 0, 0);
            }
            container.add((Component)jComponent, gridBagConstraints);
        }
        gridBagConstraints = LayoutUtils.getRightConstraints(n, bl, bl2, n2, n3);
        if (!LayoutUtils.isMarginOn(container)) {
            gridBagConstraints.insets = new Insets(n3 == 0 ? 10 : n3, jComponent == null ? 0 : 15, 0, 0);
        }
        container.add((Component)jComponent2, gridBagConstraints);
    }

    public static GridBagConstraints getRightConstraints(int n, boolean bl, boolean bl2, int n2, int n3) {
        return LayoutUtils.getConstraints(gridBagConstraints, -1, -1, 0, 1, bl ? 1.0 : 0.0, bl2 ? 1.0 : 0.0, n, bl && bl2 ? 1 : (bl ? 2 : (bl2 ? 3 : 0)), new Insets(n3 == 0 ? 10 : n3, 15, 0, n2 == 0 ? 10 : n2));
    }

    public static void addRow(Container container, JComponent jComponent, JComponent jComponent2, int n) {
        LayoutUtils.addRow(container, jComponent, jComponent2, n, false, 0, 10);
    }

    public static GridBagConstraints getLeftConstraints() {
        return LayoutUtils.getLeftConstraints(10);
    }

    public static GridBagConstraints getLeftConstraints(int n) {
        return LayoutUtils.getLeftConstraints(n, false);
    }

    public static GridBagConstraints getLeftConstraints(boolean bl) {
        return LayoutUtils.getLeftConstraints(10, bl);
    }

    public static GridBagConstraints getLeftConstraints(int n, boolean bl) {
        return LayoutUtils.getLeftConstraints(n, 0, bl);
    }

    public static GridBagConstraints getLeftConstraints(int n, int n2, boolean bl) {
        return LayoutUtils.getConstraints(gridBagConstraints, -1, -1, 1, 1, bl ? 1.0 : 0.0, 0.0, 18, bl ? 2 : 0, new Insets(n == 0 ? 10 : n, n2 == 0 ? 15 : n2, 0, 0));
    }

    public static GridBagConstraints getRightConstraints() {
        return LayoutUtils.getRightConstraints(18, false, 0, 10);
    }

    public static GridBagConstraints getRightConstraints(int n, boolean bl, int n2) {
        return LayoutUtils.getRightConstraints(n, bl, n2, 10);
    }

    public static GridBagConstraints getRightConstraints(int n, boolean bl, int n2, int n3) {
        return LayoutUtils.getRightConstraints(n, bl, 15, n2, n3);
    }

    public static GridBagConstraints getRightConstraints(int n, boolean bl, int n2, int n3, int n4) {
        return LayoutUtils.getConstraints(gridBagConstraints, -1, -1, 0, 1, bl ? 1.0 : 0.0, 0.0, n, bl ? 2 : 0, new Insets(n4 == 0 ? 10 : n4, n2 == 0 ? 15 : n2, 0, n3 == 0 ? 10 : n3));
    }

    public static GridBagConstraints getRightConstraintsLeftAlign(int n, boolean bl, int n2, int n3) {
        return LayoutUtils.getConstraints(gridBagConstraints, -1, -1, 0, 1, 1.0, 0.0, n, bl ? 2 : 0, new Insets(n3 == 0 ? 10 : n3, 15, 0, n2 == 0 ? 10 : n2));
    }

    public static void addRow(Container container, JComponent jComponent, JComponent jComponent2, int n, boolean bl, int n2) {
        LayoutUtils.addRow(container, jComponent, jComponent2, n, bl, n2, 10);
    }

    public static void addRow(Container container, JComponent jComponent, JComponent jComponent2, int n, boolean bl, int n2, int n3) {
        GridBagConstraints gridBagConstraints;
        if (jComponent == null && jComponent2 == null) {
            return;
        }
        if (jComponent != null) {
            gridBagConstraints = LayoutUtils.getLeftConstraints(n3);
            if (LayoutUtils.isHorizontalFill(jComponent)) {
                gridBagConstraints.weightx = 1.0;
                gridBagConstraints.fill = 2;
            }
            if (!LayoutUtils.isMarginOn(container)) {
                gridBagConstraints.insets = new Insets(n3 == 0 ? 10 : n3, 0, 0, 0);
            }
            container.add((Component)jComponent, gridBagConstraints);
        }
        gridBagConstraints = LayoutUtils.getRightConstraints(n, bl, n2, n3);
        if (!LayoutUtils.isMarginOn(container)) {
            gridBagConstraints.insets = new Insets(n3 == 0 ? 10 : n3, jComponent == null ? 0 : 15, 0, 0);
        }
        container.add((Component)jComponent2, gridBagConstraints);
    }

    public static void addRow(Container container, JComponent jComponent, JComponent jComponent2, int n, boolean bl, int n2, int n3, int n4) {
        GridBagConstraints gridBagConstraints;
        if (jComponent == null && jComponent2 == null) {
            return;
        }
        if (jComponent != null) {
            gridBagConstraints = LayoutUtils.getLeftConstraints(n3, n4, false);
            if (LayoutUtils.isHorizontalFill(jComponent)) {
                gridBagConstraints.weightx = 1.0;
                gridBagConstraints.fill = 2;
            }
            if (!LayoutUtils.isMarginOn(container)) {
                gridBagConstraints.insets = new Insets(n3 == 0 ? 10 : n3, 0, 0, 0);
            }
            container.add((Component)jComponent, gridBagConstraints);
        }
        gridBagConstraints = LayoutUtils.getRightConstraints(n, bl, n2, n3);
        if (!LayoutUtils.isMarginOn(container)) {
            gridBagConstraints.insets = new Insets(n3 == 0 ? 10 : n3, jComponent == null ? 0 : 15, 0, 0);
        }
        container.add((Component)jComponent2, gridBagConstraints);
    }

    public static void addRowLeftAlign(Container container, JComponent jComponent, JComponent jComponent2, int n, boolean bl, int n2, int n3) {
        if (jComponent == null && jComponent2 == null) {
            return;
        }
        if (jComponent != null) {
            container.add((Component)jComponent, LayoutUtils.getLeftConstraints(n3));
        }
        container.add((Component)jComponent2, LayoutUtils.getRightConstraintsLeftAlign(n, bl, n2, n3));
    }

    public static void addRow(Container container, JComponent[] jComponentArray, int n) {
        LayoutUtils.addRow(container, jComponentArray, n, false, 0);
    }

    public static void addRow(Container container, JComponent[] jComponentArray, int n, int n2) {
        LayoutUtils.addRow(container, jComponentArray, n, false, n2);
    }

    public static void addRow(Container container, JComponent[] jComponentArray, boolean bl) {
        LayoutUtils.addRow(container, jComponentArray, -1, bl, 10);
    }

    public static void addRow(Container container, JComponent jComponent, JComponent jComponent2, JComponent jComponent3, boolean bl) {
        JComponent[] jComponentArray = new JComponent[]{jComponent, jComponent2, jComponent3};
        LayoutUtils.addRow(container, jComponentArray, bl);
    }

    public static void addRow(Container container, JComponent jComponent, JComponent jComponent2, JComponent jComponent3, JComponent jComponent4, boolean bl) {
        JComponent[] jComponentArray = new JComponent[]{jComponent, jComponent2, jComponent3, jComponent4};
        LayoutUtils.addRow(container, jComponentArray, bl);
    }

    public static void addRow(Container container, JComponent[] jComponentArray, int n, boolean bl) {
        LayoutUtils.addRow(container, jComponentArray, n, bl, 10);
    }

    public static void addRow(Container container, JComponent[] jComponentArray, int n, boolean bl, int n2) {
        LayoutUtils.addRow(-1, container, jComponentArray, n, bl, n2);
    }

    public static void addRow(int n, Container container, JComponent[] jComponentArray, int n2, boolean bl, int n3, int[] nArray) {
        int n4;
        if (jComponentArray == null) {
            return;
        }
        Vector<JComponent> vector = new Vector<JComponent>(jComponentArray.length);
        for (n4 = 0; n4 < jComponentArray.length; ++n4) {
            if (jComponentArray == null) continue;
            vector.add(jComponentArray[n4]);
        }
        if (vector.size() == 0) {
            return;
        }
        for (n4 = 0; n4 < vector.size() - 1; ++n4) {
            GridBagConstraints gridBagConstraints = LayoutUtils.getLeftConstraints(n3);
            if (n > 0) {
                gridBagConstraints.gridy = n;
            }
            if (LayoutUtils.isHorizontalFill((JComponent)vector.get(n4))) {
                gridBagConstraints.fill = 2;
                gridBagConstraints.weightx = 1.0;
            }
            if (LayoutUtils.getTopInset((JComponent)vector.get(n4)) != null) {
                gridBagConstraints.insets.top = LayoutUtils.getTopInset((JComponent)vector.get(n4));
            }
            if (n4 == 0 && n2 != -1) {
                gridBagConstraints.insets.left = n2;
            }
            if (nArray[n4] != 0) {
                gridBagConstraints.gridwidth = nArray[n4];
            }
            container.add((Component)((JComponent)vector.get(n4)), gridBagConstraints);
        }
        GridBagConstraints gridBagConstraints = LayoutUtils.getRightConstraints(18, bl, 0, n3);
        if (n > 0) {
            gridBagConstraints.gridy = n;
        }
        if (vector.size() == 1 && n2 != -1) {
            gridBagConstraints.insets.left = n2;
        }
        if (LayoutUtils.getTopInset((JComponent)vector.get(vector.size() - 1)) != null) {
            gridBagConstraints.insets.top = LayoutUtils.getTopInset((JComponent)vector.get(vector.size() - 1));
        }
        container.add(container.add((JComponent)vector.get(vector.size() - 1)), gridBagConstraints);
    }

    public static void addRow(int n, Container container, JComponent[] jComponentArray, int n2, boolean bl, int n3) {
        LayoutUtils.addRow(n, container, jComponentArray, n2, bl, n3, new int[jComponentArray.length]);
    }

    public static JPanel addRow(JPanel jPanel, JComponent jComponent, JComponent[] jComponentArray) {
        return LayoutUtils.addRow(jPanel, jComponent, 1, jComponentArray);
    }

    public static JPanel addRow(JPanel jPanel, JComponent jComponent, int n, JComponent[] jComponentArray) {
        GridBagConstraints gridBagConstraints = LayoutUtils.getLeftConstraints(10, true);
        GridBagLayout gridBagLayout = (GridBagLayout)jPanel.getLayout();
        gridBagLayout.layoutContainer(jPanel);
        int[][] nArray = gridBagLayout.getLayoutDimensions();
        int n2 = nArray[1].length;
        if (jComponent != null) {
            gridBagConstraints.gridheight = jComponentArray.length;
            gridBagConstraints.gridwidth = n;
            gridBagConstraints.fill = 1;
            gridBagConstraints.weighty = 1.0;
            jPanel.add((Component)jComponent, gridBagConstraints);
        }
        GridBagConstraints gridBagConstraints2 = LayoutUtils.getConstraints(LayoutUtils.gridBagConstraints, -1, -1, 0, 1, 0.01, 0.0, 18, 2, new Insets(10, 15, 0, 10));
        for (int i = 0; i < jComponentArray.length; ++i) {
            gridBagConstraints2.gridy = n2 + i;
            if (jComponentArray[i] != null) {
                jPanel.add((Component)jComponentArray[i], gridBagConstraints2);
                continue;
            }
            jPanel.add((Component)new JLabel(), gridBagConstraints2);
        }
        return jPanel;
    }

    public static JPanel addRow(JPanel jPanel, JComponent jComponent, int n, JComponent[] jComponentArray, boolean bl) {
        GridBagConstraints gridBagConstraints = LayoutUtils.getLeftConstraints(10, true);
        GridBagLayout gridBagLayout = (GridBagLayout)jPanel.getLayout();
        gridBagLayout.layoutContainer(jPanel);
        int[][] nArray = gridBagLayout.getLayoutDimensions();
        int n2 = nArray[1].length;
        if (jComponent != null) {
            gridBagConstraints.gridheight = jComponentArray.length;
            gridBagConstraints.gridwidth = n;
            gridBagConstraints.fill = 2;
            gridBagConstraints.weighty = 0.0;
            jPanel.add((Component)jComponent, gridBagConstraints);
        }
        GridBagConstraints gridBagConstraints2 = LayoutUtils.getConstraints(LayoutUtils.gridBagConstraints, -1, -1, 0, 1, 0.01, 0.0, 18, 2, new Insets(10, 15, 0, 10));
        for (int i = 0; i < jComponentArray.length; ++i) {
            gridBagConstraints2.gridy = n2 + i;
            if (jComponentArray[i] != null) {
                jPanel.add((Component)jComponentArray[i], gridBagConstraints2);
                continue;
            }
            jPanel.add((Component)new JLabel(), gridBagConstraints2);
        }
        return jPanel;
    }

    public static void addRowAfter(JComponent jComponent, JPanel jPanel, JComponent[] jComponentArray, int n, boolean bl, int n2) {
        int n3 = -1;
        LayoutManager layoutManager = jPanel.getLayout();
        if (!(layoutManager instanceof GridBagLayout)) {
            throw new AbstractMethodError(" Not implemented for layout other than GridBagLayout");
        }
        GridBagLayout gridBagLayout = (GridBagLayout)layoutManager;
        for (int i = 0; i < jPanel.getComponentCount(); ++i) {
            if (jPanel.getComponent(i) == jComponent) {
                n3 = i;
            }
            Component component = jPanel.getComponent(i);
            GridBagConstraints gridBagConstraints = gridBagLayout.getConstraints(component);
            if (n3 < 0) continue;
            ++gridBagConstraints.gridy;
            gridBagLayout.setConstraints(component, gridBagConstraints);
        }
        LayoutUtils.addRow(n3, (Container)jPanel, jComponentArray, n, bl, n2);
        jPanel.validate();
    }

    public static Component[] getRowHavingComponent(JPanel jPanel, Component component) {
        Component[] componentArray;
        LayoutManager layoutManager = jPanel.getLayout();
        int n = -1;
        for (int i = 0; i < jPanel.getComponentCount(); ++i) {
            if (jPanel.getComponent(i) instanceof JPanel && (componentArray = LayoutUtils.getRowHavingComponent((JPanel)jPanel.getComponent(i), component)) != null) {
                return componentArray;
            }
            if (jPanel.getComponent(i) != component) continue;
            n = i;
        }
        if (!(layoutManager instanceof GridBagLayout)) {
            return null;
        }
        GridBagLayout gridBagLayout = (GridBagLayout)layoutManager;
        if (n < 0) {
            return null;
        }
        componentArray = new ArrayList();
        for (int i = 0; i < jPanel.getComponentCount(); ++i) {
            if (jPanel.getComponent(i) == component) {
                n = i;
            }
            Component component2 = jPanel.getComponent(i);
            GridBagConstraints gridBagConstraints = gridBagLayout.getConstraints(component2);
            if (gridBagConstraints.gridy != n) continue;
            componentArray.add(component2);
        }
        if (componentArray.size() == 0) {
            return null;
        }
        return componentArray.toArray(new Component[0]);
    }

    public static GridBagConstraints getConstraints(GridBagConstraints gridBagConstraints, int n, int n2, int n3, int n4, double d, double d2, int n5, int n6) {
        return LayoutUtils.getConstraints(gridBagConstraints, n, n2, n3, n4, d, d2, n5, n6, zeroInsets);
    }

    public static GridBagConstraints getConstraints(GridBagConstraints gridBagConstraints, int n, int n2, int n3, int n4, double d, double d2, int n5, int n6, Insets insets) {
        if (gridBagConstraints == null) {
            gridBagConstraints = commonConstraints;
        }
        gridBagConstraints.gridx = n;
        gridBagConstraints.gridy = n2;
        gridBagConstraints.gridwidth = n3;
        gridBagConstraints.gridheight = n4;
        gridBagConstraints.weightx = d;
        gridBagConstraints.weighty = d2;
        gridBagConstraints.insets = insets;
        gridBagConstraints.anchor = n5;
        gridBagConstraints.fill = n6;
        return gridBagConstraints;
    }

    public static GridBagConstraints getPanelConstraints() {
        return LayoutUtils.getConstraints(commonConstraints, 0, -1, 1, 1, 0.0, 0.0, 17, 2, new Insets(5, 5, 5, 5));
    }

    public static void addRowWithoutInsets(JPanel jPanel, JComponent jComponent, JComponent jComponent2, boolean bl) {
        GridBagConstraints gridBagConstraints;
        if (jComponent != null) {
            gridBagConstraints = LayoutUtils.getLeftConstraints();
            gridBagConstraints.insets.left = 0;
            jPanel.add((Component)jComponent, gridBagConstraints);
        }
        gridBagConstraints = LayoutUtils.getRightConstraints(17, bl, 0);
        jPanel.add((Component)jComponent2, gridBagConstraints);
    }

    public static void addRowWithoutInsets(JComponent jComponent, JComponent jComponent2, boolean bl) {
        GridBagConstraints gridBagConstraints = LayoutUtils.getRightConstraints(17, bl, 0);
        gridBagConstraints.insets.left = 0;
        jComponent.add((Component)jComponent2, gridBagConstraints);
    }

    public static void setMarginOn(Container container, boolean bl) {
        if (container instanceof JComponent) {
            ((JComponent)container).putClientProperty(MARGIN, bl);
        }
    }

    public static boolean isMarginOn(Container container) {
        if (!(container instanceof JComponent)) {
            return true;
        }
        Object object = ((JComponent)container).getClientProperty(MARGIN);
        if (object == null) {
            return true;
        }
        return (Boolean)object;
    }

    public static void fillHorizontal(JComponent jComponent) {
        jComponent.putClientProperty(_HORIZONATAL_FILL, true);
    }

    private static boolean isHorizontalFill(JComponent jComponent) {
        Object object = jComponent.getClientProperty(_HORIZONATAL_FILL);
        if (object == null) {
            return false;
        }
        return (Boolean)object;
    }

    public static void setTopInset(JComponent jComponent, int n) {
        jComponent.putClientProperty(_TOP_INSET, n);
    }

    private static Integer getTopInset(JComponent jComponent) {
        Object object = jComponent.getClientProperty(_TOP_INSET);
        if (object == null) {
            return null;
        }
        return (Integer)object;
    }

    public static JSeparator addHorizontalSeparator(Container container, GridBagConstraints gridBagConstraints, int n, int n2) {
        JSeparator jSeparator = new JSeparator(0);
        jSeparator.setBackground(Color.GRAY.brighter());
        jSeparator.setPreferredSize(new Dimension(n, n2));
        jSeparator.setOpaque(true);
        jSeparator.setBorder(BorderFactory.createBevelBorder(0));
        container.add((Component)jSeparator, Utilities.getConstraints(gridBagConstraints, -1, -1, 0, 1, 1.0, 0.0, 18, 2));
        return jSeparator;
    }

    public static JSeparator addHorizontalSeparator(Container container, GridBagConstraints gridBagConstraints, int n, int n2, Insets insets) {
        JSeparator jSeparator = new JSeparator(0);
        jSeparator.setBackground(Color.GRAY.brighter());
        jSeparator.setPreferredSize(new Dimension(n, n2));
        jSeparator.setOpaque(true);
        jSeparator.setBorder(BorderFactory.createBevelBorder(0));
        container.add((Component)jSeparator, Utilities.getConstraints(gridBagConstraints, -1, -1, 0, 1, 1.0, 0.0, 18, 2, insets));
        return jSeparator;
    }

    public static void addRow(JPanel jPanel, JComponent jComponent, JComponent jComponent2) {
        LayoutUtils.addRow(jPanel, jComponent, jComponent2, -1, -1, -1, -1, -1, false);
    }

    public static void addRow(JPanel jPanel, JComponent jComponent, JComponent jComponent2, int n, int n2, int n3, int n4, int n5, boolean bl) {
        GridBagConstraints gridBagConstraints;
        n = n == -1 ? 17 : n;
        n2 = n2 == -1 ? 17 : n;
        n3 = n3 == -1 ? 15 : n3;
        n4 = n4 == -1 ? 0 : n4;
        int n6 = n5 = n5 == -1 ? 10 : n5;
        if (jComponent == null && jComponent2 == null) {
            return;
        }
        if (jComponent != null) {
            gridBagConstraints = LayoutUtils.getLeftConstraints(n5);
            if (LayoutUtils.isHorizontalFill(jComponent)) {
                gridBagConstraints.weightx = 1.0;
                gridBagConstraints.fill = 2;
            }
            if (!LayoutUtils.isMarginOn(jPanel)) {
                gridBagConstraints.insets = new Insets(n5 == 0 ? 10 : n5, n3, 0, 0);
            }
            gridBagConstraints.insets.left = n3;
            gridBagConstraints.anchor = n;
            jPanel.add((Component)jComponent, gridBagConstraints);
        }
        gridBagConstraints = LayoutUtils.getRightConstraints(n2, bl, n4, n5);
        if (!LayoutUtils.isMarginOn(jPanel)) {
            gridBagConstraints.insets = new Insets(n5 == 0 ? 10 : n5, jComponent == null ? 0 : 15, 0, 0);
        }
        gridBagConstraints.anchor = n2;
        jPanel.add((Component)jComponent2, gridBagConstraints);
    }

    public static void fillRemainingSmallGap(Container container) {
        JPanel jPanel = new JPanel();
        jPanel.setPreferredSize(new Dimension(5, 5));
        GridBagConstraints gridBagConstraints = LayoutUtils.fillRemainingConstr();
        gridBagConstraints.insets = new Insets(0, 0, 0, 0);
        container.add((Component)jPanel, gridBagConstraints);
    }
}

