/*
 * Decompiled with CFR 0.152.
 */
package commvault.cte.component;

import commvault.cte.component.GlassPane;
import java.awt.Component;
import java.awt.Container;
import java.awt.Point;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionAdapter;
import javax.swing.JFrame;
import javax.swing.SwingUtilities;

class GlassMouseListener
extends MouseMotionAdapter
implements MouseListener {
    private GlassPane glassPane = null;
    private Container layeredPane = null;

    public GlassMouseListener(GlassPane glassPane) {
        this.glassPane = glassPane;
    }

    public GlassMouseListener(GlassPane glassPane, Container container) {
        this.glassPane = glassPane;
        this.layeredPane = container;
    }

    @Override
    public void mouseClicked(MouseEvent mouseEvent) {
        this.redispatchEvent(mouseEvent);
    }

    @Override
    public void mouseMoved(MouseEvent mouseEvent) {
        this.redispatchEvent(mouseEvent);
    }

    @Override
    public void mouseDragged(MouseEvent mouseEvent) {
        this.redispatchEvent(mouseEvent);
    }

    @Override
    public void mouseEntered(MouseEvent mouseEvent) {
        this.redispatchEvent(mouseEvent);
    }

    @Override
    public void mouseExited(MouseEvent mouseEvent) {
        this.redispatchEvent(mouseEvent);
    }

    @Override
    public void mousePressed(MouseEvent mouseEvent) {
        this.redispatchEvent(mouseEvent);
    }

    @Override
    public void mouseReleased(MouseEvent mouseEvent) {
        this.redispatchEvent(mouseEvent);
    }

    public void redispatchEvent(MouseEvent mouseEvent) {
        if (this.layeredPane == null) {
            this.layeredPane = ((JFrame)SwingUtilities.windowForComponent(this.glassPane)).getLayeredPane();
        }
        Container container = null;
        Component component = null;
        Point point = mouseEvent.getPoint();
        Point point2 = SwingUtilities.convertPoint(this.glassPane, point, this.layeredPane);
        Component component2 = this.layeredPane.getComponentAt(point2.x, point2.y);
        if (component2 == null) {
            return;
        }
        container = (Container)component2;
        Point point3 = SwingUtilities.convertPoint(this.glassPane, point, container);
        component = container.getComponentAt(point3.x, point3.y);
        if (component == null) {
            return;
        }
        Point point4 = SwingUtilities.convertPoint(this.glassPane, point, component);
        component.dispatchEvent(new MouseEvent(component, mouseEvent.getID(), mouseEvent.getWhen(), mouseEvent.getModifiers(), point4.x, point4.y, mouseEvent.getClickCount(), mouseEvent.isPopupTrigger()));
    }
}

