/*
 * Decompiled with CFR 0.152.
 */
package commvault.cte.component;

import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.io.IOException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.accessibility.AccessibleHypertext;
import javax.swing.JEditorPane;
import javax.swing.TransferHandler;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.Element;
import javax.swing.text.JTextComponent;
import javax.swing.text.html.HTML;
import javax.swing.text.html.HTMLDocument;
import javax.swing.text.html.HTMLEditorKit;
import javax.swing.text.html.StyleSheet;
import javax.swing.text.html.parser.ParserDelegator;

public class EditorPaneLinkDetector
extends JEditorPane {
    private static final String I_B_HTTP_HTTPS_WWW_FTP_FILE_MAILTO_S_S = "(?i)(\\b(http://|https://|www.|ftp://|file:/|mailto:)\\S+)(\\s+)";

    public EditorPaneLinkDetector() {
        HTMLEditorKit hTMLEditorKit = new HTMLEditorKit();
        StyleSheet styleSheet = hTMLEditorKit.getStyleSheet();
        StyleSheet styleSheet2 = new StyleSheet();
        styleSheet2.addStyleSheet(styleSheet);
        HTMLDocLinkDetector hTMLDocLinkDetector = this.createDocument(styleSheet2);
        this.setEditorKit(hTMLEditorKit);
        this.setDocument(hTMLDocLinkDetector);
        this.addMouseMotionListener(new MouseMotionAdapter(){

            @Override
            public void mouseMoved(MouseEvent mouseEvent) {
                int n;
                JTextComponent.AccessibleJTextComponent accessibleJTextComponent = (JTextComponent.AccessibleJTextComponent)EditorPaneLinkDetector.this.getAccessibleContext().getAccessibleEditableText();
                AccessibleHypertext accessibleHypertext = (AccessibleHypertext)accessibleJTextComponent.getAccessibleText();
                int n2 = accessibleHypertext.getLinkIndex(n = accessibleHypertext.getIndexAtPoint(mouseEvent.getPoint()));
                if (n2 == -1) {
                    EditorPaneLinkDetector.this.setToolTipText(null);
                    return;
                }
                String string = accessibleHypertext.getLink(n2).getAccessibleActionDescription(0);
                String string2 = "<html><body style='margin: 3'>" + string + "<br><b>CTRL + click to follow link</b></body></html>";
                EditorPaneLinkDetector.this.setToolTipText(string2);
            }
        });
        this.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent keyEvent) {
                if (keyEvent.getKeyCode() == 17) {
                    if (EditorPaneLinkDetector.this.isEditable()) {
                        EditorPaneLinkDetector.this.setEditable(false);
                    }
                } else if (!EditorPaneLinkDetector.this.isEditable()) {
                    EditorPaneLinkDetector.this.setEditable(true);
                }
            }

            @Override
            public void keyReleased(KeyEvent keyEvent) {
                if (keyEvent.getKeyCode() == 17) {
                    EditorPaneLinkDetector.this.setEditable(true);
                }
            }
        });
        TransferHandler transferHandler = this.getTransferHandler();
        this.setTransferHandler(transferHandler);
    }

    protected HTMLDocLinkDetector createDocument(StyleSheet styleSheet) {
        return new HTMLDocLinkDetector(styleSheet);
    }

    public void correctLinks() {
        Element[] elementArray;
        HTMLDocLinkDetector hTMLDocLinkDetector = (HTMLDocLinkDetector)this.getDocument();
        for (Element element : elementArray = hTMLDocLinkDetector.getRootElements()) {
            this.correctLink(hTMLDocLinkDetector, element);
        }
    }

    private void correctLink(HTMLDocLinkDetector hTMLDocLinkDetector, Element element) {
        if (element.isLeaf() && element.getName().equals("content")) {
            try {
                String string = hTMLDocLinkDetector.getText(element.getStartOffset(), element.getEndOffset() - element.getStartOffset());
                if (string.matches(I_B_HTTP_HTTPS_WWW_FTP_FILE_MAILTO_S_S)) {
                    hTMLDocLinkDetector.computeLinks(element, true);
                    return;
                }
            }
            catch (BadLocationException badLocationException) {
                badLocationException.printStackTrace();
            }
        }
        for (int i = 0; i < element.getElementCount(); ++i) {
            this.correctLink(hTMLDocLinkDetector, element.getElement(i));
        }
    }

    protected class HTMLDocLinkDetector
    extends HTMLDocument {
        public HTMLDocLinkDetector(StyleSheet styleSheet) {
            super(styleSheet);
            this.putProperty("IgnoreCharsetDirective", Boolean.TRUE);
            this.setPreservesUnknownTags(false);
            this.setAsynchronousLoadPriority(4);
            this.setTokenThreshold(100);
            this.setParser(new ParserDelegator());
        }

        protected boolean isLink(Element element) {
            return element.getAttributes().getAttribute(HTML.Tag.A) != null;
        }

        protected void computeLinks(Element element, boolean bl) throws BadLocationException {
            try {
                if (this.isLink(element)) {
                    this.correctLink(element);
                } else {
                    this.createLink(element, bl);
                }
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }

        protected void correctLink(Element element) throws BadLocationException, IOException {
            boolean bl;
            int n = element.getEndOffset() - element.getStartOffset();
            boolean bl2 = bl = element.getEndOffset() == this.getLength() + 1;
            if (bl) {
                --n;
            }
            String string = this.getText(element.getStartOffset(), n);
            this.setOuterHTML(element, string);
            Matcher matcher = Pattern.compile("(\\s+)$").matcher(string);
            if (matcher.find()) {
                String string2 = matcher.group(1);
                this.insertString(Math.min(this.getLength(), element.getEndOffset()), string2, null);
            }
        }

        protected void createLink(Element element, boolean bl) throws BadLocationException, IOException {
            boolean bl2;
            int n = EditorPaneLinkDetector.this.getCaretPosition();
            int n2 = element.getStartOffset();
            int n3 = element.getEndOffset() - element.getStartOffset();
            boolean bl3 = bl2 = element.getEndOffset() == this.getLength() + 1;
            if (bl2 && !bl) {
                --n3;
            }
            String string = this.getText(n2, n3);
            Matcher matcher = Pattern.compile(EditorPaneLinkDetector.I_B_HTTP_HTTPS_WWW_FTP_FILE_MAILTO_S_S).matcher(string);
            if (matcher.find()) {
                String string2;
                String string3 = matcher.group(1);
                matcher.group(2);
                String string4 = matcher.group(3);
                int n4 = n2 + matcher.start(3) + 1;
                if (n4 > n) {
                    return;
                }
                Matcher matcher2 = Pattern.compile("([\\W&&[^/]]+)$").matcher(string3);
                String string5 = "";
                if (matcher2.find()) {
                    string5 = matcher2.group(1);
                    string3 = matcher2.replaceFirst("");
                }
                string = matcher.replaceFirst("<a href='" + string3 + "'>" + string3 + "</a>" + string5 + string4);
                this.setOuterHTML(element, string);
                Matcher matcher3 = Pattern.compile("^(\\s+)").matcher(string);
                if (matcher3.find()) {
                    string2 = matcher3.group(1);
                    this.insertString(n2, string2, null);
                }
                if ((matcher3 = Pattern.compile("(\\s+)$").matcher(string)).find()) {
                    string2 = matcher3.group(1);
                    int n5 = element.getEndOffset();
                    if (string2.charAt(string2.length() - 1) == '\n') {
                        string2 = string2.substring(0, string2.length() - 1);
                        --n5;
                    }
                    this.insertString(Math.min(this.getLength(), n5), string2, null);
                }
            }
        }

        @Override
        public void remove(int n, int n2) throws BadLocationException {
            super.remove(n, n2);
            Element element = this.getCharacterElement(n - n2);
            this.computeLinks(element, false);
        }

        @Override
        public void insertString(int n, String string, AttributeSet attributeSet) throws BadLocationException {
            super.insertString(n, string, attributeSet);
            Element element = this.getCharacterElement(n);
            this.computeLinks(element, false);
        }
    }
}

