/*
 * Decompiled with CFR 0.152.
 */
package commvault.cte.component;

import commvault.cte.CteStringBank;
import commvault.cte.util.Logger;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.StringSelection;
import java.awt.event.ActionEvent;
import java.security.AccessController;
import java.security.PrivilegedAction;
import javax.swing.AbstractAction;
import javax.swing.text.JTextComponent;

public class CopyAction
extends AbstractAction {
    JTextComponent editorKit;

    public CopyAction(JTextComponent jTextComponent) {
        super(CteStringBank.Copy.getI18n(), null);
        if (jTextComponent != null) {
            this.editorKit = jTextComponent;
        }
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getActionCommand().equals(CteStringBank.Copy.getI18n())) {
            this.copyContentsToClipboard();
        }
    }

    private void copyContentsToClipboard() {
        AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                if (CopyAction.this.editorKit != null) {
                    Clipboard clipboard = CopyAction.this.editorKit.getToolkit().getSystemClipboard();
                    StringSelection stringSelection = new StringSelection(CopyAction.this.editorKit.getSelectedText());
                    clipboard.setContents(stringSelection, stringSelection);
                } else {
                    Logger.instance();
                    Logger.write(Logger.INFO, this, "copyContentsToClipboard", CopyAction.this.editorKit);
                }
                return null;
            }
        });
    }
}

