/*
 * Decompiled with CFR 0.152.
 */
package commvault.cte.component;

import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import javax.swing.JToggleButton;
import javax.swing.border.Border;
import javax.swing.border.TitledBorder;

public class ComponentTitledBorder
extends TitledBorder {
    protected String title;
    protected JToggleButton titleComponent = new JToggleButton();
    private Point textLoc = new Point();

    public ComponentTitledBorder(JToggleButton jToggleButton) {
        this(null, jToggleButton);
    }

    public ComponentTitledBorder(Border border, JToggleButton jToggleButton) {
        super(border, jToggleButton.getText(), 4, 2, null, null);
        this.titleComponent = jToggleButton;
    }

    @Override
    public void paintBorder(Component component, Graphics graphics, int n, int n2, int n3, int n4) {
        Border border = this.getBorder();
        if (this.getTitle() == null || this.getTitle().equals("")) {
            if (border != null) {
                border.paintBorder(component, graphics, n, n2, n3, n4);
            }
            return;
        }
        Rectangle rectangle = new Rectangle(n + 2, n2 + 2, n3 - 4, n4 - 4);
        Font font = graphics.getFont();
        Color color = graphics.getColor();
        graphics.setFont(this.getFont(component));
        FontMetrics fontMetrics = graphics.getFontMetrics();
        int n5 = fontMetrics.getHeight();
        int n6 = fontMetrics.getDescent();
        int n7 = fontMetrics.getAscent();
        int n8 = this.titleComponent.getPreferredSize().width;
        Insets insets = border != null ? border.getBorderInsets(component) : new Insets(0, 0, 0, 0);
        int n9 = this.getTitlePosition();
        switch (n9) {
            case 1: {
                int n10 = n7 + n6 + (Math.max(2, 4) - 2);
                rectangle.y += n10;
                rectangle.height -= n10;
                this.textLoc.y = rectangle.y - (n6 + 2);
                break;
            }
            case 0: 
            case 2: {
                int n11 = Math.max(0, n7 / 2 + 2 - 2);
                rectangle.y += n11;
                rectangle.height -= n11;
                this.textLoc.y = rectangle.y - n6 + (insets.top + n7 + n6) / 2;
                break;
            }
            case 3: {
                this.textLoc.y = rectangle.y + insets.top + n7 + 2;
                break;
            }
            case 4: {
                this.textLoc.y = rectangle.y + rectangle.height - (insets.bottom + n6 + 2);
                break;
            }
            case 5: {
                rectangle.height -= n5 / 2;
                this.textLoc.y = rectangle.y + rectangle.height - n6 + (n7 + n6 - insets.bottom) / 2;
                break;
            }
            case 6: {
                rectangle.height -= n5;
                this.textLoc.y = rectangle.y + rectangle.height + n7 + 2;
            }
        }
        int n12 = this.getTitleJustification();
        if (ComponentTitledBorder.isLeftToRight(component)) {
            if (n12 == 4 || n12 == 0) {
                n12 = 1;
            } else if (n12 == 5) {
                n12 = 3;
            }
        } else if (n12 == 4 || n12 == 0) {
            n12 = 3;
        } else if (n12 == 5) {
            n12 = 1;
        }
        switch (n12) {
            case 1: {
                this.textLoc.x = rectangle.x + 5 + insets.left;
                break;
            }
            case 3: {
                this.textLoc.x = rectangle.x + rectangle.width - (n8 + 5 + insets.right);
                break;
            }
            case 2: {
                this.textLoc.x = rectangle.x + (rectangle.width - n8) / 2;
            }
        }
        if (border != null) {
            if (n9 == 2 || n9 == 5 || n9 == 0) {
                Rectangle rectangle2 = new Rectangle();
                Rectangle rectangle3 = graphics.getClipBounds();
                rectangle2.setBounds(rectangle3);
                if (ComponentTitledBorder.computeIntersection(rectangle2, n, n2, this.textLoc.x, n4)) {
                    graphics.setClip(rectangle2);
                    border.paintBorder(component, graphics, rectangle.x, rectangle.y, rectangle.width, rectangle.height);
                }
                rectangle2.setBounds(rectangle3);
                if (ComponentTitledBorder.computeIntersection(rectangle2, this.textLoc.x + n8, 0, n3 - n8 - this.textLoc.x, n4)) {
                    graphics.setClip(rectangle2);
                    border.paintBorder(component, graphics, rectangle.x, rectangle.y, rectangle.width, rectangle.height);
                }
                rectangle2.setBounds(rectangle3);
                if (n9 == 2 || n9 == 0) {
                    if (ComponentTitledBorder.computeIntersection(rectangle2, this.textLoc.x, rectangle.y + insets.top, n8, n4 - rectangle.y - insets.top)) {
                        graphics.setClip(rectangle2);
                        border.paintBorder(component, graphics, rectangle.x, rectangle.y, rectangle.width, rectangle.height);
                    }
                } else if (ComponentTitledBorder.computeIntersection(rectangle2, this.textLoc.x, n2, n8, n4 - insets.bottom - (n4 - rectangle.height - rectangle.y))) {
                    graphics.setClip(rectangle2);
                    border.paintBorder(component, graphics, rectangle.x, rectangle.y, rectangle.width, rectangle.height);
                }
                graphics.setClip(rectangle3);
            } else {
                border.paintBorder(component, graphics, rectangle.x, rectangle.y, rectangle.width, rectangle.height);
            }
        }
        graphics.setColor(this.getTitleColor());
        graphics.setFont(font);
        graphics.setColor(color);
    }

    static boolean isLeftToRight(Component component) {
        return component.getComponentOrientation().isLeftToRight();
    }

    public Point getTextLocation() {
        return this.textLoc;
    }

    private static boolean computeIntersection(Rectangle rectangle, int n, int n2, int n3, int n4) {
        int n5 = Math.max(n, rectangle.x);
        int n6 = Math.min(n + n3, rectangle.x + rectangle.width);
        int n7 = Math.max(n2, rectangle.y);
        int n8 = Math.min(n2 + n4, rectangle.y + rectangle.height);
        rectangle.x = n5;
        rectangle.y = n7;
        rectangle.width = n6 - n5;
        rectangle.height = n8 - n7;
        return rectangle.width > 0 && rectangle.height > 0;
    }
}

