/*
 * Decompiled with CFR 0.152.
 */
package commvault.cte.component;

import java.awt.Component;
import java.awt.event.ItemListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.JCheckBox;
import javax.swing.JTable;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumnModel;

public class CheckBoxHeader
extends JCheckBox
implements TableCellRenderer,
MouseListener {
    protected CheckBoxHeader rendererComponent = this;
    protected int column;
    protected boolean mousePressed = false;

    public CheckBoxHeader() {
    }

    public CheckBoxHeader(ItemListener itemListener) {
        this.rendererComponent.addItemListener(itemListener);
    }

    @Override
    public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
        JTableHeader jTableHeader;
        if (jTable != null && (jTableHeader = jTable.getTableHeader()) != null) {
            this.rendererComponent.setForeground(jTableHeader.getForeground());
            this.rendererComponent.setBackground(jTableHeader.getBackground());
            this.rendererComponent.setFont(jTableHeader.getFont());
            jTableHeader.addMouseListener(this.rendererComponent);
        }
        this.setColumn(n2);
        return this.rendererComponent;
    }

    protected void setColumn(int n) {
        this.column = n;
    }

    public int getColumn() {
        return this.column;
    }

    protected void handleClickEvent(MouseEvent mouseEvent) {
        if (this.mousePressed) {
            this.mousePressed = false;
            JTableHeader jTableHeader = (JTableHeader)mouseEvent.getSource();
            JTable jTable = jTableHeader.getTable();
            TableColumnModel tableColumnModel = jTable.getColumnModel();
            int n = tableColumnModel.getColumnIndexAtX(mouseEvent.getX());
            int n2 = jTable.convertColumnIndexToModel(n);
            if (n == this.column && mouseEvent.getClickCount() == 1 && n2 != -1) {
                this.doClick();
            }
        }
    }

    @Override
    public void mouseClicked(MouseEvent mouseEvent) {
        this.handleClickEvent(mouseEvent);
        ((JTableHeader)mouseEvent.getSource()).repaint();
    }

    @Override
    public void mousePressed(MouseEvent mouseEvent) {
        this.mousePressed = true;
    }

    @Override
    public void mouseReleased(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseEntered(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseExited(MouseEvent mouseEvent) {
    }
}

