/*
 * Decompiled with CFR 0.152.
 */
package commvault.cte.component;

import com.jidesoft.swing.JideScrollPane;
import commvault.cte.component.CVJViewPort;
import commvault.cte.component.StickyButton;
import commvault.cte.component.table.NTable;
import java.awt.Component;
import java.awt.Container;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import javax.swing.BoundedRangeModel;
import javax.swing.DefaultBoundedRangeModel;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JViewport;
import javax.swing.ScrollPaneLayout;
import javax.swing.ToolTipManager;

public final class CVJScrollpane
extends JideScrollPane {
    public CVJScrollpane() {
    }

    public CVJScrollpane(Component component) {
        super(component);
    }

    public CVJScrollpane(Component component, boolean bl, String string) {
        this.getCVJViewPort().setDisplayParams(bl, string);
        this.setViewportView(component);
    }

    public CVJScrollpane(Component component, int n, int n2) {
        this(component);
        this.setVerticalScrollBarPolicy(n);
        this.setHorizontalScrollBarPolicy(n2);
    }

    public CVJScrollpane(JTable jTable, int n, int n2) {
        super((Component)jTable, n, n2);
    }

    protected final JViewport createViewport() {
        return new CVJViewPort();
    }

    public final void setViewport(JViewport jViewport) {
        if (!(jViewport instanceof CVJViewPort)) {
            throw new IllegalArgumentException("View Port for CVJScrollpane has to be an instanceof CVJViewPort");
        }
        super.setViewport(jViewport);
    }

    public final CVJViewPort getCVJViewPort() {
        return (CVJViewPort)this.getViewport();
    }

    public final void setNoItemDisplay(boolean bl) {
        this.getCVJViewPort().setNoItemDisplay(bl);
    }

    public final boolean getNoItemDisplay() {
        return this.getCVJViewPort().getNoItemDisplay();
    }

    public final void setDisplayString(String string) {
        this.getCVJViewPort().setDisplayString(string);
    }

    public final String getDisplayString() {
        return this.getCVJViewPort().getDisplayString();
    }

    public JScrollBar createVerticalScrollBar() {
        return new QuickScrollingBar(1);
    }

    public void showPageScrollButtonsForTable(final JTable jTable) {
        final StickyButton stickyButton = new StickyButton(1);
        stickyButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Rectangle rectangle = jTable.getVisibleRect();
                rectangle.y = rectangle.y - CVJScrollpane.this.getViewport().getHeight() < 0 ? 0 : (rectangle.y -= CVJScrollpane.this.getViewport().getHeight());
                jTable.scrollRectToVisible(rectangle);
            }
        });
        stickyButton.setEnabled(false);
        final StickyButton stickyButton2 = new StickyButton(5);
        stickyButton2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Rectangle rectangle = jTable.getVisibleRect();
                rectangle.y = rectangle.y + rectangle.height > jTable.getHeight() - rectangle.height ? jTable.getHeight() - rectangle.height : (rectangle.y += CVJScrollpane.this.getViewport().getHeight());
                jTable.scrollRectToVisible(rectangle);
            }
        });
        this.add(stickyButton);
        this.add(stickyButton2);
        ScrollPaneLayout scrollPaneLayout = new ScrollPaneLayout(){

            @Override
            public void layoutContainer(Container container) {
                super.layoutContainer(container);
                Rectangle rectangle = this.getVerticalScrollBar().getBounds();
                int n = stickyButton.getPreferredSize().height;
                rectangle.height -= 2 * n;
                this.getVerticalScrollBar().setBounds(rectangle);
                rectangle.y += rectangle.height;
                rectangle.height = n;
                stickyButton.setBounds(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
                rectangle.y += rectangle.height;
                stickyButton2.setBounds(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
            }
        };
        this.setLayout(scrollPaneLayout);
    }

    public class QuickScrollingBar
    extends JScrollPane.ScrollBar {
        boolean dragging;

        public QuickScrollingBar(int n) {
            int n2;
            int n3;
            super((JScrollPane)((Object)CVJScrollpane.this), n);
            this.dragging = false;
            this.setModel(new CVBoundedRangeModel());
            MouseMotionListener[] mouseMotionListenerArray = this.getMouseMotionListeners();
            for (n3 = 0; n3 < mouseMotionListenerArray.length; ++n3) {
                this.removeMouseMotionListener(mouseMotionListenerArray[n3]);
            }
            for (n3 = 0; n3 < mouseMotionListenerArray.length; ++n3) {
                this.addMouseMotionListener(new ScrollMouseMoveListener(mouseMotionListenerArray[n3]));
            }
            MouseListener[] mouseListenerArray = this.getMouseListeners();
            for (n2 = 0; n2 < mouseListenerArray.length; ++n2) {
                this.removeMouseListener(mouseListenerArray[n2]);
            }
            for (n2 = 0; n2 < mouseListenerArray.length; ++n2) {
                this.addMouseListener(new ScrollMouseListener(mouseListenerArray[n2]));
            }
            ToolTipManager.sharedInstance().registerComponent(this);
        }

        @Override
        public String getToolTipText() {
            JViewport jViewport = CVJScrollpane.this.getViewport();
            if (jViewport == null) {
                return super.getToolTipText();
            }
            Component component = jViewport.getView();
            if (component == null || !(component instanceof JTable)) {
                return super.getToolTipText();
            }
            JTable jTable = (JTable)component;
            NTable.ScrollTooltipRenderer scrollTooltipRenderer = (NTable.ScrollTooltipRenderer)jTable.getClientProperty("tooltipRenderer");
            if (scrollTooltipRenderer == null) {
                return super.getToolTipText();
            }
            BoundedRangeModel boundedRangeModel = this.getModel();
            Point point = jViewport.getViewPosition();
            point.y = boundedRangeModel.getValue();
            int n = jTable.rowAtPoint(point);
            return scrollTooltipRenderer.getTooltipText(n, jTable);
        }

        class CVBoundedRangeModel
        extends DefaultBoundedRangeModel {
            CVBoundedRangeModel() {
            }

            @Override
            protected void fireStateChanged() {
                if (QuickScrollingBar.this.dragging) {
                    return;
                }
                super.fireStateChanged();
            }
        }

        class ScrollMouseMoveListener
        implements MouseMotionListener {
            MouseMotionListener source;

            public ScrollMouseMoveListener(MouseMotionListener mouseMotionListener) {
                this.source = mouseMotionListener;
            }

            @Override
            public void mouseDragged(MouseEvent mouseEvent) {
                QuickScrollingBar.this.dragging = true;
                try {
                    this.source.mouseDragged(mouseEvent);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                ToolTipManager.sharedInstance().mouseEntered(mouseEvent);
            }

            @Override
            public void mouseMoved(MouseEvent mouseEvent) {
                if (mouseEvent.getX() >= 0 && mouseEvent.getY() >= 0) {
                    try {
                        this.source.mouseMoved(mouseEvent);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }
        }

        class ScrollMouseListener
        implements MouseListener {
            MouseListener source;

            public ScrollMouseListener(MouseListener mouseListener) {
                this.source = mouseListener;
            }

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                try {
                    this.source.mouseClicked(mouseEvent);
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }

            @Override
            public void mouseEntered(MouseEvent mouseEvent) {
                try {
                    this.source.mouseEntered(mouseEvent);
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }

            @Override
            public void mouseExited(MouseEvent mouseEvent) {
                try {
                    this.source.mouseExited(mouseEvent);
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }

            @Override
            public void mousePressed(MouseEvent mouseEvent) {
                try {
                    QuickScrollingBar.this.dragging = false;
                    this.source.mousePressed(mouseEvent);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }

            @Override
            public void mouseReleased(MouseEvent mouseEvent) {
                try {
                    QuickScrollingBar.this.dragging = false;
                    this.source.mouseReleased(mouseEvent);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
    }
}

