/*
 * Decompiled with CFR 0.152.
 */
package commvault.cte.common.xml;

import commvault.cte.CteStringBank;
import commvault.cte.common.xml.Bitwise;
import commvault.cte.common.xml.CVTime;
import commvault.cte.common.xml.XDate;
import commvault.cte.common.xml.XMLDecoder;
import commvault.cte.util.Application;
import commvault.cte.util.EnumUtil;
import commvault.cte.util.StringCategory;
import commvault.msgs.CvEntities.CVTimeRange;
import commvault.msgs.CvEntities.EntityLevel;
import commvault.msgs.CvEntities.GenericEntity;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringWriter;
import java.io.Writer;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.ParameterizedType;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class EncoderUtil {
    private static final String EMPTY = " ";
    private static final Pattern PATTERN = Pattern.compile("([A-Z]+)|[_]([_])|[_]([^_]*)");
    private static boolean useOptimizedSerialization = false;

    public static String getMessageName(Class<?> clazz) {
        String string = clazz.getPackage().getName();
        int n = (string = string.substring(string.lastIndexOf(46) + 1)).lastIndexOf("DataContract");
        if (n > -1) {
            string = string.substring(0, n);
        }
        return string + "_" + clazz.getSimpleName();
    }

    public static String getMessageName(Object object) {
        return EncoderUtil.getMessageName(object.getClass());
    }

    public static boolean isPrimitive(Field field) {
        return EncoderUtil.isPrimitive(field.getType()) || field.getAnnotation(Bitwise.class) != null;
    }

    public static Class<?> getTemplateClass(Field field) {
        return (Class)((ParameterizedType)field.getGenericType()).getActualTypeArguments()[0];
    }

    public static boolean isList(Field field) {
        return List.class.isAssignableFrom(field.getType());
    }

    public static boolean isPrimitive(Class<?> clazz) {
        return clazz.isPrimitive() || clazz.equals(String.class) || clazz.equals(Integer.class) || clazz.equals(Boolean.class) || clazz.equals(Long.class) || clazz.equals(Float.class) || clazz.equals(XMLDecoder.BYTE_ARRAY) || clazz.isEnum() || clazz.equals(Double.class);
    }

    public static String getXsdType(Class<?> clazz) {
        if (EncoderUtil.isPrimitive(clazz)) {
            if (clazz.equals(Integer.TYPE)) {
                return "xs:integer";
            }
            return "xs:" + clazz.getSimpleName().toLowerCase();
        }
        return clazz.getSimpleName();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int copy(Reader reader, Writer writer) throws IOException {
        try {
            int n = 0;
            char[] cArray = new char[4096];
            int n2 = -1;
            while ((n2 = reader.read(cArray)) != -1) {
                writer.write(cArray, 0, n2);
                n += n2;
            }
            writer.flush();
            int n3 = n;
            return n3;
        }
        finally {
            try {
                reader.close();
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
            try {
                writer.close();
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
    }

    public static String getFileContent(String string) throws Exception {
        StringWriter stringWriter = new StringWriter();
        FileReader fileReader = new FileReader(string);
        EncoderUtil.copy(fileReader, stringWriter);
        fileReader.close();
        return stringWriter.toString();
    }

    public static String getFileContent(InputStream inputStream) throws Exception {
        StringWriter stringWriter = new StringWriter();
        EncoderUtil.copy(new InputStreamReader(inputStream), stringWriter);
        return stringWriter.toString();
    }

    public static Document createDom(File file) throws SAXException, IOException, ParserConfigurationException {
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        return documentBuilderFactory.newDocumentBuilder().parse(file);
    }

    public static List<String> findAllAttribute(Node node, String string) {
        ArrayList<String> arrayList = new ArrayList<String>();
        EncoderUtil.visit(node, 0, arrayList, string);
        return arrayList;
    }

    public static void visit(Node node, int n, List<String> list, String string) {
        if (node.getAttributes() != null && node.getAttributes().getNamedItem(string) != null) {
            list.add(node.getAttributes().getNamedItem(string).getNodeValue());
        }
        NodeList nodeList = node.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node2 = nodeList.item(i);
            EncoderUtil.visit(node2, n + 1, list, string);
        }
    }

    public static String getDisplayableText(String string, StringCategory stringCategory) {
        if ((string = new String(string)).startsWith("#")) {
            string = string.substring(string.indexOf(46) + 1);
        }
        if (string.endsWith(".label")) {
            string = string.substring(0, string.length() - ".label".length());
        }
        string = string.substring(0, 1).toUpperCase() + string.substring(1);
        Pattern pattern = PATTERN;
        Matcher matcher = pattern.matcher(string);
        StringBuffer stringBuffer = new StringBuffer();
        StringBuffer stringBuffer2 = new StringBuffer();
        while (matcher.find()) {
            stringBuffer2.setLength(0);
            String string2 = matcher.group(1);
            String string3 = matcher.group(2);
            String string4 = matcher.group(3);
            if (string2 != null) {
                stringBuffer2.append(EMPTY).append(string2);
            } else if (string3 != null) {
                stringBuffer2.append("_");
            } else if (string4 != null) {
                stringBuffer2.append(EMPTY).append(string4);
            }
            matcher.appendReplacement(stringBuffer, stringBuffer2.toString());
        }
        matcher.appendTail(stringBuffer);
        return stringBuffer.toString().trim();
    }

    public static String convertToString1(Object object) {
        String string = "" + object;
        char[] cArray = string.toCharArray();
        StringBuffer stringBuffer = new StringBuffer();
        for (char c : cArray) {
            if (c == '\n') {
                stringBuffer.append("\\n");
                continue;
            }
            if (c == '\r') {
                stringBuffer.append("\\r");
                continue;
            }
            if (c == '\'') {
                stringBuffer.append("''");
                continue;
            }
            if (c == '`') {
                stringBuffer.append("'");
                continue;
            }
            if (c == '\\') {
                stringBuffer.append("\\\\");
                continue;
            }
            stringBuffer.append(c);
        }
        return stringBuffer.toString();
    }

    public static String convertToString(Object object) {
        String string = "" + object;
        char[] cArray = string.toCharArray();
        StringBuffer stringBuffer = new StringBuffer();
        for (char c : cArray) {
            if (c == '\n') {
                stringBuffer.append("\\n");
                continue;
            }
            if (c == '\t') {
                stringBuffer.append("\\t");
                continue;
            }
            if (c == '\r') {
                stringBuffer.append("\\r");
                continue;
            }
            if (c == '\\') {
                stringBuffer.append("\\\\");
                continue;
            }
            if (c == '\"') {
                stringBuffer.append("\\\"");
                continue;
            }
            stringBuffer.append(c);
        }
        return stringBuffer.toString();
    }

    public static String toString(Map<String, String> map) {
        StringBuilder stringBuilder = new StringBuilder();
        for (Map.Entry<String, String> entry : map.entrySet()) {
            stringBuilder.append(entry.getKey()).append('=').append(entry.getValue()).append('\n');
        }
        return stringBuilder.toString();
    }

    public static String getTemplateFormat(String string) throws Exception {
        return null;
    }

    public static Object getBitwiseValue(Object object, boolean bl) throws Exception {
        if (object == null) {
            return null;
        }
        int n = 0;
        int n2 = 0;
        String string = "";
        for (Field field : object.getClass().getDeclaredFields()) {
            EncoderUtil.setAccessible(field);
            Boolean bl2 = (Boolean)field.get(object);
            if (bl2 != null && bl2.booleanValue()) {
                n2 += (int)Math.pow(2.0, n);
                if (bl) {
                    string = string + field.getName() + ",";
                }
            }
            ++n;
        }
        if (bl) {
            return string;
        }
        return n2;
    }

    public static Object getBitwiseObject(Class<?> clazz, int n) throws InstantiationException, IllegalAccessException {
        Object obj = clazz.newInstance();
        int n2 = 0;
        String string = Integer.toBinaryString(n);
        int n3 = string.length();
        for (Field field : clazz.getDeclaredFields()) {
            EncoderUtil.setAccessible(field);
            if (n2 >= n3) break;
            field.set(obj, string.charAt(n3 - 1 - n2) == '1');
            ++n2;
        }
        return obj;
    }

    public static void setAccessible(final Field field) {
        AccessController.doPrivileged(new PrivilegedAction<Object>(){

            @Override
            public Object run() {
                field.setAccessible(true);
                return null;
            }
        });
    }

    public static String getClassName(File file) {
        return file.getName().substring(0, file.getName().length() - ".java".length());
    }

    public static void createFile(File file, boolean bl) throws IOException {
        if (file.exists()) {
            return;
        }
        EncoderUtil.createFile(file.getParentFile(), true);
        if (bl) {
            file.mkdir();
        } else {
            file.createNewFile();
        }
    }

    public static String encodeString(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        for (char c : string.toCharArray()) {
            if (c == '\t' || c == '\n' || c == '\r' || c >= ' ' && c <= '\ud7ff' || c >= '\ue000' && c <= '\ufffd') {
                stringBuffer.append(c);
                continue;
            }
            bl = true;
            stringBuffer.append("|#").append(Integer.toHexString(c)).append("!");
        }
        if (bl) {
            stringBuffer.insert(0, '|');
        }
        return stringBuffer.toString();
    }

    public static String decodeString(String string) {
        if (string != null && string.length() > 0 && string.charAt(0) == '|') {
            int n = 1;
            StringBuffer stringBuffer = new StringBuffer();
            boolean bl = false;
            while (n > 0) {
                int n2 = string.indexOf("|#", n);
                if (n2 > 0) {
                    int n3;
                    int n4;
                    block13: {
                        String string2;
                        n4 = Integer.MAX_VALUE;
                        n3 = 2;
                        if (string.length() > n2 + 3 && string.charAt(n2 + 3) == '!') {
                            string2 = string.substring(n2 + 2, n2 + 3);
                            n4 = Integer.parseInt(string2, 16);
                            n3 = 4;
                        } else if (string.length() > n2 + 4 && string.charAt(n2 + 4) == '!') {
                            string2 = string.substring(n2 + 2, n2 + 4);
                            n4 = Integer.parseInt(string2, 16);
                            n3 = 5;
                        } else {
                            int n5 = string.indexOf(33, n2);
                            if (n5 > 0) {
                                String string3 = string.substring(n2 + 2, n5);
                                n3 = 2 + string3.length() + 1;
                                try {
                                    n4 = Integer.parseInt(string3, 16);
                                    break block13;
                                }
                                catch (NumberFormatException numberFormatException) {
                                    stringBuffer.append(string.substring(n, n5 + 1));
                                    n = n5 + 1;
                                    continue;
                                }
                            }
                            stringBuffer.append(string.substring(n));
                            break;
                        }
                    }
                    if (n4 == 9 || n4 == 10 || n4 == 13 || n4 >= 32 && n4 <= 126 || n4 >= 57344 && n4 <= 65533 || n4 == 32) {
                        stringBuffer.append(string.substring(n, n2 += n3));
                    } else {
                        bl = true;
                        stringBuffer.append(string.substring(n, n2));
                        stringBuffer.append((char)n4);
                        n2 += n3;
                    }
                    n = n2;
                    continue;
                }
                stringBuffer.append(string.substring(n));
                break;
            }
            if (!bl) {
                stringBuffer.insert(0, '|');
            }
            return stringBuffer.toString();
        }
        return string;
    }

    public static String getDisplayValue(Object object) {
        return EncoderUtil.getDisplayValue(object, null);
    }

    public static String getDisplayValue(Object object, Field field) {
        Annotation annotation = null;
        if (object == null) {
            return null;
        }
        if (field != null) {
            try {
                annotation = field.getAnnotation(CVTime.class) != null ? field.getAnnotation(CVTime.class) : field.getAnnotation(XDate.class);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        if (object instanceof Enum) {
            return EnumUtil.getI18n((Enum)object);
        }
        if (object instanceof CVTimeRange) {
            CVTimeRange cVTimeRange = (CVTimeRange)object;
            String string = "";
            if (cVTimeRange.getFromTime() > 0) {
                string = string + CteStringBank.From_Time + ":" + new Date((long)cVTimeRange.getFromTime() * 1000L);
            }
            if (cVTimeRange.getFromTime() > 0 && cVTimeRange.getToTime() > 0) {
                string = string + EMPTY;
            }
            if (cVTimeRange.getToTime() > 0) {
                string = string + CteStringBank.From_Time + ":" + new Date((long)cVTimeRange.getToTime() * 1000L);
            }
            return string;
        }
        if (annotation != null) {
            if (Integer.parseInt(object.toString()) == 0) {
                return CteStringBank.N_SLASH_A.getI18n();
            }
            if (annotation.annotationType() == CVTime.class) {
                Date date = new Date((long)Integer.parseInt(object.toString()) * 1000L);
                SimpleDateFormat simpleDateFormat = new SimpleDateFormat("hh:mm:ss aa");
                simpleDateFormat.setTimeZone(Application.commServerTimeZone);
                return simpleDateFormat.format(date);
            }
            Date date = new Date((long)Integer.parseInt(object.toString()) * 1000L);
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat("MM/dd/yyyy hh:mm:ss aa");
            simpleDateFormat.setTimeZone(Application.commServerTimeZone);
            return simpleDateFormat.format(date);
        }
        if (object instanceof EntityLevel || object instanceof GenericEntity) {
            for (Field field2 : object.getClass().getDeclaredFields()) {
                if (field2.getType() != String.class) continue;
                EncoderUtil.setAccessible(field2);
                try {
                    String string = (String)field2.get(object);
                    if (string == null) continue;
                    return string;
                }
                catch (Exception exception) {
                    return null;
                }
            }
            return null;
        }
        if (object instanceof Boolean) {
            return (Boolean)object != false ? CteStringBank.Yes.getI18n() : CteStringBank.No.getI18n();
        }
        return object.toString();
    }

    public static void setNull(String string, Object object) {
        try {
            Field field = object.getClass().getDeclaredField(string);
            EncoderUtil.setAccessible(field);
            field.set(object, null);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public static boolean isUseOptimizedSerialization() {
        return useOptimizedSerialization;
    }

    public static void setUseOptimizedSerialization(boolean bl) {
        useOptimizedSerialization = bl;
    }

    public static void main(String[] stringArray) {
        System.out.println(EncoderUtil.getDisplayableText("SrcClientId", null));
        System.out.println(EncoderUtil.getDisplayableText("QUERY_TIMEOUT", null));
        System.out.println(EncoderUtil.getDisplayableText("test_request", null));
        System.out.println(EncoderUtil.getDisplayableText("testRequest", null));
        System.out.println(EncoderUtil.getDisplayableText("ReadTeast", null));
        System.out.println(EncoderUtil.getDisplayableText("readtest", null));
    }
}

