/*
 * Decompiled with CFR 0.152.
 */
package commvault.cte.common.workflow;

import commvault.cte.common.workflow.SystemElement;
import commvault.msgs.CvEntities.ClientEntity;
import commvault.msgs.CvEntities.UserEntity;
import commvault.msgs.CvEntities.WorkflowEntity;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.jdom2.Content;
import org.jdom2.Element;

public class WorkflowSystem {
    public static final String WORKFLOWENGINE_ENTITY = "workflowEngine";
    public static final String DESCRIPTION = "description";
    public static final String JOB_ID = "jobId";
    public static final String USER_TOKEN = "token";
    public static final String CALLER_IP = "callerIP";
    public static final String START_TIME = "startTime";
    public static final String STATUS = "status";
    public static final String VERSION = "version";
    public static final String COMMCELL_NAME = "commCellName";
    public static final String COMMCELL_HOST = "commCellHost";
    public static final String WORKFLOW_ENTITY = "workflow";
    public static final String EXECUTOR_ENTITY = "executor";
    public static final String CREATOR_ENTITY = "creator";
    public static final String LOCALE_ID = "localeId";
    public static final String WORKFLOW_ENTITY_NAME = "workflowName";
    public static final String WORKFLOW_ENTITY_ID = "workflowId";
    private static final String CLIENT_ENTITY_ID = "clientId";
    private static final String CLIENT_ENTITY_NAME = "clientName";
    private static final String USER_ENTITY_ID = "userId";
    private static final String USER_ENTITY_NAME = "userName";
    private static final List<SystemElement> systemElements = new ArrayList<SystemElement>();
    private Element element;

    public WorkflowSystem() {
        this(new Element("system"));
    }

    public WorkflowSystem(Element element) {
        this.element = element;
        this.buildElements(this.element, systemElements);
    }

    private void buildElements(Element element, List<SystemElement> list) {
        for (SystemElement systemElement : list) {
            Element element2 = element.getChild(systemElement.name);
            if (element2 == null) {
                element2 = new Element(systemElement.name);
                element.addContent((Content)element2);
            }
            element2.setAttribute("class", systemElement.type.getName());
            if (systemElement.childElements.size() <= 0) continue;
            this.buildElements(element2, systemElement.childElements);
        }
    }

    public void set(String string, Object object) {
        Element element = this.element.getChild(string);
        if (object == null) {
            element.setText("");
            return;
        }
        if (object instanceof UserEntity) {
            Element element2 = element.getChild(USER_ENTITY_ID);
            Element element3 = element.getChild(USER_ENTITY_NAME);
            element2.setText(String.valueOf(((UserEntity)object).getUserId()));
            element3.setText(((UserEntity)object).getUserName());
        } else if (object instanceof ClientEntity) {
            Element element4 = element.getChild(CLIENT_ENTITY_ID);
            Element element5 = element.getChild(CLIENT_ENTITY_NAME);
            element4.setText(String.valueOf(((ClientEntity)object).getClientId()));
            element5.setText(((ClientEntity)object).getClientName());
        } else if (object instanceof WorkflowEntity) {
            Element element6 = element.getChild(WORKFLOW_ENTITY_ID);
            Element element7 = element.getChild(WORKFLOW_ENTITY_NAME);
            element6.setText(String.valueOf(((WorkflowEntity)object).getWorkflowId()));
            element7.setText(((WorkflowEntity)object).getWorkflowName());
        } else {
            element.setText(String.valueOf(object));
        }
    }

    public void set(Element element) {
        this.element.removeChildren(element.getName());
        this.element.addContent((Content)element);
    }

    public Element getElement() {
        return this.element;
    }

    static {
        SystemElement[] systemElementArray = new SystemElement[]{new SystemElement(CLIENT_ENTITY_ID, Integer.class), new SystemElement(CLIENT_ENTITY_NAME, String.class)};
        systemElements.add(new SystemElement(WORKFLOWENGINE_ENTITY, ClientEntity.class, systemElementArray));
        SystemElement[] systemElementArray2 = new SystemElement[]{new SystemElement(WORKFLOW_ENTITY_ID, Integer.class), new SystemElement(WORKFLOW_ENTITY_NAME, String.class)};
        systemElements.add(new SystemElement(WORKFLOW_ENTITY, WorkflowEntity.class, systemElementArray2));
        systemElements.add(new SystemElement(DESCRIPTION, String.class));
        systemElements.add(new SystemElement(VERSION, Integer.class));
        SystemElement[] systemElementArray3 = new SystemElement[]{new SystemElement(USER_ENTITY_ID, Integer.class), new SystemElement(USER_ENTITY_NAME, String.class)};
        systemElements.add(new SystemElement(EXECUTOR_ENTITY, UserEntity.class, systemElementArray3));
        systemElements.add(new SystemElement(CREATOR_ENTITY, UserEntity.class, systemElementArray3));
        systemElements.add(new SystemElement(LOCALE_ID, Integer.class));
        systemElements.add(new SystemElement(COMMCELL_NAME, String.class));
        systemElements.add(new SystemElement(COMMCELL_HOST, String.class));
        systemElements.add(new SystemElement(JOB_ID, Integer.class));
        systemElements.add(new SystemElement(STATUS, String.class));
        systemElements.add(new SystemElement(START_TIME, Date.class));
        systemElements.add(new SystemElement(USER_TOKEN, String.class));
        systemElements.add(new SystemElement(CALLER_IP, String.class));
    }
}

